/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.update;

import com.inet.helpdesk.core.ticketmanager.fields.action.ActionListener;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DeletedActionUpdater
implements ActionListener {
    public void actionDeleted(int actionId) {
        TicketProcessManager manager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        manager.getProcesses().forEach(p -> {
            if (this.containsAction((TicketProcess)p, actionId)) {
                List<Activity> activities = this.renewActivities(actionId, p.getActivities());
                ArrayList<ParallelTicket> parallels = new ArrayList<ParallelTicket>();
                p.getParallelTickets().forEach(par -> {
                    List<Activity> parActivities = this.renewActivities(actionId, par.getActivities());
                    ParallelTicket copy = new ParallelTicket(par.getId(), par.getName(), parActivities, par.getStartActivityId(), par.getStartCondition(), par.isDeactivated(), par.getRelativeLatestStart());
                    parallels.add(copy);
                });
                TicketProcess ticketProcess = new TicketProcess(p.getId(), p.getName(), p.getDescription(), activities, p.getStart().getId(), parallels, p.getAutoResourceAccess(), p.canBeChangedWhenActive());
                manager.updateProcess(ticketProcess);
            }
        });
    }

    private boolean containsAction(TicketProcess p, int actionId) {
        Integer valueOf = actionId;
        for (Activity a : p.getActivities()) {
            if (!a.getPossibleActions().contains(valueOf)) continue;
            return true;
        }
        for (ParallelTicket pt : p.getParallelTickets()) {
            for (Activity a : pt.getActivities()) {
                if (!a.getPossibleActions().contains(valueOf)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Activity> renewActivities(int actionId, List<Activity> activities) {
        ArrayList<Activity> newActivities = new ArrayList<Activity>();
        activities.forEach(a -> {
            ArrayList<Integer> actionList = new ArrayList<Integer>(a.getPossibleActions());
            actionList.remove((Object)actionId);
            List<ActivityTransition> followUpActivities = a.getFollowUpActivities();
            followUpActivities = followUpActivities.stream().map(fua -> new ActivityTransition(fua.getNextActivityId(), fua.getActionLabel(), fua.getActionid(), fua.getConditionsForAutoTransition(), fua.getAutoTransitionText())).collect(Collectors.toList());
            if (a.getTicketText() == null) {
                newActivities.add(new Activity(a.getId(), a.getNextProcessToStart(), a.getType(), a.getRequiredFieldKeys(), followUpActivities, a.getName(), a.getDescription(), actionList, a.getIncomingTicketData()));
            } else {
                newActivities.add(new Activity(a.getId(), followUpActivities, a.getName(), a.getDescription(), actionList, a.getIncomingTicketData(), a.getTicketText(), a.isAppendTextOfMainTicketIntoParallel()));
            }
        });
        return newActivities;
    }
}

