/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.fields;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.AbstractTicketDefinitionForProcessAttributes;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TicketFieldDefinitionActivity
extends AbstractTicketDefinitionForProcessAttributes {
    public TicketFieldDefinitionActivity() {
        super(TicketProcessManager.ATTRIBUTE_ACTIVITY, true, false, 1000);
    }

    public String getDisplayValue(TicketVO ticket) {
        Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
        if (activity != null) {
            return activity.getName();
        }
        return null;
    }

    public String getDescription(TicketVO ticket) {
        Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
        if (activity == null) {
            return super.getDescription(ticket);
        }
        return activity.getDescription();
    }

    public Comparator<TicketVO> getComparator() {
        Comparator comp = Comparator.naturalOrder();
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    public SortGroupInformation getSortGroupInformation() {
        return new SortGroupInformation(){

            public boolean supportsSortGroups() {
                return true;
            }

            public String getSortGroupKey(TicketVO ticket) {
                Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
                return activity == null ? "" : activity.getName();
            }

            public SortGroup getSortGroupForKey(String sortGroupKey) {
                return new SortGroup(sortGroupKey);
            }
        };
    }

    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }
}

