/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.MutableProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.ServerPluginManager;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class TicketProcessPersistence {
    private Connection getConnection() throws IllegalStateException, SQLException {
        return ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<GUID, TicketProcess> loadProcesses() {
        HashMap<GUID, TicketProcess> cache = new HashMap<GUID, TicketProcess>();
        String sql = "SELECT Data FROM tblTicketProcesses";
        try (Connection conn = this.getConnection();){
            HashMap<GUID, TicketProcess> hashMap;
            block24: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            try {
                                TicketProcess process = (TicketProcess)new Json().fromJson(new String(rs.getBytes(1), StandardCharsets.UTF_8), TicketProcess.class, new HashMap(), null);
                                cache.put(process.getId(), process);
                            }
                            catch (JsonException | IllegalStateException ex) {
                                TicketProcessPlugin.LOGGER.error(ex);
                                TicketProcessPlugin.LOGGER.error((Object)("Incompatible or corrupted Process: " + new String(rs.getBytes(1), StandardCharsets.UTF_8)));
                            }
                        }
                    }
                    hashMap = cache;
                    if (stmt == null) break block24;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public MutableProcessFolder loadFolders() {
        ArrayList<DataRow> folderList = new ArrayList<DataRow>();
        String sql = "SELECT * FROM tblProcessFolders";
        try (Connection conn = this.getConnection();){
            MutableProcessFolder mutableProcessFolder;
            block22: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            List processes = (List)new Json().fromJson(new String(rs.getBytes("Processes"), StandardCharsets.UTF_8), List.class, new Type[]{GUID.class});
                            GUID folderId = GUID.valueOf((String)rs.getString("FolderUUID"));
                            String string = rs.getString("ParentUUID");
                            GUID parent = string == null ? null : GUID.valueOf((String)string);
                            String name = rs.getString("Name");
                            folderList.add(new DataRow(folderId, name, parent, processes));
                        }
                    }
                    mutableProcessFolder = this.buildTree(null, null, folderList);
                    if (stmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return mutableProcessFolder;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private MutableProcessFolder buildTree(MutableProcessFolder parent, DataRow current, List<DataRow> folderList) {
        if (current == null) {
            Optional<DataRow> root = folderList.stream().filter(r -> r.parent == null).findFirst();
            if (root.isEmpty()) {
                return null;
            }
            current = root.get();
            if (current.name == null) {
                current.name = "";
            }
        }
        MutableProcessFolder folder = new MutableProcessFolder(current.id, current.name, parent, current.processes);
        folderList.stream().filter(r -> r.parent != null && r.parent.equals((Object)folder.getId())).forEach(row -> folder.getSubFolders().add(this.buildTree(folder, (DataRow)row, folderList)));
        return folder;
    }

    public void createFolder(@Nonnull MutableProcessFolder folder) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO tblProcessFolders (FolderUUID, ParentUUID, Name, Processes) VALUES (?,?,?,?)");){
            stmt.setString(1, folder.getId().toString());
            stmt.setString(2, folder.getParent() == null ? null : folder.getParent().getId().toString());
            stmt.setString(3, folder.getName());
            stmt.setBytes(4, new Json().toJson(folder.getProcesses()).getBytes(StandardCharsets.UTF_8));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void deleteFolder(@Nonnull MutableProcessFolder folder) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM tblProcessFolders WHERE FolderUUID=?");){
            stmt.setString(1, folder.getId().toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void updateFolder(@Nonnull MutableProcessFolder folder) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("Update tblProcessFolders SET ParentUUID=?, Name=?, Processes=? WHERE FolderUUID=?");){
            stmt.setString(1, folder.getParent() == null ? null : folder.getParent().getId().toString());
            stmt.setString(2, folder.getName());
            stmt.setBytes(3, new Json().toJson(folder.getProcesses()).getBytes(StandardCharsets.UTF_8));
            stmt.setString(4, folder.getId().toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void removeProcess(@Nonnull GUID id) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM tblTicketProcesses WHERE UUID=?");){
            stmt.setString(1, id.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void updateProcess(@Nonnull TicketProcess process) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE tblTicketProcesses SET Data=? WHERE UUID=?");){
            stmt.setBytes(1, new Json().toJson((Object)process).getBytes(StandardCharsets.UTF_8));
            stmt.setString(2, process.getId().toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void createProcess(@Nonnull TicketProcess process) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO tblTicketProcesses (UUID,Data) VALUES (?,?)");){
            stmt.setString(1, process.getId().toString());
            stmt.setBytes(2, new Json().toJson((Object)process).getBytes(StandardCharsets.UTF_8));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private class DataRow {
        private GUID id;
        private String name;
        private GUID parent;
        private List<GUID> processes = new ArrayList<GUID>();

        private DataRow(GUID id, String name, GUID parent, List<GUID> processes) {
            this.id = id;
            this.name = name;
            this.parent = parent;
            this.processes = processes;
        }
    }
}

