/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ActivityTransitionAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessProgress;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.MutableProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessEventLog;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessTicketUpdater;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.TicketProcessPersistence;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.ClientMessageException;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TicketProcessManagerImpl
implements TicketProcessManager {
    public static final TicketProcessManagerImpl INSTANCE = new TicketProcessManagerImpl();
    private Map<GUID, TicketProcess> cache = new ConcurrentHashMap<GUID, TicketProcess>();
    private TicketProcessPersistence persistence = new TicketProcessPersistence();
    private ProcessTicketUpdater updater = new ProcessTicketUpdater();
    private boolean initialized;
    private Map<String, String> searchTagDataMap;
    private MutableProcessFolder rootFolder;
    private Map<Integer, Map<String, Set<String>>> processChangeClients = new ConcurrentHashMap<Integer, Map<String, Set<String>>>();

    @Override
    public void createProcess(TicketProcess process) {
        this.initializeLazy();
        this.createProcess(process, this.rootFolder.getId());
    }

    @Override
    public synchronized void createProcess(TicketProcess process, GUID folderId) {
        this.initializeLazy();
        if (this.getProcess(process.getId()) != null) {
            throw new IllegalArgumentException("Process exists already, use update() to update it: " + String.valueOf(process.getId()));
        }
        this.checkDuplicateProcessName(process, this.rootFolder.find(folderId));
        MutableProcessFolder processFolder = this.rootFolder.find(folderId);
        Objects.requireNonNull(processFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{folderId}));
        processFolder.getProcesses().add(process.getId());
        this.persistence.updateFolder(processFolder);
        this.persistence.createProcess(process);
        this.cache.put(process.getId(), process);
        this.searchTagDataMap = null;
        ProcessEventLog.ProcessAdded.log(process);
    }

    private void checkDuplicateProcessName(TicketProcess process, MutableProcessFolder targetFolder) {
        Objects.requireNonNull(targetFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{""}));
        for (GUID pId : targetFolder.getProcesses()) {
            TicketProcess p = this.cache.get(pId);
            if (p == null || process.getId().equals((Object)p.getId()) || !p.getName().equalsIgnoreCase(process.getName())) continue;
            throw new ClientMessageException(MSG.getMsg("validation.process.uniquename", new Object[]{process.getName()}));
        }
    }

    @Override
    public synchronized TicketProcessManager.UpdateProcessResult updateProcess(TicketProcess process) {
        this.assertServerIsInitialized();
        this.initializeLazy();
        TicketProcess oldProcess = this.getProcess(process.getId());
        if (oldProcess == null) {
            throw new IllegalArgumentException("Process does not exists, use create() to add it: " + String.valueOf(process.getId()));
        }
        if (oldProcess.equals(process)) {
            return new TicketProcessManager.UpdateProcessResult(true);
        }
        this.checkDuplicateProcessName(process, this.rootFolder.findProcess(process.getId()));
        this.persistence.updateProcess(process);
        this.cache.put(process.getId(), process);
        this.searchTagDataMap = null;
        TicketProcessManager.UpdateProcessResult result = this.updater.runUpdate(process.getId(), true, process);
        this.updateProcessInQuickTickets(process);
        ProcessEventLog.ProcessChanged.log(process, oldProcess.getName());
        return result;
    }

    private void updateProcessInQuickTickets(TicketProcess process) {
        if (!ServerPluginManager.getInstance().isPluginLoaded("quickticket")) {
            return;
        }
        try (UserAccountScope s = UserAccountScope.createPrivileged();){
            QuickTicketManager qtManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
            String actionIdStartProcess = ((ActionVO)ActionManager.getInstance().get(-19)).getUniqueID();
            for (GUID qtID : qtManager.getAllQuickTicketIDs()) {
                QuickTicketVO qt = qtManager.getQuickTicket(qtID);
                if (qt == null) continue;
                ArrayList actionsData = new ArrayList(qt.getActionsData());
                AtomicBoolean modified = new AtomicBoolean(false);
                qt.getActionsData().stream().filter(aadvo -> aadvo.getUniqueActionID().equals(actionIdStartProcess)).filter(aadvo -> {
                    ActiveProcess p = (ActiveProcess)aadvo.getExtensionArguments().get(TicketProcessManager.EXT_ARG_PROCESS_TO_START);
                    Boolean customized = (Boolean)aadvo.getExtensionArguments().get(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED);
                    return p != null && p.getProcessDefinition().getId().equals((Object)process.getId()) && !Boolean.TRUE.equals(customized);
                }).forEach(aadvo -> {
                    ActiveProcess p = (ActiveProcess)aadvo.getExtensionArguments().get(TicketProcessManager.EXT_ARG_PROCESS_TO_START);
                    ExtensionArguments args = aadvo.getExtensionArguments();
                    args.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START, (Object)new ActiveProcess(process, p.getSettings()));
                    ApplicableActionDataVO newVo = ApplicableActionDataVO.create((String)aadvo.getUniqueActionID(), (MutableReaStepData)aadvo.getReaStepData(), (ReaStepTextVO)aadvo.getReaStepText(), (ExtensionArguments)args);
                    actionsData.set(actionsData.indexOf(aadvo), newVo);
                    modified.set(true);
                });
                if (!modified.get()) continue;
                qtManager.updateQuickTicket(QuickTicketVO.create((GUID)qt.getID(), (String)qt.getQuickTicketName(), (MutableTicketData)qt.getTicketData(), (ExtensionArguments)qt.getExtensionArguments(), actionsData));
            }
        }
    }

    @Override
    public List<TicketProcess> getProcesses() {
        this.initializeLazy();
        return new ArrayList<TicketProcess>(this.cache.values());
    }

    @Override
    public TicketProcess getProcess(GUID id) {
        this.initializeLazy();
        return this.cache.get(id);
    }

    @Override
    public synchronized TicketProcessManager.UpdateProcessResult deleteProcess(GUID id) {
        this.assertServerIsInitialized();
        this.initializeLazy();
        TicketProcessManager.UpdateProcessResult result = this.deleteProcessOnly(id);
        MutableProcessFolder processFolder = this.rootFolder.removeProcess(id);
        this.persistence.updateFolder(processFolder);
        return result;
    }

    private TicketProcessManager.UpdateProcessResult deleteProcessOnly(GUID id) {
        this.persistence.removeProcess(id);
        TicketProcess process = this.cache.remove(id);
        this.searchTagDataMap = null;
        if (process != null) {
            TicketProcessManager.UpdateProcessResult result = this.updater.runUpdate(id, false, process);
            ProcessEventLog.ProcessDeleted.log(process);
            return result;
        }
        return new TicketProcessManager.UpdateProcessResult(true);
    }

    @Override
    public TicketProcessProgress getProgressFor(int ticketId) {
        boolean isSubTicket;
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
        if (process == null) {
            return null;
        }
        if (ticket.isSlaveInBundle() && !(ticket instanceof TicketVOSlaveForEnduser)) {
            ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
        }
        Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
        List<GUID> visitedActivities = TicketProcessManagerImpl.getVisitedActivitiesOfTicket(ticket);
        Activity start = process.getStart();
        boolean bl = isSubTicket = ticket.getAttribute(ATTRIBUTE_MAIN_TICKET) != null;
        if (isSubTicket) {
            TicketVO processMain = TicketManager.getReaderForSystem().getTicket(((Integer)ticket.getAttribute(ATTRIBUTE_MAIN_TICKET)).intValue());
            GUID parallelId = null;
            String name = null;
            Map childTickets = (Map)processMain.getAttribute(ATTRIBUTE_CHILD_TICKETS);
            for (Map.Entry en : childTickets.entrySet()) {
                if (((Integer)en.getValue()).intValue() != ticket.getID()) continue;
                start = process.getParallelTicket((GUID)en.getKey()).getStart();
                parallelId = (GUID)en.getKey();
                name = process.getParallelTicket((GUID)en.getKey()).getName();
                break;
            }
            List<TicketProcessProgress.ProgressSegment> findPath = this.findPath(start, activity, new HashSet<GUID>(), ticket, visitedActivities == null ? Collections.emptyList() : visitedActivities, new ActivityTransition(start, 4), process);
            TicketProcessProgress.ProgressTicket progressTicket = new TicketProcessProgress.ProgressTicket(ticket.getID(), parallelId, findPath, true, Status.isClosedOrDeletedStatus((int)ticket.getStatusID()), name);
            return new TicketProcessProgress(progressTicket, ticket);
        }
        List<TicketProcessProgress.ProgressSegment> mainPath = this.findPath(start, activity, new HashSet<GUID>(), ticket, visitedActivities == null ? Collections.emptyList() : visitedActivities, new ActivityTransition(start, -19), process);
        ArrayList<TicketProcessProgress.ProgressTicket> childProgress = new ArrayList<TicketProcessProgress.ProgressTicket>(process.getParallelTickets().size());
        Map childTickets = (Map)ticket.getAttribute(ATTRIBUTE_CHILD_TICKETS);
        if (childTickets == null) {
            childTickets = Collections.emptyMap();
        }
        for (ParallelTicket pt : process.getParallelTickets()) {
            TicketProcessProgress.ProgressTicket progressTicket;
            Integer subTicketId = (Integer)childTickets.get(pt.getId());
            if (subTicketId == null) {
                progressTicket = this.progress_notYetStartedTicket(ticket, process, pt);
                childProgress.add(progressTicket);
                continue;
            }
            progressTicket = this.progress_startedTicket(process, pt, subTicketId);
            childProgress.add(progressTicket);
        }
        boolean canBeChangedWhenActive = TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-37), ticket.getID()) == null;
        return new TicketProcessProgress(new TicketProcessProgress.ProgressTicket(ticket.getID(), mainPath, process.getName()), ticket, childProgress, canBeChangedWhenActive);
    }

    private TicketProcessProgress.ProgressTicket progress_startedTicket(TicketProcess process, ParallelTicket pt, int subTicketId) {
        List<TicketProcessProgress.ProgressSegment> childSegments;
        TicketVO child;
        boolean accessible = true;
        try {
            child = TicketManager.getReader().getTicket(subTicketId);
            Activity childActivity = process.getActivity((GUID)child.getAttribute(ATTRIBUTE_ACTIVITY));
            Activity childStart = pt.getStart();
            List childVisitedActivities = (List)child.getAttribute(ATTRIBUTE_VISITED_ACTIVITIES);
            childSegments = this.findPath(childStart, childActivity, new HashSet<GUID>(), child, childVisitedActivities == null ? Collections.emptyList() : childVisitedActivities, new ActivityTransition(childStart, 4), process);
        }
        catch (AccessDeniedException noaccess) {
            accessible = false;
            child = TicketManager.getReaderForSystem().getTicket(subTicketId);
            String message = Status.isClosedOrDeletedStatus((int)child.getStatusID()) ? MSG.getMsg("progress.inaccessible.finished", new Object[0]) : MSG.getMsg("progress.inaccessible.started", new Object[0]);
            childSegments = Collections.singletonList(TicketProcessProgress.ProgressSegment.createForInaccessibleTicket(message));
        }
        TicketProcessProgress.ProgressTicket progressTicket = new TicketProcessProgress.ProgressTicket(subTicketId, pt.getId(), childSegments, accessible, Status.isClosedOrDeletedStatus((int)child.getStatusID()), pt.getName());
        return progressTicket;
    }

    private TicketProcessProgress.ProgressTicket progress_notYetStartedTicket(TicketVO ticket, TicketProcess process, ParallelTicket pt) {
        List<String> startConditions;
        List<TicketProcessProgress.ProgressSegment> childSegments;
        Activity childStart = pt.getStart();
        ActiveProcess activeProcess = TicketProcessManager.getActiveProcessOfTicket(ticket);
        boolean accessible = true;
        if (process.getAutoResourceAccess() != TicketProcess.AdditionalResourceAccess.NONE || this.willParallelTicketBeAccessible(pt, ticket)) {
            childSegments = this.findPath(childStart, null, new HashSet<GUID>(), null, Collections.emptyList(), new ActivityTransition(childStart, 4), process);
            startConditions = this.buildStartConditionsString(pt, ticket);
        } else {
            accessible = false;
            String message = MSG.getMsg("progress.inaccessible.notstarted", new Object[0]);
            childSegments = Collections.singletonList(TicketProcessProgress.ProgressSegment.createForInaccessibleTicket(message));
            startConditions = Collections.emptyList();
        }
        TicketProcessProgress.ProgressTicket progressTicket = new TicketProcessProgress.ProgressTicket(pt.getId(), startConditions, childSegments, accessible, pt.getName(), activeProcess.getSettings().getParallelTicketLatestStarts().get(pt.getId()));
        return progressTicket;
    }

    private List<String> buildStartConditionsString(ParallelTicket pt, TicketVO ticket) {
        ArrayList<String> result = new ArrayList<String>(pt.getStartCondition().size());
        TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
        ProcessTickets tickets = ProcessTickets.createOldSnapshot(ticket);
        for (ProcessCondition<?> condition : pt.getStartCondition()) {
            String displayString = condition.getDisplayString(process, tickets);
            result.add(displayString);
        }
        return result;
    }

    private boolean willParallelTicketBeAccessible(ParallelTicket pt, TicketVO ticket) {
        MutableTicketData ticketData = ProcessTools.processDataToMutableTicketData(pt.getStart().getIncomingTicketData(), () -> ProcessTickets.createOldSnapshot(ticket));
        int ticketID = 0x7FFFFFF8;
        MutableTicketAttributes attrs = new MutableTicketAttributes();
        attrs.put((TicketAttribute)Tickets.ATTRIBUTE_BUNDLE_ID, (Object)ticketID);
        if (ticketData.get((TicketField)Tickets.FIELD_RESOURCE_GUID) != null) {
            attrs.put((TicketAttribute)Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, (Object)ticketID);
            attrs.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)100);
        } else {
            attrs.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)0);
        }
        attrs.put((TicketAttribute)Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID, (Object)ticketID);
        TicketVOSingle dummy = TicketVOSingle.create((int)ticketID, (MutableTicketAttributes)attrs, (MutableTicketData)ticketData);
        TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo((TicketVO)dummy);
        return ticketPermissionInfo.hasAnyAccessToTicket();
    }

    private MutableTicketData collectTicketData(ParallelTicket pt, TicketVO ticket) {
        ProcessTickets processTickets = ProcessTickets.createOldSnapshot(ticket);
        ProcessTicketData ticketData = pt.getStart().getIncomingTicketData();
        MutableTicketData data = ProcessTools.processDataToMutableTicketData(ticketData, () -> processTickets);
        ReaStepTextVO ticketText = pt.getStart().getTicketText();
        UserAccount owner = null;
        if (data.get((TicketField)Tickets.FIELD_OWNER_GUID) != null) {
            owner = UserManager.getInstance().getUserAccount((GUID)data.get((TicketField)Tickets.FIELD_OWNER_GUID));
        }
        ((DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class)).setDefaultValuesForNewTicket(ticketText, data, owner);
        return data;
    }

    @Override
    public TicketProcessProgress.ProgressTicketData getProgressTicketDataFor(int mainTicketId, GUID parallelTicketId) {
        TicketVO ticket = TicketManager.getReader().getTicket(mainTicketId);
        TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
        if (process == null) {
            return null;
        }
        ParallelTicket pt = process.getParallelTicket(parallelTicketId);
        if (pt == null) {
            return null;
        }
        MutableTicketData data = this.collectTicketData(pt, ticket);
        if (!data.containsKey((TicketField)Tickets.FIELD_CLASSIFICATION_ID)) {
            data.put((TicketField)Tickets.FIELD_CLASSIFICATION_ID, (Object)0);
        }
        MutableTicketAttributes attribs = new MutableTicketAttributes();
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, (Object)false);
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_AUTOESCALATED, (Object)false);
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, (Object)(data.get((TicketField)Tickets.FIELD_RESOURCE_GUID) != null ? Integer.valueOf(0) : null));
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID, (Object)1);
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_INQUIRY_DATE, (Object)System.currentTimeMillis());
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_ITIL_COUNT, (Object)0);
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_LAST_CHANGED, (Object)System.currentTimeMillis());
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)(data.get((TicketField)Tickets.FIELD_RESOURCE_GUID) != null ? Integer.valueOf(100) : Integer.valueOf(0)));
        attribs.put((TicketAttribute)Tickets.ATTRIBUTE_SUM_TIME, (Object)0);
        return new TicketProcessProgress.ProgressTicketData(data, attribs, pt.getStart().getTicketText());
    }

    public static List<GUID> getVisitedActivitiesOfTicket(TicketVO ticket) {
        if (ticket.isSlaveInBundle()) {
            try {
                ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        return (List)ticket.getAttribute(ATTRIBUTE_VISITED_ACTIVITIES);
    }

    @Override
    @Nonnull
    public Map<String, String> getSearchTagMapData() {
        Map<String, String> map = this.searchTagDataMap;
        if (map == null) {
            this.initializeLazy();
            map = new HashMap<String, String>();
            for (TicketProcess process : this.cache.values()) {
                String name = process.getName();
                map.put(name.toLowerCase(), name);
            }
            this.searchTagDataMap = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    private List<TicketProcessProgress.ProgressSegment> findPath(Activity a, Activity active, Set<GUID> alreadyAccessed, TicketVO ticket, List<GUID> visitedActivities, ActivityTransition transition, TicketProcess process) {
        TicketProcessProgress.ProgressState state;
        TicketProcessProgress.ProgressState progressState = active == null ? TicketProcessProgress.ProgressState.OPEN : (state = active == a ? TicketProcessProgress.ProgressState.PROCESSING : TicketProcessProgress.ProgressState.DONE);
        if (state == TicketProcessProgress.ProgressState.PROCESSING) {
            active = null;
        }
        ArrayList<TicketProcessProgress.ProgressSegment> path = new ArrayList<TicketProcessProgress.ProgressSegment>();
        ActionVO action = (ActionVO)ActionManager.getInstance().get(transition.getActionid());
        if (action == null) {
            return path;
        }
        String actionLabel = ActivityTransitionAction.generateLabelIfEmpty(action, transition, ProcessTools.startActivityOfBranchHoldingActivity(a.getId(), process));
        if (state == TicketProcessProgress.ProgressState.OPEN) {
            if (Status.isClosedOrDeletedStatus((int)action.getStatusID())) {
                path.add(TicketProcessProgress.ProgressSegment.createDummy(actionLabel));
                return path;
            }
            if (action.getId() == -2) {
                return null;
            }
        }
        if (a.getType() == Activity.Type.FinishProcess) {
            path.add(TicketProcessProgress.ProgressSegment.createDummy(actionLabel));
            return path;
        }
        if (alreadyAccessed.contains(a.getId())) {
            path.add(new TicketProcessProgress.ProgressSegment(a, state, true, actionLabel));
            return path;
        }
        alreadyAccessed.add(a.getId());
        if (state == TicketProcessProgress.ProgressState.PROCESSING && ticket != null && Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) {
            state = TicketProcessProgress.ProgressState.DONE;
            path.add(new TicketProcessProgress.ProgressSegment(a, state, actionLabel));
            return path;
        }
        if (!visitedActivities.isEmpty()) {
            visitedActivities = visitedActivities.subList(1, visitedActivities.size());
        }
        path.add(new TicketProcessProgress.ProgressSegment(a, state, actionLabel));
        ArrayList<List<TicketProcessProgress.ProgressSegment>> nextPaths = new ArrayList<List<TicketProcessProgress.ProgressSegment>>(a.getFollowUpActivities().size());
        for (ActivityTransition tra : a.getFollowUpActivities()) {
            List<TicketProcessProgress.ProgressSegment> sub;
            if (state == TicketProcessProgress.ProgressState.DONE && (visitedActivities.isEmpty() || !visitedActivities.get(0).equals((Object)tra.getNextActivityId())) || (sub = this.findPath(tra.getNextActivity(), active, new HashSet<GUID>(alreadyAccessed), ticket, visitedActivities, tra, process)) == null) continue;
            if (tra.isAutoTransition() && state == TicketProcessProgress.ProgressState.PROCESSING) {
                StringBuilder sb = new StringBuilder();
                List<ProcessCondition<?>> conditionsForAutoTransition = tra.getConditionsForAutoTransition();
                ProcessTickets ticketState = ProcessTickets.createOldSnapshot(ticket);
                for (int i = 0; i < conditionsForAutoTransition.size(); ++i) {
                    ProcessCondition<?> c = conditionsForAutoTransition.get(i);
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(i + 1).append(". ");
                    sb.append(c.getDisplayString(process, ticketState));
                }
                sub.add(0, new TicketProcessProgress.ProgressSegment(sb.toString()));
            }
            nextPaths.add(sub);
        }
        if (ProcessAnalyser.anyActionClosesTicket(a)) {
            ArrayList<TicketProcessProgress.ProgressSegment> list = new ArrayList<TicketProcessProgress.ProgressSegment>();
            list.add(TicketProcessProgress.ProgressSegment.createDummy(((ActionVO)ActionManager.getInstance().get(2)).getDisplayValue()));
            nextPaths.add(list);
        }
        if (nextPaths.size() == 1) {
            path.addAll((Collection)nextPaths.get(0));
        } else {
            path.addAll(this.findBestPathOrMerge(nextPaths, active));
        }
        return path;
    }

    private List<TicketProcessProgress.ProgressSegment> findBestPathOrMerge(List<List<TicketProcessProgress.ProgressSegment>> nextPaths, Activity active) {
        for (List<TicketProcessProgress.ProgressSegment> sub : nextPaths) {
            if (!sub.stream().anyMatch(seg -> seg.getState() == TicketProcessProgress.ProgressState.PROCESSING || active != null && seg.getActivityName().equals(active.getName()))) continue;
            return sub;
        }
        if (nextPaths.stream().anyMatch(l -> l.stream().allMatch(seg -> !seg.isBackLink()))) {
            nextPaths.removeIf(l -> l.stream().anyMatch(seg -> seg.isBackLink()));
        }
        if (nextPaths.size() > 1) {
            ArrayList<TicketProcessProgress.ProgressSegment> path = new ArrayList<TicketProcessProgress.ProgressSegment>();
            TicketProcessProgress.ProgressSegment current = null;
            while ((current = this.getLastSegmentsAreEqual(nextPaths)) != null) {
                path.add(0, current);
                nextPaths.forEach(list -> list.remove(list.size() - 1));
            }
            int numOfPaths = nextPaths.size();
            int maxWeight = 0;
            ArrayList<String> transitionNames = new ArrayList<String>();
            boolean backLink = false;
            boolean isAuto = true;
            StringBuilder conditionMessage = new StringBuilder();
            for (List<TicketProcessProgress.ProgressSegment> sub : nextPaths) {
                maxWeight = Math.max(maxWeight, sub.stream().mapToInt(seg -> seg.getWeight()).sum());
                backLink = sub.stream().anyMatch(TicketProcessProgress.ProgressSegment::isBackLink);
                if (sub.isEmpty() || sub.get(0).getState() != TicketProcessProgress.ProgressState.AUTO_TRANSITION) {
                    isAuto = false;
                } else {
                    if (conditionMessage.length() > 0) {
                        conditionMessage.append("\n- " + MSG.getMsg("condition.tooltip.separator", new Object[0]) + " ------------\n");
                    }
                    conditionMessage.append(sub.get(0).getConditionMessage());
                }
                if (sub.isEmpty()) continue;
                if (sub.get(0).getState() == TicketProcessProgress.ProgressState.AUTO_TRANSITION) {
                    transitionNames.add(sub.get(0).getConditionMessage());
                    continue;
                }
                transitionNames.addAll(sub.get(0).getNamesOfTransitionsOfThisActivity());
            }
            path.add(0, new TicketProcessProgress.ProgressSegment(maxWeight, numOfPaths, backLink, null, transitionNames));
            if (isAuto) {
                path.add(0, new TicketProcessProgress.ProgressSegment(conditionMessage.toString()));
            }
            return path;
        }
        if (nextPaths.size() == 1) {
            return nextPaths.get(0);
        }
        return new ArrayList<TicketProcessProgress.ProgressSegment>();
    }

    private TicketProcessProgress.ProgressSegment getLastSegmentsAreEqual(List<List<TicketProcessProgress.ProgressSegment>> nextPaths) {
        TicketProcessProgress.ProgressSegment s = null;
        for (List<TicketProcessProgress.ProgressSegment> list : nextPaths) {
            if (list.isEmpty()) {
                return null;
            }
            TicketProcessProgress.ProgressSegment seg = list.get(list.size() - 1);
            if (list.size() == 1 && seg.getState() == TicketProcessProgress.ProgressState.DUMMY) {
                return null;
            }
            if (s == null) {
                s = seg;
                continue;
            }
            if (s.equals(seg)) continue;
            return null;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLazy() {
        if (!this.initialized) {
            TicketProcessManagerImpl ticketProcessManagerImpl = this;
            synchronized (ticketProcessManagerImpl) {
                if (!this.initialized) {
                    this.cache = this.persistence.loadProcesses();
                    this.searchTagDataMap = null;
                    this.rootFolder = this.persistence.loadFolders();
                    if (this.rootFolder == null) {
                        List<GUID> processes = this.cache.values().stream().map(TicketProcess::getId).collect(Collectors.toList());
                        this.rootFolder = new MutableProcessFolder(GUID.generateNew(), "", null, processes);
                        this.persistence.createFolder(this.rootFolder);
                    }
                    for (GUID process : this.cache.keySet()) {
                        MutableProcessFolder folder = this.rootFolder.findProcess(process);
                        if (folder != null) continue;
                        this.rootFolder.getProcesses().add(process);
                        this.persistence.updateFolder(folder);
                        TicketProcessPlugin.LOGGER.warn((Object)String.format("Found process %s wihtout any folder, put into root folder.", this.cache.get(process).getName()));
                    }
                    this.initialize_patchCorruptedFolder(this.rootFolder);
                    this.initialized = true;
                    this.updater.init(this);
                }
            }
        }
    }

    private void initialize_patchCorruptedFolder(MutableProcessFolder f) {
        Iterator<GUID> iterator = f.getProcesses().iterator();
        while (iterator.hasNext()) {
            GUID process = iterator.next();
            if (this.cache.containsKey(process)) continue;
            TicketProcessPlugin.LOGGER.warn((Object)String.format("Found process %s in folder \"%s\" which does not exist. Remove from folder.", process.toString(), f.getName()));
            iterator.remove();
            this.persistence.updateFolder(f);
        }
        for (MutableProcessFolder sub : f.getSubFolders()) {
            this.initialize_patchCorruptedFolder(sub);
        }
    }

    private void assertServerIsInitialized() {
        if (VetoManager.getInstance().isCurrentlyVetoed()) {
            throw new IllegalStateException("This method cannot be called before the server was completely started. Please check on the start page what the server is waiting for (veto)");
        }
    }

    @Override
    public GUID createFolder(GUID parent, String folderName) {
        return this.createFolder(null, parent, folderName);
    }

    @Override
    public synchronized GUID createFolder(GUID id, GUID parent, String folderName) {
        Objects.requireNonNull(folderName);
        if (folderName.length() > 100) {
            throw new IllegalArgumentException(MSG.getMsg("validation.folder.namelength", new Object[]{100}));
        }
        this.initializeLazy();
        MutableProcessFolder parentFolder = parent == null ? this.rootFolder : this.rootFolder.find(parent);
        Objects.requireNonNull(parentFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{parent}));
        if (parentFolder.getSubFolders().stream().anyMatch(f -> f.getName().equals(folderName))) {
            throw new IllegalArgumentException(MSG.getMsg("validation.folder.alreadyExists", new Object[]{folderName}));
        }
        if (id == null) {
            id = GUID.generateNew();
        } else if (this.rootFolder.find(id) != null) {
            throw new IllegalArgumentException(MSG.getMsg("validation.folder.alreadyExists", new Object[]{id.toString()}));
        }
        MutableProcessFolder folder = new MutableProcessFolder(id, folderName, parentFolder, new ArrayList<GUID>());
        this.persistence.createFolder(folder);
        parentFolder.getSubFolders().add(folder);
        return id;
    }

    @Override
    public synchronized boolean deleteFolder(GUID folderId) {
        Objects.requireNonNull(folderId, "Dear tester, the root folder cannot be deleted.");
        this.assertServerIsInitialized();
        this.initializeLazy();
        MutableProcessFolder folder = this.rootFolder.find(folderId);
        if (folder == null || folder == this.rootFolder) {
            return false;
        }
        folder.getParent().getSubFolders().remove(folder);
        this.deleteProcessesAndFolderRecursively(folder);
        return true;
    }

    private void deleteProcessesAndFolderRecursively(MutableProcessFolder folder) {
        for (GUID process : folder.getProcesses()) {
            this.deleteProcessOnly(process);
        }
        for (MutableProcessFolder sub : folder.getSubFolders()) {
            this.deleteProcessesAndFolderRecursively(sub);
        }
        this.persistence.deleteFolder(folder);
    }

    @Override
    public TicketProcessFolder getRootFolder() {
        return this.getFolder(null);
    }

    @Override
    public synchronized TicketProcessFolder getFolder(GUID folderId) {
        this.initializeLazy();
        MutableProcessFolder folder = this.rootFolder.find(folderId);
        if (folder == null) {
            return null;
        }
        TicketProcessFolder root = this.rootFolder.toImmutable(this.cache);
        if (folderId == null) {
            return root;
        }
        return this.findTheFoler(root, folderId);
    }

    private TicketProcessFolder findTheFoler(TicketProcessFolder f, GUID folderId) {
        if (f.getId().equals((Object)folderId)) {
            return f;
        }
        for (TicketProcessFolder child : f.getSubFolders()) {
            TicketProcessFolder sub = this.findTheFoler(child, folderId);
            if (sub == null) continue;
            return sub;
        }
        return null;
    }

    @Override
    public synchronized void moveProcess(GUID processId, GUID folderId) {
        this.initializeLazy();
        MutableProcessFolder processFolder = this.rootFolder.find(folderId);
        Objects.requireNonNull(processFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{folderId}));
        this.checkDuplicateProcessName(this.cache.get(processId), processFolder);
        MutableProcessFolder folderWhereWasRemoved = this.rootFolder.removeProcess(processId);
        if (folderWhereWasRemoved != null) {
            this.persistence.updateFolder(folderWhereWasRemoved);
        }
        processFolder.getProcesses().add(processId);
        this.persistence.updateFolder(processFolder);
    }

    @Override
    public synchronized void moveFolder(GUID folderId, GUID newParent, String newName) {
        MutableProcessFolder parentFolder;
        this.initializeLazy();
        if (folderId == null || folderId.equals((Object)this.rootFolder.getId())) {
            throw new IllegalArgumentException("Dear tester, the root cannot be moved away.");
        }
        MutableProcessFolder processFolder = this.rootFolder.find(folderId);
        Objects.requireNonNull(processFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{folderId}));
        if (newName.length() > 100) {
            throw new IllegalArgumentException(MSG.getMsg("validation.folder.namelength", new Object[]{100}));
        }
        if (newParent == null) {
            newParent = this.rootFolder.getId();
        }
        if (!Objects.equals(newParent, processFolder.getParent().getId())) {
            parentFolder = this.rootFolder.find(newParent);
            Objects.requireNonNull(parentFolder, MSG.getMsg("validation.folder.doesNotExist", new Object[]{newParent}));
            for (MutableProcessFolder p = parentFolder; p != null; p = p.getParent()) {
                if (!p.getId().equals((Object)folderId)) continue;
                throw new IllegalArgumentException(MSG.getMsg("validation.folder.cannotmoveToOwnSubTree", new Object[0]));
            }
        } else {
            parentFolder = processFolder.getParent();
        }
        if (parentFolder.getSubFolders().stream().anyMatch(f -> f.getName().equals(newName) && !f.getId().equals((Object)folderId))) {
            throw new IllegalArgumentException(MSG.getMsg("validation.folder.alreadyExists", new Object[]{newName}));
        }
        if (!newParent.equals((Object)processFolder.getParent().getId())) {
            processFolder.getParent().getSubFolders().remove(processFolder);
            parentFolder.getSubFolders().add(processFolder);
            processFolder.setParent(parentFolder);
        }
        processFolder.setName(newName);
        this.persistence.updateFolder(processFolder);
    }

    @Override
    public void registerClientForAsyncUpdatesOfProcessesInTickets(String clientId) {
        this.updater.addWebSocketClient(clientId);
    }

    @Override
    public void unregisterClientForAsyncUpdatesOfProcessesInTickets(String clientId) {
        this.updater.removeWebSocketClient(clientId);
    }

    @Override
    public void registerClientForChangesInProcess(String clientId, String componentKey, int ticketId) {
        Set<String> set;
        Map<String, Set<String>> map = this.processChangeClients.get(ticketId);
        if (map == null) {
            map = new ConcurrentHashMap<String, Set<String>>();
            this.processChangeClients.put(ticketId, map);
        }
        if ((set = map.get(clientId)) == null) {
            set = ConcurrentHashMap.newKeySet();
            map.put(clientId, set);
        }
        set.add(componentKey);
        WebSocketEventHandler.getInstance().sendEvent(clientId, () -> new WebSocketEventData("ticketprocess.overview.progress", (Object)this.getProgressFor(ticketId)));
    }

    @Override
    public void unregisterClientForChangesInProcess(String clientId, String componentKey, int ticketId) {
        Set<String> set;
        Map<String, Set<String>> map = this.processChangeClients.get(ticketId);
        if (map != null && (set = map.get(clientId)) != null) {
            set.remove(componentKey);
            if (set.isEmpty()) {
                map.remove(clientId);
            }
            if (map.isEmpty()) {
                this.processChangeClients.remove(ticketId);
            }
        }
    }

    @Override
    public void unregisterClientForAllChanges(String clientId) {
        for (Map.Entry<Integer, Map<String, Set<String>>> en : this.processChangeClients.entrySet()) {
            en.getValue().remove(clientId);
            if (!en.getValue().isEmpty()) continue;
            this.processChangeClients.remove(en.getKey());
        }
    }

    private void sendChangesInProcess(int mainTicketId) {
        Map<String, Set<String>> set = this.processChangeClients.get(mainTicketId);
        if (set != null) {
            TicketProcessProgress progressFor = this.getProgressFor(mainTicketId);
            set.keySet().forEach(clientId -> WebSocketEventHandler.getInstance().sendEvent(clientId, () -> new WebSocketEventData("ticketprocess.overview.progress", (Object)progressFor)));
        }
    }

    public TicketEventListener getTicketListenerForRegistration() {
        return new TicketEventListener(){

            public void handleEvent(TicketEvent event) {
                HashSet ticketToSendEventFor = new HashSet();
                event.getChangedTickets().forEach(ct -> {
                    TicketVO newTicket = ct.getNewTicket();
                    if (newTicket != null && !newTicket.isSlaveInBundle()) {
                        TicketVO oldTicket;
                        TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(newTicket);
                        if (processOfTicket == null && (oldTicket = ct.getOldTicket()) != null) {
                            processOfTicket = TicketProcessManager.getProcessOfTicket(oldTicket);
                        }
                        if (processOfTicket != null) {
                            Integer mainTicketId = (Integer)newTicket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
                            if (mainTicketId == null) {
                                ticketToSendEventFor.add(newTicket.getID());
                            } else {
                                ticketToSendEventFor.add(mainTicketId);
                            }
                        }
                    }
                });
                ticketToSendEventFor.forEach(id -> TicketProcessManagerImpl.this.sendChangesInProcess((int)id));
            }
        };
    }
}

