/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ActivityTransitionAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessRef;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.StartProcessActionExtension;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessOperations {
    private static ThreadLocal<Stack<Operation>> operationStack = new ThreadLocal<Stack<Operation>>(){

        @Override
        protected Stack<Operation> initialValue() {
            return new Stack<Operation>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onNextActivity(OperationChangedTicket ticket, OperationNewReaStep reaStep, Activity nextActivity, ActionVO action) {
        MutableReaStepData groupingData = ProcessOperations.createGroupingData(ticket, reaStep);
        reaStep.getFields().putAll(groupingData);
        try (WithAdditionalReaStepData xx = WithAdditionalReaStepData.create((MutableReaStepData)groupingData);){
            operationStack.get().push(new Operation((GUID)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY), nextActivity.getId(), action));
            ProcessOperations.checkForEndlessLoop(ticket);
            ProcessOperations.createActivityChangedReaStep(nextActivity, ticket);
            ProcessOperations.applyTicketFieldsAccordingToActivity(nextActivity, ticket, action);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ACTIVITY, (Object)nextActivity.getId());
            ProcessOperations.updateVisitedActivities(ticket, nextActivity);
            ProcessOperations.checkConditions(ticket);
            ProcessOperations.checkAndPerformProcessEnding(nextActivity, ticket, action);
        }
        finally {
            operationStack.get().pop();
        }
    }

    private static void checkForEndlessLoop(OperationChangedTicket ticket) {
        Operation last = operationStack.get().peek();
        int stackSize = operationStack.get().size();
        if (operationStack.get().stream().anyMatch(oper -> oper != last && oper.equals(last)) || stackSize > 30) {
            StringBuilder msg = new StringBuilder();
            for (Operation op : operationStack.get()) {
                msg.append(op.toString(ProcessOperations.getProcessOfTicket(ticket))).append(".\n");
            }
            throw new IllegalStateException("Cyclic operation detected: The operation seems to trigger operations which again trigger operations - endlessly. Please take a look at your process. The conditions for automatic transitions are likely to be all fulfilled and execute in a loop.\nThe following would be performed:\n" + msg.toString());
        }
    }

    private static void updateVisitedActivities(OperationChangedTicket ticket, Activity nextActivity) {
        List<GUID> visitedActivities = (List<GUID>)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES);
        if (visitedActivities.contains(nextActivity.getId())) {
            visitedActivities = visitedActivities.subList(0, visitedActivities.indexOf(nextActivity.getId()) + 1);
        } else {
            visitedActivities.add(nextActivity.getId());
        }
        ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, visitedActivities);
    }

    private static void checkAndPerformProcessEnding(Activity nextActivity, OperationChangedTicket ticket, ActionVO action) {
        if (nextActivity.getType() == Activity.Type.FinishProcess) {
            if (nextActivity.getNextProcessToStart() != null) {
                TicketProcess process = ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getProcess(nextActivity.getNextProcessToStart());
                if (process == null) {
                    TicketProcess currentProcess = (TicketProcess)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_PROCESS);
                    throw new IllegalStateException(TicketProcessManager.MSG.getMsg("handling.error.nextProcessDoesNotExist", new Object[]{currentProcess.getName()}));
                }
                ActionVO startProcess = (ActionVO)ActionManager.getInstance().get(-19);
                ExtensionArguments args = ExtensionArguments.ofSingleArg(TicketProcessManager.EXT_ARG_PROCESS_TO_START, (Object)process.toActiveProcessWithoutModifications());
                TicketManager.extending().getTicketInnerOperations().applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), startProcess, args);
            } else {
                ProcessOperations.finishProcess(ticket);
            }
        } else if (ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_PROCESS_START_DATE) != null && Status.isClosedOrDeletedStatus((int)action.getStatusID())) {
            ProcessOperations.closeAllParallelTickets(ticket, false);
        }
    }

    private static void finishProcess(OperationChangedTicket ticket) {
        ActionVO finishProcess = (ActionVO)ActionManager.getInstance().get(-34);
        ExtensionArguments args = ExtensionArguments.create();
        TicketManager.extending().getTicketInnerOperations().applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), finishProcess, args);
    }

    public static void closeAllParallelTickets(OperationChangedTicket ticket, boolean processWasLeft) {
        TicketOperationModel model = ticket.getParentModel();
        ProcessTickets tickets = new ProcessTickets(ticket, ProcessOperations.getProcessOfTicket(ticket));
        for (TicketVO child : tickets.getSubTickets().values()) {
            OperationChangedTicket subTicket;
            if (processWasLeft) {
                subTicket = model.changeExistingTicket(child.getID());
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, null);
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ACTIVITY, null);
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_MAIN_TICKET, null);
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, null);
            }
            if (Status.isClosedOrDeletedStatus((int)child.getStatusID())) continue;
            subTicket = model.changeExistingTicket(child.getID());
            MutableReaStepData data = new MutableReaStepData();
            String msg = processWasLeft ? TicketProcessManager.MSG.getMsg("reastep.deleteParallelTicketOnProcessleft", new Object[0]) : TicketProcessManager.MSG.getMsg("reastep.closeParallelTicket", new Object[0]);
            data.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)msg);
            ReaStepTextVO text = ReaStepTextVO.empty();
            ActionVO action = (ActionVO)ActionManager.getInstance().get(2);
            ExtensionArguments args = ExtensionArguments.create();
            args.put(TicketProcessManager.EXT_ARG_TRANSITION_SUB_OPERATION, (Object)true);
            TicketManager.extending().getTicketInnerOperations().applyAction(subTicket, data, text, action, args);
        }
    }

    private static void createActivityChangedReaStep(Activity nextActivity, OperationChangedTicket ticket) {
        Activity activity;
        MutableReaStepData stepData = new MutableReaStepData();
        TicketProcess processOfTicket = ProcessOperations.getProcessOfTicket(ticket);
        GUID oldActivity = (GUID)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY);
        String newActivityName = nextActivity.getName();
        Object description = StartProcessActionExtension.maxlen(newActivityName, 255);
        if (oldActivity != null && (activity = processOfTicket.getActivity(oldActivity)) != null) {
            String oldActivityName = activity.getName();
            description = StartProcessActionExtension.maxlen(oldActivityName, 124) + " -> " + StartProcessActionExtension.maxlen(newActivityName, 124);
        }
        stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, description);
        ticket.addReaStep(-18, stepData, null);
    }

    public static MutableReaStepData createGroupingData(OperationChangedTicket ticket, OperationNewReaStep reaStep) {
        MutableReaStepData r = new MutableReaStepData();
        r.put((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP, (Object)reaStep.getReaStepId());
        TicketProcess process = ProcessOperations.getProcessOfTicket(ticket);
        r.put(TicketProcessManager.REASTEP_FIELD_PROCESS, (Object)new ProcessRef(process.getId(), process.getName()));
        return r;
    }

    private static void applyTicketFieldsAccordingToActivity(Activity nextActivity, OperationChangedTicket ticket, ActionVO action) {
        ProcessTicketData ticketData = nextActivity.getIncomingTicketData();
        if (ticketData.isEmpty()) {
            return;
        }
        TicketProcess process = ProcessOperations.getProcessOfTicket(ticket);
        ProcessTickets processTickets = new ProcessTickets(ticket, process);
        MutableTicketData incomingTicketData = ProcessTools.processDataToMutableTicketData(ticketData, () -> processTickets);
        if (incomingTicketData.containsKey((TicketField)Tickets.FIELD_RESOURCE_GUID) && ticket.createIntermediateTicketVO().isDispatched() && action.getId() != 8 && action.getId() != 5 && action.getId() != 4) {
            GUID targetResourceId = (GUID)incomingTicketData.get((TicketField)Tickets.FIELD_RESOURCE_GUID);
            if (!Objects.equals(ticket.getFieldValue((TicketField)Tickets.FIELD_RESOURCE_GUID), targetResourceId)) {
                Integer statusBeforeEscalation = (Integer)ticket.getAttributeValue((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID);
                if (!Status.isClosedOrDeletedStatus((int)statusBeforeEscalation)) {
                    statusBeforeEscalation = null;
                }
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(8);
                ExtensionArguments args = ExtensionArguments.create();
                args.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)targetResourceId, (boolean)true));
                args.put(TicketProcessManager.EXT_ARG_TRANSITION_SUB_OPERATION, (Object)Boolean.TRUE);
                TicketManager.extending().getTicketInnerOperations().applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), actionVO, args);
                if (statusBeforeEscalation != null) {
                    ticket.getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)statusBeforeEscalation);
                }
            }
        }
        if (action.getId() == 8) {
            incomingTicketData.remove((TicketField)Tickets.FIELD_RESOURCE_GUID);
        }
        ticket.getNewTicketData().putAll(incomingTicketData);
        ticket.createFieldChangeReaStepsIfNeeded(new MutableReaStepData());
    }

    public static void checkConditionsAfterClosingParallelTicket(OperationChangedTicket ticket, ActionVO action) {
        try {
            operationStack.get().push(new Operation((GUID)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY), null, action));
            ProcessOperations.checkConditions(ticket);
        }
        finally {
            operationStack.get().pop();
        }
    }

    public static void checkConditions(OperationChangedTicket ticket) {
        TicketProcess process = ProcessOperations.getProcessOfTicket(ticket);
        ProcessTickets processTickets = new ProcessTickets(ticket, process);
        if (Status.isClosedOrDeletedStatus((int)processTickets.getMainTicket().getStatusID())) {
            return;
        }
        for (ParallelTicket pt : process.getParallelTickets()) {
            if (pt.isDeactivated() || !ProcessOperations.checkForAndCreateParallelTickets(pt, processTickets, ticket.getParentModel())) continue;
            return;
        }
        for (TicketVO subTicket : processTickets.allTickets()) {
            if (!ProcessOperations.checkForAndPerformAutoTransition(processTickets, subTicket, ticket.getParentModel())) continue;
            return;
        }
    }

    private static boolean checkForAndCreateParallelTickets(ParallelTicket pt, ProcessTickets processTickets, TicketOperationModel model) {
        if (pt.getStartCondition().isEmpty() && !processTickets.getSubTickets().containsKey(pt.getId())) {
            ProcessOperations.createParallelTicket(pt, processTickets, model);
            return true;
        }
        if (processTickets.getSubTickets().containsKey(pt.getId())) {
            if (ProcessOperations.allConditionsAreCompleted(pt.getStartCondition(), processTickets) && ProcessOperations.oneConditionWasJustReCompleted(pt.getStartCondition(), processTickets)) {
                ActiveProcess activeProcessOfTicket = TicketProcessManager.getActiveProcessOfTicket(processTickets.getMainTicket());
                Long latestStart = activeProcessOfTicket.getSettings().getParallelTicketLatestStarts().get(pt.getId());
                if (latestStart != null && latestStart < System.currentTimeMillis()) {
                    return false;
                }
                if (operationStack.get().stream().anyMatch(op -> op.from == null && op.to != null && op.to.equals((Object)pt.getStartActivityId()))) {
                    return false;
                }
                if (ProcessOperations.resetParallelTicketToStart(pt, processTickets.getSubTickets().get(pt.getId()), model)) {
                    return true;
                }
            }
        } else if (ProcessOperations.allConditionsAreCompleted(pt.getStartCondition(), processTickets)) {
            ProcessOperations.createParallelTicket(pt, processTickets, model);
            return true;
        }
        return false;
    }

    private static boolean oneConditionWasJustReCompleted(List<ProcessCondition<?>> startCondition, ProcessTickets processTickets) {
        TicketProcess process = processTickets.getProcess();
        return startCondition.stream().anyMatch(cond -> operationStack.get().stream().anyMatch(op -> {
            if (cond.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                if (op.from != null && Status.isClosedOrDeletedStatus((int)op.action.getStatusID())) {
                    GUID id = ProcessTools.parallelTicketHoldingActivity(op.from, process).getId();
                    return id.equals((Object)((ProcessProgressingConditionValue)cond.getValue()).getItemId());
                }
                return false;
            }
            if (cond.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier())) {
                if (op.from != null && op.to != null) {
                    return op.from.equals((Object)((ProcessProgressingConditionValue)cond.getValue()).getItemId());
                }
                return false;
            }
            if (cond.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier())) {
                if (op.to != null) {
                    return op.to.equals((Object)((ProcessProgressingConditionValue)cond.getValue()).getItemId());
                }
                return false;
            }
            return false;
        }));
    }

    private static boolean resetParallelTicketToStart(ParallelTicket pt, TicketVO ticketVO, TicketOperationModel model) {
        if (pt.getStart().getId().equals(ticketVO.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY)) && !Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID())) {
            return false;
        }
        try (UserAccountScope s = UserAccountScope.createPrivileged();){
            OperationChangedTicket ticket = model.changeExistingTicket(ticketVO.getID());
            MutableReaStepData data = new MutableReaStepData();
            data.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)TicketProcessManager.MSG.getMsg("reastep.resetParallelTicket", new Object[0]));
            ExtensionArguments args = ExtensionArguments.ofSingleArg(TicketProcessManager.EXT_ARG_TRANSITION_SUB_OPERATION, (Object)Boolean.TRUE);
            ActionVO action = Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID()) ? (ActionVO)ActionManager.getInstance().get(-2) : (ActionVO)ActionManager.getInstance().get(-36);
            OperationNewReaStep addedReaStep = TicketManager.extending().getTicketInnerOperations().applyAction(ticket, data, ReaStepTextVO.empty(), action, args);
            if (pt.getStart().getId().equals(ticketVO.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY))) {
                ProcessOperations.checkConditions(ticket);
                boolean bl = true;
                return bl;
            }
            ProcessOperations.onNextActivity(ticket, addedReaStep, pt.getStart(), action);
            boolean bl = true;
            return bl;
        }
    }

    public static TicketProcess getProcessOfTicket(OperationChangedTicket ticket) {
        TicketProcess p = (TicketProcess)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_PROCESS);
        if (p != null) {
            return p;
        }
        return null;
    }

    public static void createParallelTicket(ParallelTicket pt, ProcessTickets processTickets, TicketOperationModel model) {
        try (UserAccountScope priv = UserAccountScope.createPrivileged();){
            ExtensionArguments args = ExtensionArguments.create();
            args.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.IF_RESOURCE_AVAILABLE);
            ReaStepTextVO text = pt.getStart().getTicketText();
            if (pt.getStart().isAppendTextOfMainTicketIntoParallel()) {
                Optional<OperationNewReaStep> anfrage;
                ReaStepTextVO mainText = null;
                Optional<OperationChangedTicket> first = model.getChangedTickets().stream().filter(t -> t.getTicketId() == processTickets.getMainTicket().getID()).findFirst();
                if (first.isPresent() && (anfrage = first.get().getAddedReaSteps().stream().filter(s -> (Integer)s.getAttributes().get((ReaStepAttribute)ReaStepVO.ATTRIBUTE_ACTION_ID) == 4).findFirst()).isPresent()) {
                    mainText = anfrage.get().getText().toVO();
                }
                if (mainText == null) {
                    mainText = TicketManager.getReader().getReaStepText(processTickets.getMainTicket().getInitialReaStepID());
                }
                if (mainText != null && !mainText.isEmpty()) {
                    text = ReaStepTextVO.concatenateOriginalInitialTextWithNewOne((ReaStepTextVO)text, (ReaStepTextVO)mainText);
                }
            }
            MutableTicketData data = ProcessTools.processDataToMutableTicketData(pt.getStart().getIncomingTicketData(), () -> processTickets);
            OperationChangedTicket newTicket = TicketManager.extending().getTicketInnerOperations().createTicket(data, text, args, model);
            newTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)processTickets.getProcess());
            newTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_MAIN_TICKET, (Object)processTickets.getMainTicket().getID());
            newTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, new ArrayList());
            HashSet<Integer> links = new HashSet<Integer>();
            links.add(processTickets.getMainTicket().getID());
            newTicket.getNewTicketData().put((TicketField)Tickets.FIELD_LINKS, links);
            OperationChangedTicket mainTicket = model.changeExistingTicket(processTickets.getMainTicket().getID());
            Map children = (Map)mainTicket.getAttributeValue(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS);
            children.put(pt.getId(), newTicket.getTicketId());
            mainTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS, (Object)children);
            HashSet<Integer> mainLinks = (HashSet<Integer>)mainTicket.getFieldValue((TicketField)Tickets.FIELD_LINKS);
            if (mainLinks == null) {
                mainLinks = new HashSet<Integer>();
            }
            mainLinks.add(newTicket.getTicketId());
            mainTicket.getNewTicketData().put((TicketField)Tickets.FIELD_LINKS, mainLinks);
            ProcessOperations.onNextActivity(newTicket, (OperationNewReaStep)newTicket.getAddedReaSteps().get(0), pt.getStart(), (ActionVO)ActionManager.getInstance().get(4));
        }
        catch (RuntimeException ex) {
            String prefix = TicketProcessManager.MSG.getMsg("handling.error.parallelticketprefix", new Object[]{pt.getName()});
            if (ex.getMessage() != null && ex.getMessage().startsWith(prefix.substring(0, 15))) {
                throw ex;
            }
            throw new RuntimeException(prefix + " " + ex.getMessage(), ex);
        }
    }

    private static boolean checkForAndPerformAutoTransition(ProcessTickets processTickets, TicketVO ticket, TicketOperationModel model) {
        if (Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) {
            return false;
        }
        Activity a = processTickets.getProcess().getActivity((GUID)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY));
        for (ActivityTransition tra : a.getFollowUpActivities()) {
            if (!tra.isAutoTransition() || !ProcessOperations.allConditionsAreCompleted(tra.getConditionsForAutoTransition(), processTickets)) continue;
            try (UserAccountScope priv = UserAccountScope.createPrivileged();){
                MutableReaStepData reaStepData = new MutableReaStepData();
                reaStepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)TicketProcessManager.MSG.getMsg("reastep.autoTransition", new Object[]{StartProcessActionExtension.maxlen(a.getName(), 255)}));
                ReaStepTextVO text = ReaStepTextVO.of((String)tra.getAutoTransitionText(), (boolean)false);
                ActivityTransitionAction action = new ActivityTransitionAction((ActionVO)ActionManager.getInstance().get(tra.getActionid()), tra, processTickets.getProcess());
                ExtensionArguments args = ExtensionArguments.create();
                TicketManager.extending().getTicketInnerOperations().applyAction(model.changeExistingTicket(ticket.getID()), reaStepData, text, (ActionVO)action, args);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean allConditionsAreCompleted(List<ProcessCondition<?>> conditions, ProcessTickets processTickets) {
        for (ProcessCondition<?> c : conditions) {
            if (c.resolve(processTickets)) continue;
            return false;
        }
        return true;
    }

    private static class Operation {
        @Nullable
        private GUID from;
        @Nullable
        private GUID to;
        @Nonnull
        private ActionVO action;

        public Operation(GUID from, GUID to, ActionVO action) {
            Objects.requireNonNull(action);
            this.from = from;
            this.to = to;
            this.action = action;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Operation other = (Operation)obj;
            if (this.action == null ? other.action != null : !this.action.equals((Object)other.action)) {
                return false;
            }
            if (this.from == null ? other.from != null : !this.from.equals((Object)other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals((Object)other.to));
        }

        public String toString(TicketProcess process) {
            if (this.from == null) {
                ParallelTicket parallelTicketHoldingActivity = ProcessTools.parallelTicketHoldingActivity(this.to, process);
                String name = parallelTicketHoldingActivity == null ? "Main-Ticket" : "Parallel-Ticket " + parallelTicketHoldingActivity.getName();
                return "Create " + name;
            }
            if (this.to == null) {
                ParallelTicket parallelTicketHoldingActivity = ProcessTools.parallelTicketHoldingActivity(this.from, process);
                String name = parallelTicketHoldingActivity == null ? "Main-Ticket" : "Parallel-Ticket " + parallelTicketHoldingActivity.getName();
                return "Finish " + name;
            }
            ParallelTicket parallelTicketHoldingActivity = ProcessTools.parallelTicketHoldingActivity(this.from, process);
            String name = parallelTicketHoldingActivity == null ? "Main-Ticket" : "Parallel-Ticket " + parallelTicketHoldingActivity.getName();
            String fromName = process.getActivity(this.from).getName();
            String toName = process.getActivity(this.to).getName();
            return "In " + name + " from " + fromName + " to " + toName;
        }
    }
}

