/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.id.GUID;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonData
public class ActiveProcess {
    private TicketProcess processDefinition;
    private TicketProcessSettings settings;

    private ActiveProcess() {
    }

    public ActiveProcess(TicketProcess processDefinition, TicketProcessSettings settings) {
        Objects.requireNonNull(processDefinition);
        Objects.requireNonNull(settings);
        this.processDefinition = processDefinition;
        this.settings = settings;
    }

    public TicketProcess getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(TicketProcess processDefinition) {
        this.processDefinition = processDefinition;
    }

    public TicketProcessSettings getSettings() {
        return this.settings;
    }

    public void setSettings(TicketProcessSettings settings) {
        this.settings = settings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.processDefinition == null ? 0 : this.processDefinition.hashCode());
        result = 31 * result + (this.settings == null ? 0 : this.settings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActiveProcess other = (ActiveProcess)obj;
        if (this.processDefinition == null ? other.processDefinition != null : !this.processDefinition.equals(other.processDefinition)) {
            return false;
        }
        return !(this.settings == null ? other.settings != null : !this.settings.equals(other.settings));
    }

    public void validate() {
        this.processDefinition.validate();
        this.validateAdditionalSettings(null);
    }

    public void validateAdditionalSettings(@Nullable ProcessTickets tickets) {
        if (tickets != null) {
            for (Map.Entry<GUID, Long> en : this.getSettings().getParallelTicketLatestStarts().entrySet()) {
                if (tickets.getSubTickets().get(en.getKey()) != null || System.currentTimeMillis() <= en.getValue()) continue;
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.applyProcess.latestDatesMustBeInFuture", new Object[0]), this.getProcessDefinition(), this.getProcessDefinition().getParallelTicket(en.getKey()));
            }
        }
    }
}

