/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ProcessValidationException
extends IllegalArgumentException {
    private static final long serialVersionUID = -6711282616115583562L;
    private int code = 0;
    private Activity activity;
    private ParallelTicket parallelTicket;
    private boolean processHasParallelTickets;

    public ProcessValidationException(String message, @Nonnull TicketProcess process) {
        this(message, process, null, null);
    }

    public ProcessValidationException(String message, @Nonnull TicketProcess process, @Nonnull Activity a) {
        this(message, process, a, ProcessTools.parallelTicketHoldingActivity(a.getId(), process));
        Objects.requireNonNull(a);
    }

    public ProcessValidationException(String message, @Nonnull TicketProcess process, @Nonnull ParallelTicket parallelTicket) {
        this(message, process, null, parallelTicket);
        Objects.requireNonNull(parallelTicket);
    }

    protected ProcessValidationException(String message, @Nonnull TicketProcess process, @Nullable Activity a, @Nullable ParallelTicket parallelTicket) {
        super(message);
        this.parallelTicket = parallelTicket;
        this.activity = a;
        if (!process.getParallelTickets().isEmpty()) {
            this.processHasParallelTickets = true;
        }
    }

    public ProcessValidationException(String message, ErrorCode code, @Nonnull TicketProcess process, @Nullable Activity a) {
        this(message, process, a, a == null ? null : ProcessTools.parallelTicketHoldingActivity(a.getId(), process));
        this.code = code.getErrorCodeNumber();
    }

    @Override
    public String getMessage() {
        Object message = super.getMessage();
        if (this.activity != null) {
            message = TicketProcessManager.MSG.getMsg("field.process.activity", new Object[0]) + " \"" + this.activity.getName() + "\": " + (String)message;
        }
        if (!this.processHasParallelTickets) {
            return message;
        }
        Object prefix = this.parallelTicket == null ? TicketProcessManager.MSG.getMsg("validation.mainTicket", new Object[0]) : this.parallelTicket.getName();
        prefix = (String)prefix + ": ";
        return (String)prefix + (String)message;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public Activity getActivity() {
        return this.activity;
    }

    @Nullable
    public ParallelTicket getParallelTicket() {
        return this.parallelTicket;
    }

    public boolean processHasParallelTickets() {
        return this.processHasParallelTickets;
    }
}

