/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.plugins.ticketprocess.client.data.SaveDefaultSettingsRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SaveDefaultSettings
extends AbstractTicketProcessHandler<SaveDefaultSettingsRequest, Void> {
    public String getMethodName() {
        return "ticketprocess.savedefaultsettings";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, SaveDefaultSettingsRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION)) {
            throw new AccessDeniedException(Permission.CONFIGURATION);
        }
        Configuration config = ConfigurationManager.getInstance().getCurrent();
        String recoveryConfiguration = ConfigurationManager.getRecoveryConfiguration();
        if (!StringFunctions.isEmpty((String)recoveryConfiguration)) {
            config = ConfigurationManager.getInstance().get(recoveryConfiguration);
        }
        if (config == null) {
            throw new ClientMessageException("The configuration does not exist anymore.");
        }
        config.put(TicketProcessManager.CONFIG_DEFAULT_ADDITIONAL_ACCESS_LEVEL, payload.getDefaultSettings().get("autoResourceAccess"));
        config.put(TicketProcessManager.CONFIG_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION, payload.getDefaultSettings().get("canBeChangedWhenActive"));
        return null;
    }
}

