/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.plugins.ticketprocess.client.data.EditOrDeleteFolderRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class EditOrDeleteProcessFolder
extends AbstractTicketProcessHandler<EditOrDeleteFolderRequest, Void> {
    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, EditOrDeleteFolderRequest payload) throws IOException {
        String folderId = payload.getFolderId();
        if (StringFunctions.isEmpty((String)folderId)) {
            return null;
        }
        GUID folderGuid = GUID.valueOf((String)folderId);
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        ticketProcessManager.getFolder(folderGuid);
        if (folderGuid == null) {
            return null;
        }
        String newFolderName = payload.getNewFolderName();
        if (StringFunctions.isEmpty((String)newFolderName)) {
            ticketProcessManager.deleteFolder(folderGuid);
        } else {
            String parentFolderId = payload.getParentFolderId();
            ticketProcessManager.moveFolder(folderGuid, StringFunctions.isEmpty((String)parentFolderId) ? null : GUID.valueOf((String)parentFolderId), newFolderName);
        }
        return null;
    }

    public String getMethodName() {
        return "ticketprocess.editordeletefolder";
    }
}

