/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessSelect;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ActivityTransitionAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ApplyProcessRendererExtension
implements ApplyActionRendererExtension {
    public static final String KEY_PROCESS_RENDERER = TicketProcessManager.ATTRIBUTE_PROCESS.getKey();
    public static final String KEY_CHANGE_PROCESS_RENDERER = "change" + TicketProcessManager.ATTRIBUTE_PROCESS.getKey();

    public List<String> getUpdateRendererIds(List<String> rendererIds, @Nonnull ActionVO action, TicketVO ticket) {
        if (action.getId() == -19) {
            rendererIds.add(KEY_PROCESS_RENDERER);
        }
        if (action.getId() == -37) {
            rendererIds.add(KEY_CHANGE_PROCESS_RENDERER);
        }
        if (action instanceof ActivityTransitionAction && ((ActivityTransitionAction)action).getTransition().getNextActivity().getIncomingTicketData().containsKey((TicketField<?>)Tickets.FIELD_RESOURCE_GUID)) {
            if (action.getId() == 8) {
                rendererIds.remove(TicketFieldRendererId.resourceid.name());
                rendererIds.remove(TicketFieldRendererId.keepstatus.name());
            } else if (action.getId() == 5) {
                rendererIds.remove(TicketFieldRendererId.resourceid.name());
            }
        }
        return rendererIds;
    }

    public void prepareReastepActionData(MutableReaStepData stepData, MutableReaStepText stepText, ExtensionArguments extensionArgs, ActionVO action, Map<String, String> values) {
        String processSelect = values.get(KEY_PROCESS_RENDERER);
        if (processSelect == null) {
            processSelect = values.get(KEY_CHANGE_PROCESS_RENDERER);
        }
        if (processSelect != null) {
            SelectOption option = (SelectOption)new Json().fromJson(processSelect, SelectOption.class);
            ProcessSelect select = (ProcessSelect)new Json().fromJson(option.getValue(), ProcessSelect.class);
            GUID processId = select.getId();
            ProcessDetailsDescription processDescription = select.getProcess();
            extensionArgs.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED, (Object)Boolean.FALSE);
            TicketProcess process = ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getProcess(processId);
            ActiveProcess activeProcess = null;
            if (process != null) {
                activeProcess = process.toActiveProcessWithoutModifications();
            }
            if (processDescription != null) {
                ActiveProcess modifiedActiveProcess = ProcessDetailsDescription.to(processDescription);
                if (process != null) {
                    if (!modifiedActiveProcess.getProcessDefinition().equals(process)) {
                        extensionArgs.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED, (Object)Boolean.TRUE);
                    }
                } else {
                    extensionArgs.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED, (Object)Boolean.TRUE);
                }
                activeProcess = modifiedActiveProcess;
            } else if (activeProcess == null) {
                throw new ClientMessageException(TicketProcessManager.MSG.getMsg("validation.update.originalDeleted", new Object[0]));
            }
            if (activeProcess != null) {
                extensionArgs.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START, (Object)activeProcess);
            }
        }
    }

    public SelectOptionResult getSelectOptions(String fieldKey, String searchTerm, int chunkSize, int currentSize, List<Integer> ticketIds) {
        if (fieldKey.equals(KEY_PROCESS_RENDERER)) {
            List<Object> options = new ArrayList<SelectOption>();
            TicketProcessManager processManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
            TicketProcessFolder rootFolder = processManager.getRootFolder();
            options.addAll(this.listProcesses(searchTerm, rootFolder, 0));
            int totalCount = options.size();
            if (currentSize >= totalCount) {
                options.clear();
            } else {
                options = options.subList(currentSize, Math.min(options.size(), currentSize + chunkSize));
            }
            return new SelectOptionResult(totalCount, options);
        }
        return null;
    }

    private List<SelectOption> listProcesses(String searchTerm, TicketProcessFolder rootFolder, int level) {
        ArrayList<TicketProcess> processes = new ArrayList<TicketProcess>(rootFolder.getProcesses());
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        if (!StringFunctions.isEmpty((String)searchTerm)) {
            String lowerSearchTerm = searchTerm.toLowerCase();
            processes.removeIf(p -> !p.getName().toLowerCase().contains(lowerSearchTerm));
        }
        if (!processes.isEmpty()) {
            options.addAll(processes.stream().sorted((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getName(), b.getName())).map(p -> this.createProcessSelectOption(p.toActiveProcessWithoutModifications(), false, level)).collect(Collectors.toList()));
        }
        for (TicketProcessFolder ticketProcessFolder : rootFolder.getSubFolders()) {
            List<SelectOption> listSubProcesses;
            if (!StringFunctions.isEmpty((String)searchTerm)) {
                String lowerSearchTerm = searchTerm.toLowerCase();
                if (ticketProcessFolder.getName().toLowerCase().contains(lowerSearchTerm)) {
                    searchTerm = "";
                }
            }
            if ((listSubProcesses = this.listProcesses(searchTerm, ticketProcessFolder, level + 1)).isEmpty()) continue;
            options.add(new SelectOption(ticketProcessFolder.getId().toString(), StringFunctions.encodeHTML((String)ticketProcessFolder.getName()), null, level, true, true));
            options.addAll(listSubProcesses);
        }
        return options;
    }

    private SelectOption createProcessSelectOption(ActiveProcess process, boolean serializeProcess, int level) {
        ProcessDetailsDescription detailsDescription = null;
        if (serializeProcess) {
            detailsDescription = ProcessDetailsDescription.from(process);
        }
        TicketProcess processDefinition = process.getProcessDefinition();
        return new SelectOption(new Json().toJson((Object)new ProcessSelect(processDefinition.getId(), detailsDescription, processDefinition.canBeChangedWhenActive())), "<div class=\"processentry\">" + (processDefinition.getParallelTickets().size() > 0 ? "<i class=\"icon-ticketprocess-parallel\"></i>" : "<i class=\"icon-ticketprocess-sequentiell\"></i>") + "<div class=\"processdetails\"><div class=\"processname\">" + StringFunctions.encodeHTML((String)processDefinition.getName()) + "</div><div class=\"processdescription\">" + StringFunctions.encodeHTML((String)(processDefinition.getDescription() == null ? "" : processDefinition.getDescription())) + "</div></div></div>", null, level);
    }

    public Map<String, String> getInitialProperties(ActionVO action, TicketVO ticket, Integer stepId, String flag, ReaStepTextVO stepText, ExtensionArguments extensionArguments) {
        if (action.getId() == -19 || action.getId() == -37) {
            ActiveProcess extArgProcess;
            ActiveProcess process = null;
            if (ticket != null) {
                process = TicketProcessManager.getActiveProcessOfTicket(ticket);
            }
            if (extensionArguments != null && (extArgProcess = (ActiveProcess)extensionArguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START)) != null) {
                process = extArgProcess;
            }
            if (process != null) {
                TicketProcessManager processManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
                TicketProcess original = processManager.getProcess(process.getProcessDefinition().getId());
                boolean modified = !process.getProcessDefinition().equals(original);
                return Collections.singletonMap(KEY_PROCESS_RENDERER, new Json().toJson((Object)this.createProcessSelectOption(process, modified, 0)));
            }
        }
        return super.getInitialProperties(action, ticket, stepId, flag, stepText, extensionArguments);
    }
}

