/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ProcessTicketUpdater {
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final int CHUNK_SIZE = 10;
    private static int THRESHOLD_MS = 2000;
    private static final String MSG_TIMEOUT = "CancelBecauseOfTimeout";
    private PersistenceEntry persistence;
    private Map<GUID, UpdateTask> tasks = new ConcurrentHashMap<GUID, UpdateTask>();
    private Set<String> webSocketClients = ConcurrentHashMap.newKeySet();

    public ProcessTicketUpdater() {
        this.persistence = Persistence.getInstance().resolve("process/runningUpdates.json");
    }

    public void init(TicketProcessManager manager) {
        String string = this.persistence.getString();
        if (!StringFunctions.isEmpty((String)string)) {
            Map fromJson = (Map)new Json().fromJson(string, Map.class, new Type[]{GUID.class, String.class});
            for (Map.Entry en : fromJson.entrySet()) {
                if (((String)en.getValue()).equals(DELETE)) {
                    this.runUpdate((GUID)en.getKey(), false, null);
                    continue;
                }
                TicketProcess process = manager.getProcess((GUID)en.getKey());
                if (process == null) continue;
                this.runUpdate(process.getId(), true, process);
            }
        }
    }

    public synchronized TicketProcessManager.UpdateProcessResult runUpdate(GUID processId, boolean updateElseDelete, TicketProcess process) {
        TicketProcessPlugin.LOGGER.debug((Object)String.format("Start Update of process %s", processId));
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{new SearchCondition("processid", SearchCondition.SearchTermOperator.Equals, (Object)processId), new SearchCondition(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey(), SearchCondition.SearchTermOperator.Equals, null)});
            SearchResult tickets = TicketManager.getReader().getSearchEngine().search(searchCommand);
            TicketProcessPlugin.LOGGER.debug((Object)("Update process in " + tickets.getEntries().size() + " tickets"));
            if (tickets.getEntries().size() == 0) {
                TicketProcessManager.UpdateProcessResult updateProcessResult = new TicketProcessManager.UpdateProcessResult(true);
                return updateProcessResult;
            }
            UpdateTask runningTask = this.tasks.get(processId);
            if (runningTask != null) {
                runningTask.interrupt = true;
                this.tasks.remove(processId);
                this.persistCurrentlyRunningTasks();
            }
            UpdateTask updateTask = updateElseDelete ? new UpdateTask(tickets.getEntries().iterator(), process) : new UpdateTask(tickets.getEntries().iterator(), processId);
            updateTask.sync = true;
            boolean runTooLong = updateTask.run(true);
            if (!runTooLong) {
                TicketProcessManager.UpdateProcessResult updateProcessResult = new TicketProcessManager.UpdateProcessResult(!updateTask.foundIncompatible);
                return updateProcessResult;
            }
            updateTask.sync = false;
            this.tasks.put(processId, updateTask);
            this.persistCurrentlyRunningTasks();
            ThreadPool.DEFAULT.startMainThread((Runnable)updateTask, (RunnableSession)new BaseRunnableSession(UserManager.getInstance().getCurrentUserAccountID()));
            TicketProcessManager.UpdateProcessResult updateProcessResult = new TicketProcessManager.UpdateProcessResult(tickets.getEntries().size(), updateTask.future);
            return updateProcessResult;
        }
    }

    private void persistCurrentlyRunningTasks() {
        HashMap<GUID, String> map = new HashMap<GUID, String>();
        for (Map.Entry<GUID, UpdateTask> en : this.tasks.entrySet()) {
            map.put(en.getKey(), en.getValue().isUpdating ? UPDATE : DELETE);
        }
        this.persistence.setString(new Json().toJson(map));
    }

    private boolean checkProcessIsStillValidForTicket(TicketProcess process, OperationChangedTicket ticket) {
        try {
            ProcessAnalyser.validateForTicketInStateOnly(process, ProcessTickets.createOldSnapshot((TicketVO)ticket.getOldTicket().get()));
            return true;
        }
        catch (IllegalArgumentException ee) {
            TicketProcessPlugin.LOGGER.debug((Object)("Process is no longer valid for ticket " + ticket.getTicketId()));
            TicketProcessPlugin.LOGGER.debug((Object)ee);
            return false;
        }
    }

    private void sendWebSocketEventToAll() {
        this.webSocketClients.forEach(clientId -> this.sendWebSocketEventTo((String)clientId));
    }

    private void sendWebSocketEventTo(String clientId) {
        WebSocketEventHandler.getInstance().sendEvent(clientId, () -> new WebSocketEventData("ticketprocess.asyncstates", this.tasks.keySet()));
    }

    public void addWebSocketClient(String clientId) {
        this.webSocketClients.add(clientId);
        this.sendWebSocketEventTo(clientId);
    }

    public void removeWebSocketClient(String clientId) {
        this.webSocketClients.remove(clientId);
    }

    private class UpdateTask
    implements Runnable {
        private boolean sync;
        private final boolean isUpdating;
        private volatile boolean interrupt;
        private final Iterator<SearchResultEntry<Integer>> tickets;
        @Nullable
        private TicketProcess process;
        private final GUID processId;
        private boolean foundIncompatible = false;
        private final CompletableFuture<GUID> future = new CompletableFuture();

        private UpdateTask(Iterator<SearchResultEntry<Integer>> tickets, TicketProcess process) {
            this.tickets = tickets;
            this.process = process;
            this.processId = process.getId();
            this.isUpdating = true;
        }

        private UpdateTask(Iterator<SearchResultEntry<Integer>> tickets, GUID processId) {
            this.tickets = tickets;
            this.processId = processId;
            this.isUpdating = false;
        }

        @Override
        public void run() {
            this.run(false);
        }

        /*
         * Exception decompiling
         */
        public boolean run(boolean stopIfTakesTooLong) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[WHILELOOP]], but top level block is 7[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private /* synthetic */ void lambda$run$0(boolean stopIfTakesTooLong, long timeout, TicketOperationModel model) {
            int count = 0;
            while (this.tickets.hasNext() && count < 10) {
                if (this.interrupt) {
                    TicketProcessPlugin.LOGGER.debug((Object)("Stop Update of process " + String.valueOf(this.processId)));
                    throw new CancellationException("Update was interrupted");
                }
                if (stopIfTakesTooLong && System.currentTimeMillis() > timeout) {
                    if (count == 0) {
                        throw new CancellationException(ProcessTicketUpdater.MSG_TIMEOUT);
                    }
                    return;
                }
                SearchResultEntry<Integer> e = this.tickets.next();
                ++count;
                OperationChangedTicket ticket = model.changeExistingTicket(((Integer)e.getId()).intValue());
                if (((TicketVO)ticket.getOldTicket().get()).isSlaveInBundle()) continue;
                if (this.isUpdating) {
                    if (!Boolean.TRUE.equals(ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS))) continue;
                    TicketProcessPlugin.LOGGER.debug((Object)("Update process in ticket#" + String.valueOf(e.getId())));
                    if (ProcessTicketUpdater.this.checkProcessIsStillValidForTicket(this.process, ticket)) {
                        ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)this.process);
                        ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, ProcessTools.findPathToCurrentActivity(this.process.getStart(), (GUID)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY)));
                        for (Map.Entry en : ((Map)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).entrySet()) {
                            OperationChangedTicket subTicket = model.changeExistingTicket(((Integer)en.getValue()).intValue());
                            GUID subActivity = (GUID)subTicket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY);
                            subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, ProcessTools.findPathToCurrentActivity(this.process.getParallelTicket((GUID)en.getKey()).getStart(), subActivity));
                            subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)this.process);
                        }
                        ProcessOperations.checkConditions(ticket);
                        continue;
                    }
                    ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS, (Object)Boolean.FALSE);
                    this.foundIncompatible = true;
                    continue;
                }
                if (!Boolean.TRUE.equals(ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS))) continue;
                ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS, (Object)Boolean.FALSE);
            }
        }
    }
}

