/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.TicketProcessManagerImpl;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class ActivityTransitionAction
extends ActionVO {
    private ActivityTransition transition;
    private TicketProcess process;

    public ActivityTransitionAction(@Nonnull ActionVO underlyingAction, @Nonnull ActivityTransition transition, @Nonnull TicketProcess process) {
        super(underlyingAction.getId(), ActivityTransitionAction.generateLabelIfEmpty(underlyingAction, transition, ProcessTools.startActivityOfBranchHoldingActivity(transition.getNextActivityId(), process)), underlyingAction.getStatusID(), underlyingAction.isInternal(), underlyingAction.getBillingType(), underlyingAction.getLumpSumType(), underlyingAction.getFixedCharge(), underlyingAction.isDeleted(), underlyingAction.getSpecial(), underlyingAction.isHidden());
        this.transition = transition;
        this.process = process;
    }

    public static String generateLabelIfEmpty(ActionVO underlyingAction, ActivityTransition transition, Activity start) {
        String actionLabel = transition.getActionLabel();
        if (actionLabel == null || actionLabel.isBlank()) {
            if (Status.isClosedStatus((int)underlyingAction.getStatusID())) {
                return TicketProcessManagerImpl.MSG.getMsg("transition.default.label.close", new Object[]{transition.getNextActivity().getName()});
            }
            if (Status.isDeletedStatus((int)underlyingAction.getStatusID())) {
                return TicketProcessManagerImpl.MSG.getMsg("transition.default.label.delete", new Object[]{transition.getNextActivity().getName()});
            }
            if (transition.getNextActivity().getType() == Activity.Type.FinishProcess) {
                return ActivityTransitionAction.appendOriginalActionIfNeeded(TicketProcessManagerImpl.MSG.getMsg("transition.default.label.finishProcess", new Object[]{transition.getNextActivity().getName()}), underlyingAction);
            }
            if (ActivityTransitionAction.isBackLink(transition, start)) {
                return ActivityTransitionAction.appendOriginalActionIfNeeded(TicketProcessManagerImpl.MSG.getMsg("transition.default.label.back", new Object[]{transition.getNextActivity().getName()}), underlyingAction);
            }
            return ActivityTransitionAction.appendOriginalActionIfNeeded(TicketProcessManagerImpl.MSG.getMsg("transition.default.label", new Object[]{transition.getNextActivity().getName()}), underlyingAction);
        }
        return actionLabel;
    }

    private static String appendOriginalActionIfNeeded(String msg, ActionVO underlyingAction) {
        if (underlyingAction.getId() != -36) {
            return msg + " (" + underlyingAction.getDisplayValue() + ")";
        }
        return msg;
    }

    private static boolean isBackLink(ActivityTransition transition, Activity start) {
        Boolean result = ActivityTransitionAction.isBackLink(start, new HashSet<GUID>(), transition, null);
        return result != null && result != false;
    }

    private static Boolean isBackLink(Activity a, Set<GUID> visited, ActivityTransition targetTransition, ActivityTransition currentTransition) {
        if (currentTransition == targetTransition) {
            return visited.contains(a.getId());
        }
        if (visited.contains(a.getId())) {
            return null;
        }
        visited.add(a.getId());
        for (ActivityTransition tra : a.getFollowUpActivities()) {
            Boolean result = ActivityTransitionAction.isBackLink(tra.getNextActivity(), new HashSet<GUID>(visited), targetTransition, tra);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ActivityTransition getTransition() {
        return this.transition;
    }

    public String getUniqueID() {
        return String.valueOf(this.transition.getActionid()) + ":" + this.transition.getActionLabel() + ":" + this.transition.getNextActivityId().toString();
    }

    public ActionVO copyActionWithChangedStatusAndSpecialFlag(int newStatusID, int special) {
        return new ActivityTransitionAction(this.basicCopyActionWithChangedStatusAndSpecialFlag(newStatusID, special), this.transition, this.process);
    }
}

