/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import java.util.Collections;
import java.util.List;

@JsonData
public class TicketProcessProgress {
    private ProgressTicket mainTicket;
    private int progressPct;
    private List<ProgressTicket> subTickets;
    private boolean canBeChangedWhenActive;

    public TicketProcessProgress(ProgressTicket mainTicket, TicketVO ticket) {
        this(mainTicket, ticket, Collections.emptyList(), false);
    }

    public TicketProcessProgress(ProgressTicket mainTicket, TicketVO ticket, List<ProgressTicket> subTickets, boolean canBeChangedWhenActive) {
        this.mainTicket = mainTicket;
        this.subTickets = subTickets;
        this.canBeChangedWhenActive = canBeChangedWhenActive;
        if (Status.isClosedStatus((int)ticket.getStatusID())) {
            this.progressPct = 100;
        } else {
            int sum = mainTicket.segments.stream().mapToInt(seq -> seq.getWeight()).sum();
            if (sum != 0) {
                int current = 0;
                for (ProgressSegment seg : mainTicket.segments) {
                    if (seg.getState() == ProgressState.PROCESSING) break;
                    current += seg.getWeight();
                }
                this.progressPct = current * 100 / sum;
            }
        }
        if (!subTickets.isEmpty()) {
            // empty if block
        }
    }

    public ProgressTicket getMainTicket() {
        return this.mainTicket;
    }

    public int getProgressPct() {
        return this.progressPct;
    }

    public List<ProgressTicket> getSubTicketProgress() {
        return this.subTickets;
    }

    @JsonData
    public static class ProgressTicket {
        private String name;
        private Integer ticketId;
        private GUID parallelTicketID;
        private List<String> startConditions;
        private boolean accessible;
        private boolean finished;
        private Long latestStart;
        private List<ProgressSegment> segments;

        public ProgressTicket(Integer ticketId, List<ProgressSegment> segments, String nameOfprocess) {
            this(nameOfprocess, ticketId, null, null, true, false, segments, null);
        }

        public ProgressTicket(Integer ticketId, GUID parallelTicketID, List<ProgressSegment> segments, boolean accessible, boolean finished, String nameOfParallelTicket) {
            this(nameOfParallelTicket, ticketId, parallelTicketID, null, accessible, finished, segments, null);
        }

        public ProgressTicket(GUID parallelTicketID, List<String> startConditions, List<ProgressSegment> segments, boolean accessible, String nameOfParallelTicket, Long latestStart) {
            this(nameOfParallelTicket, null, parallelTicketID, startConditions, accessible, false, segments, latestStart);
        }

        protected ProgressTicket(String name, Integer ticketId, GUID parallelTicketID, List<String> startConditions, boolean accessible, boolean finished, List<ProgressSegment> segments, Long latestStart) {
            this.name = name;
            this.ticketId = ticketId;
            this.parallelTicketID = parallelTicketID;
            this.startConditions = startConditions;
            this.accessible = accessible;
            this.finished = finished;
            this.segments = segments;
            this.latestStart = latestStart;
            List<String> current = null;
            for (int i = segments.size() - 1; i >= 0; --i) {
                ProgressSegment seg = segments.get(i);
                List<String> next = seg.getNamesOfTransitionsOfThisActivity();
                if (seg.getState() != ProgressState.MULTIPLE_WAYS) {
                    seg.setNamesOfTransitionsofThisActivity(current);
                }
                current = next;
                if (seg.getState() != ProgressState.DUMMY) continue;
                segments.remove(i);
            }
        }

        public Integer getTicketId() {
            return this.ticketId;
        }

        public GUID getParallelTicketID() {
            return this.parallelTicketID;
        }

        public List<String> getStartConditions() {
            return this.startConditions;
        }

        public List<ProgressSegment> getSegments() {
            return this.segments;
        }

        public boolean isAccessible() {
            return this.accessible;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public String getName() {
            return this.name;
        }

        public Long getLatestStart() {
            return this.latestStart;
        }
    }

    @JsonData
    public static class ProgressSegment {
        private ProgressState state;
        private String activityName;
        private String activityDescription;
        private int weight;
        private int numOfPaths;
        private boolean backLink;
        private String conditionMessage;
        private List<String> namesOfTransitionsOfActivity;

        public ProgressSegment(Activity activity, ProgressState state, String actionDisplayname) {
            this(activity, state, false, actionDisplayname);
        }

        public ProgressSegment(Activity activity, ProgressState state, boolean isBackLink, String actionDisplayname) {
            this.state = state;
            this.backLink = isBackLink;
            this.weight = activity.getWeight();
            this.activityName = activity.getName();
            this.activityDescription = activity.getDescription();
            this.namesOfTransitionsOfActivity = Collections.singletonList(actionDisplayname);
        }

        public ProgressSegment(int weight, int numOfPaths, boolean backLink, String conditionMessage, List<String> namesOfTransitionsToThisActivity) {
            this.weight = weight;
            this.numOfPaths = numOfPaths;
            this.backLink = backLink;
            this.namesOfTransitionsOfActivity = namesOfTransitionsToThisActivity;
            this.state = ProgressState.MULTIPLE_WAYS;
        }

        public ProgressSegment(String conditionMessage) {
            this.state = ProgressState.AUTO_TRANSITION;
            this.conditionMessage = conditionMessage;
            this.namesOfTransitionsOfActivity = Collections.emptyList();
        }

        public static ProgressSegment createForInaccessibleTicket(String segmentDisplayMsg) {
            ProgressSegment segment = new ProgressSegment(null);
            segment.activityName = segmentDisplayMsg;
            segment.state = ProgressState.OPEN;
            return segment;
        }

        public static ProgressSegment createDummy(String transitionName) {
            ProgressSegment segment = new ProgressSegment(null);
            segment.activityName = "Dummy";
            segment.state = ProgressState.DUMMY;
            segment.namesOfTransitionsOfActivity = Collections.singletonList(transitionName);
            return segment;
        }

        public ProgressState getState() {
            return this.state;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getNumOfPaths() {
            return this.numOfPaths;
        }

        public String getActivityDescription() {
            return this.activityDescription;
        }

        public boolean isBackLink() {
            return this.backLink;
        }

        public String getConditionMessage() {
            return this.conditionMessage;
        }

        public List<String> getNamesOfTransitionsOfThisActivity() {
            return this.namesOfTransitionsOfActivity;
        }

        public void setNamesOfTransitionsofThisActivity(List<String> namesOfTransitionsToThisActivity) {
            this.namesOfTransitionsOfActivity = namesOfTransitionsToThisActivity;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activityDescription == null ? 0 : this.activityDescription.hashCode());
            result = 31 * result + (this.activityName == null ? 0 : this.activityName.hashCode());
            result = 31 * result + (this.backLink ? 1231 : 1237);
            result = 31 * result + (this.conditionMessage == null ? 0 : this.conditionMessage.hashCode());
            result = 31 * result + this.numOfPaths;
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            result = 31 * result + this.weight;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgressSegment other = (ProgressSegment)obj;
            if (this.activityDescription == null ? other.activityDescription != null : !this.activityDescription.equals(other.activityDescription)) {
                return false;
            }
            if (this.activityName == null ? other.activityName != null : !this.activityName.equals(other.activityName)) {
                return false;
            }
            if (this.backLink != other.backLink) {
                return false;
            }
            if (this.conditionMessage == null ? other.conditionMessage != null : !this.conditionMessage.equals(other.conditionMessage)) {
                return false;
            }
            if (this.numOfPaths != other.numOfPaths) {
                return false;
            }
            if (this.state != other.state) {
                return false;
            }
            return this.weight == other.weight;
        }
    }

    public static enum ProgressState {
        OPEN,
        PROCESSING,
        DONE,
        MULTIPLE_WAYS,
        AUTO_TRANSITION,
        DUMMY;

    }

    public static class ProgressTicketData {
        private MutableTicketData data;
        private MutableTicketAttributes attributes;
        private ReaStepTextVO text;

        public ProgressTicketData(MutableTicketData data, MutableTicketAttributes attributes, ReaStepTextVO text) {
            this.data = data;
            this.attributes = attributes;
            this.text = text;
        }

        public MutableTicketData getData() {
            return this.data.copy();
        }

        public ReaStepTextVO getText() {
            return this.text;
        }

        public MutableTicketAttributes getAttributes() {
            return this.attributes;
        }
    }
}

