/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;

public class SetAttributesDirectlyExtension
implements TicketActionExtensionFactory {
    public static final ExtensionArguments.ExtArg<MutableTicketAttributes> EXTARG_ATTRIBUTES = new ExtensionArguments.ExtArg<MutableTicketAttributes>(){

        public String getKey() {
            return "directlySetAttributes";
        }

        public Class<MutableTicketAttributes> getValueType() {
            return MutableTicketAttributes.class;
        }

        public String toJson(MutableTicketAttributes value) {
            throw new UnsupportedOperationException();
        }

        public MutableTicketAttributes fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        public MutableTicketAttributes copyValue(MutableTicketAttributes value) {
            return value.copy();
        }
    };
    public static final int ACTION_NOP = -14;

    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepFields) {
        final MutableTicketAttributes attributes = (MutableTicketAttributes)arguments.get(EXTARG_ATTRIBUTES);
        if (attributes != null) {
            return new TicketActionExtension(){

                public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
                    ArrayList toDelete = new ArrayList(ticket.getAddedReaSteps());
                    toDelete.forEach(arg_0 -> ((OperationChangedTicket)ticket).remove(arg_0));
                    ticket.getNewTicketAttributes().getIncludedAttributes().forEach(att -> ticket.getNewTicketAttributes().remove(att));
                    ticket.getNewTicketData().getIncludedFields().forEach(field -> ticket.getNewTicketData().remove(field));
                    ticket.getAfterWriteOperations().clear();
                    ticket.getNewTicketAttributes().putAll(attributes);
                }
            };
        }
        return null;
    }

    public int getExecutionPriority() {
        return 10000000;
    }

    public static void silentlySetAttributesOfTicket(int ticketId, MutableTicketAttributes attributes) {
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            ExtensionArguments args = ExtensionArguments.ofSingleArg(EXTARG_ATTRIBUTES, (Object)attributes);
            TicketManager.getManipulator().applyAction(ticketId, new MutableReaStepData(), ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-14), args);
        }
    }
}

