/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessRef;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessProgress;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.ReaStepFieldProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeActivity;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessActiveSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessChildTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessIsOriginal;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessMainTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessStartDate;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessVisitedActivities;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.permissions.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface TicketProcessManager {
    public static final int ACTION_APPLY_PROCESS = -19;
    public static final int ACTION_CHANGE_ACTIVITY = -18;
    public static final int ACTION_FINISH_PROCESS = -34;
    public static final int ACTION_PROCESS_MOVE_TO_NEXT_ACTIVITY = -36;
    public static final int ACTION_CHANGE_ACTIVE_PROCESS = -37;
    public static final TicketAttribute<TicketProcess> ATTRIBUTE_PROCESS = new TicketAttributeProcess();
    public static final TicketAttribute<Boolean> ATTRIBUTE_ORIGINAL_PROCESS = new TicketAttributeProcessIsOriginal();
    public static final TicketAttribute<GUID> ATTRIBUTE_ACTIVITY = new TicketAttributeActivity();
    public static final TicketAttribute<Map<GUID, Integer>> ATTRIBUTE_CHILD_TICKETS = new TicketAttributeProcessChildTickets();
    public static final TicketAttribute<Integer> ATTRIBUTE_MAIN_TICKET = new TicketAttributeProcessMainTicket();
    public static final TicketAttribute<List<GUID>> ATTRIBUTE_VISITED_ACTIVITIES = new TicketAttributeProcessVisitedActivities();
    public static final TicketAttribute<Long> ATTRIBUTE_PROCESS_START_DATE = new TicketAttributeProcessStartDate();
    public static final TicketAttribute<TicketProcessSettings> ATTRIBUTE_ACTIVE_SETTINGS = new TicketAttributeProcessActiveSettings();
    public static final ReaStepField<ProcessRef> REASTEP_FIELD_PROCESS = new ReaStepFieldProcess();
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.ticketprocess.server.internal.i18n.LanguageResources", TicketProcessManager.class);
    public static final ExtensionArguments.ExtArg<ActiveProcess> EXT_ARG_PROCESS_TO_START = new ExtensionArguments.ExtArg<ActiveProcess>(){

        public String toJson(ActiveProcess value) {
            return new Json().toJson((Object)value);
        }

        public Class<ActiveProcess> getValueType() {
            return ActiveProcess.class;
        }

        public String getKey() {
            return "ticketProcess";
        }

        public ActiveProcess fromJson(String jsonData) {
            try {
                return (ActiveProcess)new Json().fromJson(jsonData, ActiveProcess.class);
            }
            catch (JsonException ee) {
                HashMap extraFieldsMap = new HashMap();
                TicketProcess p = (TicketProcess)new Json().fromJson(jsonData, TicketProcess.class, extraFieldsMap);
                if (!extraFieldsMap.isEmpty() && HDLogger.isDebug()) {
                    String msg = String.format("[TicketProcessManager] Could not deserialize all fields of attribute \"%s\". Json seems to be changed. Unknown fields are: %s ", "ActiveProcess", ((Object)extraFieldsMap).toString());
                    HDLogger.debug((Object)msg);
                }
                return new ActiveProcess(p, new TicketProcessSettings(Collections.emptyMap()));
            }
        }

        public ActiveProcess copyValue(ActiveProcess value) {
            return new ActiveProcess(value.getProcessDefinition(), value.getSettings());
        }
    };
    public static final ExtensionArguments.ExtArg<Boolean> EXT_ARG_PROCESS_TO_START_MODIFIED = new ExtensionArguments.JsonizableAndImmutableExtArg<Boolean>("ticketProcessIsModified", Boolean.class){};
    public static final ExtensionArguments.ExtArg<Boolean> EXT_ARG_TRANSITION_SUB_OPERATION = new ExtensionArguments.ExtArg<Boolean>(){

        public String toJson(Boolean value) {
            return new Json().toJson((Object)value);
        }

        public Class<Boolean> getValueType() {
            return Boolean.class;
        }

        public String getKey() {
            return "processTransitionSubOperation";
        }

        public Boolean fromJson(String jsonData) {
            return (Boolean)new Json().fromJson(jsonData, Boolean.class);
        }

        public Boolean copyValue(Boolean value) {
            return value;
        }
    };
    public static final List<Integer> ALWAYS_ALLOWED_ACTIONS = new ArrayList<Integer>(){
        {
            this.add(-34);
            this.add(-37);
            this.add(-14);
            this.add(-5);
            this.add(-9);
            this.add(-11);
            this.add(6);
            this.add(-16);
            this.add(-24);
            this.add(-1);
            this.add(-13);
            this.add(-41);
        }
    };
    public static final List<Integer> ALWAYS_DISALLOWED_ACTIONS = new ArrayList<Integer>(){};
    public static final List<Integer> ALWAYS_DISALLOWED_ACTIONS_FOR_PARALLEL = new ArrayList<Integer>(){
        {
            this.add(-19);
            this.add(-34);
            this.add(-37);
        }
    };
    public static final List<Integer> ACTIONS_DISALLOWED_FOR_TRANSITION = new ArrayList<Integer>(){
        {
            this.add(-33);
            this.add(-1);
            this.add(-13);
            this.add(-19);
            this.add(-34);
            this.add(-37);
        }
    };
    public static final ConfigKey CONFIG_DEFAULT_ADDITIONAL_ACCESS_LEVEL = new ConfigKey("processDefaultAdditionalAccessLevel", TicketProcess.AdditionalResourceAccess.NONE.name(), TicketProcess.AdditionalResourceAccess.class);
    public static final ConfigValue<TicketProcess.AdditionalResourceAccess> CONFIGVALUE_DEFAULT_ADDITIONAL_ACCESS_LEVEL = new ConfigValue(CONFIG_DEFAULT_ADDITIONAL_ACCESS_LEVEL);
    public static final ConfigKey CONFIG_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION = new ConfigKey("processDefaultEditableOnApplication", "false", Boolean.class);
    public static final ConfigValue<Boolean> CONFIGVALUE_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION = new ConfigValue(CONFIG_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION);

    public void createProcess(TicketProcess var1);

    public void createProcess(TicketProcess var1, GUID var2);

    public UpdateProcessResult updateProcess(TicketProcess var1);

    public List<TicketProcess> getProcesses();

    public UpdateProcessResult deleteProcess(GUID var1);

    public TicketProcessProgress getProgressFor(int var1);

    public TicketProcess getProcess(GUID var1);

    @Nonnull
    public Map<String, String> getSearchTagMapData();

    public GUID createFolder(GUID var1, String var2);

    public GUID createFolder(GUID var1, GUID var2, String var3);

    public boolean deleteFolder(GUID var1);

    @Nonnull
    public TicketProcessFolder getRootFolder();

    @Nullable
    public TicketProcessFolder getFolder(GUID var1);

    public void moveProcess(GUID var1, @Nullable GUID var2);

    public void moveFolder(GUID var1, GUID var2, String var3);

    @Nullable
    public static TicketProcess getProcessOfTicket(TicketVO ticket) {
        if (ticket.isSlaveInBundle()) {
            try {
                ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        TicketProcess process = (TicketProcess)ticket.getAttribute(ATTRIBUTE_PROCESS);
        return process;
    }

    @Nullable
    public static ActiveProcess getActiveProcessOfTicket(TicketVO ticket) {
        TicketProcess process;
        if (ticket.isSlaveInBundle()) {
            try {
                ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        if ((process = TicketProcessManager.getProcessOfTicket(ticket)) != null) {
            TicketProcessSettings settings = (TicketProcessSettings)ticket.getAttribute(ATTRIBUTE_ACTIVE_SETTINGS);
            if (settings == null) {
                settings = new TicketProcessSettings(Collections.emptyMap());
            }
            return new ActiveProcess(process, settings);
        }
        return null;
    }

    public void registerClientForAsyncUpdatesOfProcessesInTickets(String var1);

    public void unregisterClientForAsyncUpdatesOfProcessesInTickets(String var1);

    public void registerClientForChangesInProcess(String var1, String var2, int var3);

    public void unregisterClientForChangesInProcess(String var1, String var2, int var3);

    public void unregisterClientForAllChanges(String var1);

    public TicketProcessProgress.ProgressTicketData getProgressTicketDataFor(int var1, GUID var2);

    @Nullable
    public static Activity getActivityOfTicket(TicketVO ticket) {
        TicketProcess process;
        if (ticket.isSlaveInBundle()) {
            try {
                ticket = TicketManager.getReader().getTicket(ticket.getBundleID());
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        if ((process = TicketProcessManager.getProcessOfTicket(ticket)) != null) {
            return process.getActivity((GUID)ticket.getAttribute(ATTRIBUTE_ACTIVITY));
        }
        return null;
    }

    public static List<ActionVO> getPossibleActionsForTransition() {
        List actions = ActionManager.getInstance().getAll(true);
        actions.removeIf(action -> {
            switch (action.getId()) {
                case -41: 
                case -24: 
                case -9: 
                case -5: 
                case 6: {
                    return false;
                }
            }
            if (action.isInternal()) {
                return true;
            }
            if (ALWAYS_ALLOWED_ACTIONS.contains(action.getId())) {
                return true;
            }
            return ACTIONS_DISALLOWED_FOR_TRANSITION.contains(action.getId());
        });
        return actions;
    }

    public static List<ActionVO> getPossibleActionsWhichCanBeAllowed() {
        List actions = ActionManager.getInstance().getAll(true);
        actions.removeIf(action -> {
            if (ALWAYS_ALLOWED_ACTIONS.contains(action.getId())) {
                return true;
            }
            if (ALWAYS_DISALLOWED_ACTIONS.contains(action.getId())) {
                return true;
            }
            switch (action.getId()) {
                case -36: 
                case -32: 
                case -18: 
                case 4: {
                    return true;
                }
            }
            return false;
        });
        return actions;
    }

    public static List<ActionVO> getDefaultAllowedActions() {
        List<ActionVO> actions = TicketProcessManager.getPossibleActionsWhichCanBeAllowed();
        actions.removeIf(action -> {
            switch (action.getId()) {
                case -25: 
                case -19: 
                case -3: 
                case 2: 
                case 7: 
                case 9: 
                case 10: {
                    return true;
                }
            }
            if (Status.isClosedOrDeletedStatus((int)action.getStatusID())) {
                return true;
            }
            return action.getStatusID() == 150 || action.getStatusID() == 260;
        });
        return actions;
    }

    public static List<Integer> getActionsWhichCanBeAllowedForAutoTransition() {
        List actions = ActionManager.getInstance().getAll(true);
        actions.removeIf(action -> {
            if (action.getId() == -36) {
                return false;
            }
            if (Status.isClosedOrDeletedStatus((int)action.getStatusID())) {
                return false;
            }
            return !action.istCustomAction();
        });
        return actions.stream().map(FieldVO::getId).collect(Collectors.toList());
    }

    public static class UpdateProcessResult {
        private boolean synchronous;
        private int numOfTickets;
        private boolean noIncompatibleProcessesFound;
        private CompletableFuture<GUID> future;

        public UpdateProcessResult(int numOfTickets, CompletableFuture<GUID> future) {
            this.future = future;
            this.synchronous = false;
            this.numOfTickets = numOfTickets;
            this.noIncompatibleProcessesFound = true;
        }

        public UpdateProcessResult(boolean noIncompatibleProcessesFound) {
            this.synchronous = true;
            this.noIncompatibleProcessesFound = noIncompatibleProcessesFound;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }

        public int getNumOfTickets() {
            return this.numOfTickets;
        }

        public boolean isNoIncompatibleProcessesFound() {
            return this.noIncompatibleProcessesFound;
        }

        public CompletableFuture<GUID> getFuture() {
            return this.future;
        }
    }
}

