/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ActivityDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ActivityTransitionDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ParallelTicketDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessConditionDescription;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessSettings;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class ProcessDetailsDescription {
    private GUID id;
    private String name = "";
    private String description = "";
    private String errorMessage;
    @JsonExcludeNull
    private GUID startActivityId;
    private List<ActivityDetailsDescription> activities = new ArrayList<ActivityDetailsDescription>();
    private List<ParallelTicketDescription> parallelTickets = new ArrayList<ParallelTicketDescription>();
    private String autoResourceAccess = ((TicketProcess.AdditionalResourceAccess)((Object)TicketProcessManager.CONFIGVALUE_DEFAULT_ADDITIONAL_ACCESS_LEVEL.get())).name();
    private boolean canBeChangedWhenActive = (Boolean)TicketProcessManager.CONFIGVALUE_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION.get();
    private Map<GUID, Long> parallelTicketLatestStarts;

    public GUID getId() {
        return this.id;
    }

    public static ProcessDetailsDescription from(ActiveProcess activeProcess) {
        ProcessDetailsDescription pdd;
        TicketProcess ticketProcess;
        block15: {
            ticketProcess = activeProcess.getProcessDefinition();
            pdd = new ProcessDetailsDescription();
            pdd.id = ticketProcess.getId();
            pdd.name = ticketProcess.getName() == null ? "" : ticketProcess.getName();
            pdd.description = ticketProcess.getDescription() == null ? "" : ticketProcess.getDescription();
            pdd.startActivityId = ticketProcess.getStart().getId();
            pdd.autoResourceAccess = ticketProcess.getAutoResourceAccess().name();
            pdd.canBeChangedWhenActive = ticketProcess.canBeChangedWhenActive();
            pdd.parallelTicketLatestStarts = activeProcess.getSettings().getParallelTicketLatestStarts();
            List<Activity> activities = ticketProcess.getActivities();
            if (activities != null) {
                for (Activity activity : activities) {
                    pdd.activities.add(ActivityDetailsDescription.from(activity));
                }
            }
            try {
                activeProcess.validate();
            }
            catch (Throwable t) {
                pdd.errorMessage = StringFunctions.getUserFriendlyErrorMessage((Throwable)t);
                ProcessValidationException processException = null;
                if (t instanceof ProcessValidationException) {
                    processException = (ProcessValidationException)t;
                }
                if (t.getCause() instanceof ProcessValidationException) {
                    processException = (ProcessValidationException)t.getCause();
                }
                if (processException != null) {
                    Activity activity = processException.getActivity();
                    if (activity != null) {
                        pdd.errorMessage = "<a ng-click=\"scrollToActivity('" + String.valueOf(activity.getId()) + "');\" activityid=\"" + String.valueOf(activity.getId()) + "\">" + pdd.errorMessage + "</a>";
                    } else {
                        ParallelTicket parallelTicket = processException.getParallelTicket();
                        if (parallelTicket != null) {
                            pdd.errorMessage = "<a ng-click=\"scrollToTicket('" + String.valueOf(parallelTicket.getId()) + "');\" parallelticketid=\"" + String.valueOf(parallelTicket.getId()) + "\" highlightsource=\"true\">" + pdd.errorMessage + "</a>";
                        }
                    }
                }
                if (t instanceof ClientMessageException) break block15;
                pdd.errorMessage = StringFunctions.encodeHTML((String)pdd.errorMessage, (boolean)false);
            }
        }
        List<ParallelTicket> parallelTickets = ticketProcess.getParallelTickets();
        if (parallelTickets != null && !parallelTickets.isEmpty()) {
            for (ParallelTicket pt : parallelTickets) {
                ArrayList<ActivityDetailsDescription> ptads = new ArrayList<ActivityDetailsDescription>();
                List<Activity> ptActivities = pt.getActivities();
                if (ptActivities != null) {
                    for (Activity ptActivity : ptActivities) {
                        ptads.add(ActivityDetailsDescription.from(ptActivity));
                    }
                }
                ArrayList<ProcessConditionDescription> conditionDescriptions = new ArrayList<ProcessConditionDescription>();
                for (ProcessCondition<?> condition : pt.getStartCondition()) {
                    conditionDescriptions.add(new ProcessConditionDescription(condition.getType(), condition.getConditionData()));
                }
                pdd.parallelTickets.add(new ParallelTicketDescription(pt.getId(), pt.getName(), pt.getStartActivityId(), conditionDescriptions, ptads, pt.isDeactivated(), pt.getRelativeLatestStart()));
            }
        }
        return pdd;
    }

    public static ActiveProcess to(ProcessDetailsDescription process) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ActivityDetailsDescription a : process.activities) {
            Activity activity = ProcessDetailsDescription.convertActivity(process.startActivityId, a, false);
            activities.add(activity);
        }
        List<ParallelTicket> pTickets = Collections.emptyList();
        List<ParallelTicketDescription> parallelTickets = process.parallelTickets;
        if (parallelTickets != null && !parallelTickets.isEmpty()) {
            pTickets = parallelTickets.stream().map(pt -> {
                ArrayList startCondition = new ArrayList();
                for (ProcessConditionDescription c : pt.getStartConditions()) {
                    startCondition.add(ProcessDetailsDescription.convertCondition(c));
                }
                GUID id = pt.getId() == null ? GUID.generateNew() : pt.getId();
                ArrayList<Activity> ptActivities = new ArrayList<Activity>();
                for (ActivityDetailsDescription a : pt.getActivities()) {
                    ptActivities.add(ProcessDetailsDescription.convertActivity(pt.getStartActivityId(), a, true));
                }
                return new ParallelTicket(id, pt.getName(), ptActivities, pt.getStartActivityId(), startCondition, pt.isDeactivated(), pt.getLatestStart());
            }).collect(Collectors.toList());
        }
        GUID pID = process.id == null ? GUID.generateNew() : process.id;
        TicketProcess ticketProcess = new TicketProcess(pID, process.name, process.description, activities, process.startActivityId, pTickets, TicketProcess.AdditionalResourceAccess.valueOf(process.autoResourceAccess), process.canBeChangedWhenActive);
        return new ActiveProcess(ticketProcess, new TicketProcessSettings(process.parallelTicketLatestStarts));
    }

    private static ProcessCondition<?> convertCondition(ProcessConditionDescription descr) {
        List list = ServerPluginManager.getInstance().get(ConditionType.class);
        for (ConditionType conditionType : list) {
            if (!conditionType.getTypeIdentifier().equals(descr.getType())) continue;
            Object convert = conditionType.convert(descr.getConditionData());
            return new ProcessCondition(convert, conditionType);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Activity convertActivity(GUID startActivityId, ActivityDetailsDescription description, boolean parallelTicket) {
        GUID guid = GUID.valueOf((String)description.getId());
        List<ActivityTransitionDetailsDescription> transitionsDesc = description.getTransitions();
        ArrayList<ActivityTransition> transitions = new ArrayList<ActivityTransition>();
        for (ActivityTransitionDetailsDescription d : transitionsDesc) {
            ArrayList conditions = new ArrayList();
            if (d.getConditionsForAutoTransition() != null && !d.getConditionsForAutoTransition().isEmpty()) {
                for (ProcessConditionDescription c : d.getConditionsForAutoTransition()) {
                    conditions.add(ProcessDetailsDescription.convertCondition(c));
                }
            }
            transitions.add(new ActivityTransition(GUID.valueOf((String)d.getNextActivityId()), d.getActionLabel(), d.getAction() == null ? -1 : d.getAction().getId(), conditions, d.getAutoTransitionText()));
        }
        List<ActionDescription> allowedActionsDescription = description.getAllowedActions();
        ArrayList<Integer> possibleActions = new ArrayList<Integer>();
        for (ActionDescription d : allowedActionsDescription) {
            possibleActions.add(d.getId());
        }
        Map<String, String> ticketDataToSetAtStartValues = description.getTicketDataToSetAtStartValues();
        Map<String, String> ticketDataToReferencedFields = description.getTicketDataToReferencedFields();
        Map<String, Integer> ticketDataToSetAtStartSettings = description.getTicketDataToSetAtStartSettings();
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        List list = dem.get(TicketFieldDefinition.class);
        Map<String, TicketFieldDefinition> ticketMap = list.stream().collect(Collectors.toMap(TicketFieldDefinition::getFieldKey, t -> t));
        MutableTicketData ticketData = new MutableTicketData();
        HashMap<TicketField, RelativeOrAbsoluteDate> convertedDateValue = new HashMap<TicketField, RelativeOrAbsoluteDate>();
        for (Map.Entry<String, String> entry : ticketDataToSetAtStartValues.entrySet()) {
            FieldEditDefinition editDefinition;
            TicketFieldDefinition ticketFieldDefinition;
            String string = entry.getKey();
            if (!Integer.valueOf(1).equals(ticketDataToSetAtStartSettings.get(entry.getKey())) || (ticketFieldDefinition = ticketMap.get(string)) == null || (editDefinition = ticketFieldDefinition.getEditDefinition()) == null || !editDefinition.isAvailable(null) && !Tickets.FIELD_OWNER_GUID.getKey().equals(editDefinition.getFieldKey())) continue;
            String displayType = editDefinition.getDisplayType();
            if ("datevalue".equals(displayType) || "dateonlyvalue".equals(displayType)) {
                TicketField field;
                String dateVal = ticketDataToSetAtStartValues.get(editDefinition.getFieldKey());
                if (dateVal == null || (field = Tickets.getFieldByKey((String)editDefinition.getFieldKey())) == null) continue;
                if (StringFunctions.isEmpty((String)dateVal)) {
                    ticketData.put(field, null);
                    continue;
                }
                convertedDateValue.put(field, (RelativeOrAbsoluteDate)new Json().fromJson(dateVal, RelativeOrAbsoluteDate.class));
                continue;
            }
            editDefinition.updateTicketData(ticketData, ticketDataToSetAtStartValues);
        }
        ProcessTicketData processTicketData = new ProcessTicketData();
        for (TicketField ticketField : ticketData.getIncludedFields()) {
            processTicketData.putRef(ticketField, ProcessValueReference.createConcrete(ticketField, ticketData.get(ticketField)));
        }
        for (Map.Entry entry : convertedDateValue.entrySet()) {
            processTicketData.putRef((TicketField)entry.getKey(), ProcessValueReference.createConcrete((TicketField)entry.getKey(), (RelativeOrAbsoluteDate)entry.getValue()));
        }
        for (Map.Entry<String, String> entry : ticketDataToReferencedFields.entrySet()) {
            String value = entry.getValue();
            if (StringFunctions.isEmpty((String)value)) {
                value = null;
            }
            if (Integer.valueOf(3).equals(ticketDataToSetAtStartSettings.get(entry.getKey()))) {
                TicketField field = Tickets.getFieldByKey((String)entry.getKey());
                if (field == null) continue;
                processTicketData.putRef(field, ProcessValueReference.createReferencingWithSuffix(GUID.valueOf((String)value), (TicketField<String>)field, ticketDataToSetAtStartValues.get(entry.getKey())));
                continue;
            }
            if (!Integer.valueOf(2).equals(ticketDataToSetAtStartSettings.get(entry.getKey()))) continue;
            processTicketData.putRef(Tickets.getFieldByKey((String)entry.getKey()), ProcessValueReference.createReferencing(GUID.valueOf((String)value)));
        }
        if (startActivityId != null && startActivityId.equals((Object)guid) && parallelTicket) {
            void var17_26;
            boolean bl;
            String string = description.getTicketDataToSetAtStartValues().get("htmleditor");
            if (string == null) {
                String string2 = "";
            }
            if (bl = Boolean.valueOf(description.getTicketDataToSetAtStartValues().get("htmlcontent")).booleanValue()) {
                String string3 = TicketTextFunctions.prepareHtmlTextForSaving((String)var17_23);
            } else {
                String string4 = TicketTextFunctions.convertToPlainText((String)var17_23);
            }
            ReaStepTextVO parallelTicketText = ReaStepTextVO.of((String)var17_26, (boolean)bl);
            return new Activity(guid, transitions, description.getName(), description.getDescription(), possibleActions, processTicketData, parallelTicketText, description.isAppendTextOfMainTicketIntoParallel());
        }
        return new Activity(guid, description.getNextProcessToStart() == null ? null : GUID.valueOf((String)description.getNextProcessToStart()), description.getType() == null ? Activity.Type.Standard : description.getType(), description.getRequiredFieldKeys() == null ? new ArrayList() : description.getRequiredFieldKeys(), transitions, description.getName(), description.getDescription(), possibleActions, processTicketData);
    }
}

