/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ParallelTicketTimer;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.StartProcessActionExtension;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.id.GUID;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangeActiveProcessActionExtension
implements TicketActionExtensionFactory {
    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket ticket, @Nonnull ActionVO action, @Nonnull ExtensionArguments arguments, @Nonnull MutableReaStepData reaStepFields) {
        if (action.getId() == -37) {
            ActiveProcess ticketProcess = (ActiveProcess)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START);
            if (ticketProcess != null) {
                Boolean modified = (Boolean)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START_MODIFIED);
                return new Extension(ticketProcess, modified);
            }
            throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.applyProcess.noProcessGiven", new Object[0]));
        }
        return null;
    }

    public String checkActionPreconditions(TicketVO ticket, ActionVO action, TicketPermissionContext ticketPermissionInfo) {
        if (action.getId() == -37) {
            TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(ticket);
            if (processOfTicket == null) {
                return "Tried to change process in a ticket without process: " + ticket.getID();
            }
            if (!processOfTicket.canBeChangedWhenActive()) {
                return TicketProcessManager.MSG.getMsg("validation.applyProcess.processCannotBeEdited", new Object[0]);
            }
        }
        return null;
    }

    private class Extension
    implements TicketActionExtension {
        private ActiveProcess toStart;
        @Nullable
        private Boolean modified;

        public Extension(ActiveProcess toStart, Boolean modified) {
            this.toStart = toStart;
            this.modified = modified;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            TicketProcess processOfTicket = ProcessOperations.getProcessOfTicket(ticket);
            TicketProcess processToStart = this.toStart.getProcessDefinition();
            ProcessTickets tickets = new ProcessTickets(ticket, processOfTicket);
            if (!Objects.equals(processOfTicket.getId(), processToStart.getId())) {
                throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.updateNotPossibleWithOtherProcess", new Object[]{processOfTicket.getName(), ticket.getTicketId()}));
            }
            if (TicketProcessManager.getActiveProcessOfTicket(ticket.createIntermediateTicketVO()).equals(this.toStart)) {
                throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.updateDoesNotChangeProcess", new Object[0]));
            }
            try {
                ProcessAnalyser.validateForTicketInStateOnly(processToStart, tickets);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(TicketProcessManager.MSG.getMsg("validation.updateNotPossibleInTicket", new Object[]{ex.getMessage()}), ex);
            }
            this.toStart.validateAdditionalSettings(tickets);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)processToStart);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS, (Object)(this.modified == null ? Boolean.FALSE : Boolean.valueOf(this.modified == false)));
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ACTIVE_SETTINGS, (Object)this.toStart.getSettings());
            List<GUID> visitedActivities = ProcessTools.findPathToCurrentActivity(processToStart.getStart(), (GUID)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY));
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, visitedActivities);
            for (Map.Entry en : ((Map)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).entrySet()) {
                OperationChangedTicket subTicket = ticket.getParentModel().changeExistingTicket(((Integer)en.getValue()).intValue());
                GUID subActivity = (GUID)subTicket.getAttributeValue(TicketProcessManager.ATTRIBUTE_ACTIVITY);
                List<GUID> pathToCurrentActivity = ProcessTools.findPathToCurrentActivity(ProcessTools.parallelTicketHoldingActivity(subActivity, processToStart).getStart(), subActivity);
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, pathToCurrentActivity);
                subTicket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)processToStart);
            }
            reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)StartProcessActionExtension.maxlen(processToStart.getName(), 255));
            reaStep.getFields().putAll(ProcessOperations.createGroupingData(ticket, reaStep));
            ProcessOperations.checkConditions(ticket);
            ticket.getAfterWriteOperations().add(() -> ParallelTicketTimer.getInstance().startTimersFor(TicketManager.getReader().getTicket(ticket.getTicketId())));
        }
    }
}

