/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessConditionDescription;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class ActivityTransitionDetailsDescription {
    private String nextActivityId;
    private String actionLabel;
    private ActionDescription action;
    private List<ProcessConditionDescription> conditionsForAutoTransition;
    private String autoTransitionText;

    public static ActivityTransitionDetailsDescription from(ActivityTransition activityTransition) {
        ActivityTransitionDetailsDescription at = new ActivityTransitionDetailsDescription();
        at.nextActivityId = activityTransition.getNextActivityId().toString();
        at.actionLabel = activityTransition.getActionLabel();
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(activityTransition.getActionid());
        if (actionVO != null) {
            at.action = TicketFunctions.convertToActionDescription((ActionVO)actionVO);
        }
        at.autoTransitionText = activityTransition.getAutoTransitionText();
        List<ProcessCondition<?>> conditions = activityTransition.getConditionsForAutoTransition();
        if (conditions != null && !conditions.isEmpty()) {
            at.conditionsForAutoTransition = new ArrayList<ProcessConditionDescription>();
            for (ProcessCondition<?> condition : conditions) {
                at.conditionsForAutoTransition.add(new ProcessConditionDescription(condition.getType(), condition.getConditionData()));
            }
        }
        return at;
    }

    public String getNextActivityId() {
        return this.nextActivityId;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public ActionDescription getAction() {
        return this.action;
    }

    public String getAutoTransitionText() {
        return this.autoTransitionText;
    }

    public List<ProcessConditionDescription> getConditionsForAutoTransition() {
        return this.conditionsForAutoTransition;
    }
}

