/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MutableProcessFolder {
    private GUID id;
    private String name;
    private MutableProcessFolder parent;
    private List<MutableProcessFolder> subFolders = new ArrayList<MutableProcessFolder>();
    private List<GUID> processes;

    public MutableProcessFolder(GUID id, String name, MutableProcessFolder parent, List<GUID> processes) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(processes);
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.processes = processes;
    }

    public GUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MutableProcessFolder getParent() {
        return this.parent;
    }

    public void setParent(MutableProcessFolder parent) {
        this.parent = parent;
    }

    public List<GUID> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<GUID> processes) {
        this.processes = processes;
    }

    public List<MutableProcessFolder> getSubFolders() {
        return this.subFolders;
    }

    public void setSubFolders(List<MutableProcessFolder> subFolders) {
        this.subFolders = subFolders;
    }

    public MutableProcessFolder find(GUID folderId) {
        if (folderId == null && this.parent == null) {
            return this;
        }
        if (this.id.equals((Object)folderId)) {
            return this;
        }
        for (MutableProcessFolder f : this.subFolders) {
            MutableProcessFolder sub = f.find(folderId);
            if (sub == null) continue;
            return sub;
        }
        return null;
    }

    public MutableProcessFolder removeProcess(GUID processId) {
        MutableProcessFolder folder = this.findProcess(processId);
        if (folder != null) {
            folder.getProcesses().remove(processId);
            return folder;
        }
        return null;
    }

    TicketProcessFolder toImmutable(Map<GUID, TicketProcess> processMap) {
        List<TicketProcessFolder> subs = this.subFolders.stream().map(sub -> sub.toImmutable(processMap)).collect(Collectors.toList());
        List<TicketProcess> processObjects = this.processes.stream().map(pId -> (TicketProcess)processMap.get(pId)).filter(Objects::nonNull).collect(Collectors.toList());
        return new TicketProcessFolder(this.id, this.name, subs, processObjects);
    }

    public MutableProcessFolder findProcess(GUID id) {
        if (this.processes.contains(id)) {
            return this;
        }
        for (MutableProcessFolder sub : this.subFolders) {
            MutableProcessFolder subresult = sub.findProcess(id);
            if (subresult == null) continue;
            return subresult;
        }
        return null;
    }
}

