/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugins.ticketprocess.client.data.GetTicketProcessListRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.GetTicketProcessListResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessFolderDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class GetTicketProcessList
extends AbstractTicketProcessHandler<GetTicketProcessListRequest, GetTicketProcessListResponse> {
    @Override
    public GetTicketProcessListResponse handle(HttpServletRequest req, HttpServletResponse resp, GetTicketProcessListRequest payload) throws IOException {
        ArrayList<ProcessDescription> processList = new ArrayList<ProcessDescription>();
        ArrayList<ProcessFolderDescription> foldersList = new ArrayList<ProcessFolderDescription>();
        Stack<ProcessFolderDescription> folderBreadcrumbs = new Stack<ProcessFolderDescription>();
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        String processFolderId = payload.getProcessFolderId();
        List<TicketProcess> processes = null;
        List<TicketProcessFolder> subfolders = null;
        String searchTerm = payload.getSearchTerm();
        if (!StringFunctions.isEmpty((String)processFolderId)) {
            GUID processFolderGuid = GUID.valueOf((String)processFolderId);
            TicketProcessFolder folder = ticketProcessManager.getFolder(processFolderGuid);
            if (folder != null) {
                if (this.hasParentMatch(searchTerm, folder)) {
                    searchTerm = "";
                }
                processes = folder.getProcesses();
                subfolders = folder.getSubFolders();
            }
            this.getFolderBreadCrumbs(processFolderGuid, folderBreadcrumbs, ticketProcessManager);
        } else {
            Iterator<TicketProcessFolder> folder = ticketProcessManager.getRootFolder();
            processes = ((TicketProcessFolder)((Object)folder)).getProcesses();
            subfolders = ((TicketProcessFolder)((Object)folder)).getSubFolders();
        }
        if (processes != null) {
            for (TicketProcess ticketProcess : processes) {
                boolean hasErrors = false;
                try {
                    ticketProcess.validate();
                }
                catch (Throwable t) {
                    hasErrors = true;
                }
                String description = ticketProcess.getDescription();
                if (!StringFunctions.isEmpty((String)searchTerm)) {
                    if (!ticketProcess.getName().toLowerCase().contains(searchTerm.toLowerCase()) && (description == null || !description.toLowerCase().contains(searchTerm.toLowerCase()))) continue;
                    processList.add(new ProcessDescription(ticketProcess.getId(), ticketProcess.getName(), description, hasErrors, ticketProcess.getParallelTickets().size() > 0, ticketProcess.canBeChangedWhenActive(), ticketProcess.getAutoResourceAccess().name()));
                    continue;
                }
                processList.add(new ProcessDescription(ticketProcess.getId(), ticketProcess.getName(), description, hasErrors, ticketProcess.getParallelTickets().size() > 0, ticketProcess.canBeChangedWhenActive(), ticketProcess.getAutoResourceAccess().name()));
            }
        }
        if (subfolders != null) {
            for (TicketProcessFolder subfolder : subfolders) {
                if (!StringFunctions.isEmpty((String)searchTerm)) {
                    if (!this.isMatchiongFolder(searchTerm, subfolder)) continue;
                    foldersList.add(new ProcessFolderDescription(subfolder.getId().toString(), subfolder.getName(), subfolder.isEmpty(), !subfolder.getSubFolders().isEmpty()));
                    continue;
                }
                foldersList.add(new ProcessFolderDescription(subfolder.getId().toString(), subfolder.getName(), subfolder.isEmpty(), !subfolder.getSubFolders().isEmpty()));
            }
        }
        processList.sort(new Comparator<ProcessDescription>(){

            @Override
            public int compare(ProcessDescription o1, ProcessDescription o2) {
                int compare = Collator.getInstance(ClientLocale.getThreadLocale()).compare(o1.getName(), o2.getName());
                if (compare == 0) {
                    compare = o1.getId().toString().compareTo(o2.getId().toString());
                }
                return compare;
            }
        });
        foldersList.sort(new Comparator<ProcessFolderDescription>(){

            @Override
            public int compare(ProcessFolderDescription o1, ProcessFolderDescription o2) {
                int compare = String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                if (compare == 0) {
                    compare = o1.getId().toString().compareTo(o2.getId().toString());
                }
                return compare;
            }
        });
        HashMap<String, String> defaultSettings = null;
        if (SystemPermissionChecker.checkAccess((Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION})) {
            defaultSettings = new HashMap<String, String>();
            defaultSettings.put("autoResourceAccess", ((TicketProcess.AdditionalResourceAccess)((Object)TicketProcessManager.CONFIGVALUE_DEFAULT_ADDITIONAL_ACCESS_LEVEL.get())).name());
            defaultSettings.put("canBeChangedWhenActive", ((Boolean)TicketProcessManager.CONFIGVALUE_DEFAULT_PROCESS_EDITABLE_ON_APPLICATION.get()).toString());
        }
        return new GetTicketProcessListResponse(processList, foldersList, folderBreadcrumbs, defaultSettings);
    }

    private boolean hasParentMatch(String searchTerm, TicketProcessFolder folder) {
        if (folder.getName().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (folder.getParent() != null) {
            return this.hasParentMatch(searchTerm, folder.getParent());
        }
        return false;
    }

    private boolean isMatchiongFolder(String searchTerm, TicketProcessFolder rootFolder) {
        String lowerSearchTerm = searchTerm.toLowerCase();
        List<TicketProcess> processes = rootFolder.getProcesses();
        if (rootFolder.getName().toLowerCase().contains(lowerSearchTerm)) {
            return true;
        }
        if (processes.stream().anyMatch(p -> p.getName().toLowerCase().contains(lowerSearchTerm))) {
            return true;
        }
        for (TicketProcessFolder ticketProcessFolder : rootFolder.getSubFolders()) {
            if (ticketProcessFolder.getName().toLowerCase().contains(lowerSearchTerm)) {
                return true;
            }
            if (!this.isMatchiongFolder(searchTerm, ticketProcessFolder)) continue;
            return true;
        }
        return false;
    }

    private void getFolderBreadCrumbs(GUID processFolderGuid, Stack<ProcessFolderDescription> folderBreadcrumbs, TicketProcessManager ticketProcessManager) {
        TicketProcessFolder folder = ticketProcessManager.getFolder(processFolderGuid);
        if (folder == null || StringFunctions.isEmpty((String)folder.getName())) {
            return;
        }
        ProcessFolderDescription d = new ProcessFolderDescription(processFolderGuid.toString(), folder.getName(), folder.isEmpty(), !folder.getSubFolders().isEmpty());
        folderBreadcrumbs.insertElementAt(d, 0);
        TicketProcessFolder parentFolder = folder.getParent();
        if (parentFolder != null) {
            this.getFolderBreadCrumbs(parentFolder.getId(), folderBreadcrumbs, ticketProcessManager);
        }
    }

    public String getMethodName() {
        return "ticketprocess.getprocesslist";
    }
}

