/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client;

import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.ConfigSearchSuggestion;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TicketProcessConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.ticketprocess";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.configuration.page.shortname", new Object[0]);
    }

    public String getFullDisplayName() {
        return TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.configuration.page.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.configuration.page.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketprocess/server/plugin/process_manager_48.png");
    }

    public boolean isAccessAllowed() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }

    public String getHelpKey() {
        return "configuration.ticketprocess";
    }

    public List<ConfigSearchSuggestion> getSearchSuggestions(String searchTerm, Map<String, String> properties) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        if (TicketProcessPlugin.CONFIG_PAGE.getFullDisplayName().toLowerCase().contains(searchTerm.toLowerCase())) {
            suggestions.add(new ConfigSearchSuggestion(TicketProcessPlugin.CONFIG_PAGE.getFullDisplayName(), "page/configuration.ticketprocess/", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.templates", new Object[0]), 20, true));
        }
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        List<TicketProcess> processes = ticketProcessManager.getProcesses();
        for (TicketProcess process : processes) {
            String description = process.getDescription();
            if (!process.getName().toLowerCase().contains(searchTerm.toLowerCase()) && (description == null || !description.toLowerCase().contains(searchTerm.toLowerCase()))) continue;
            suggestions.add(new ConfigSearchSuggestion(StringFunctions.encodeHTML((String)process.getName()), "page/configuration.ticketprocess/editprocess/" + process.getId().toString(), this.getShortDisplayName(), 20));
        }
        suggestions.addAll(this.createFolderSuggestion(searchTerm.toLowerCase(), ticketProcessManager.getRootFolder()));
        return suggestions;
    }

    private List<ConfigSearchSuggestion> createFolderSuggestion(String lowerSearchTerm, TicketProcessFolder folder) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        if (!folder.getName().isEmpty() && folder.getName().toLowerCase().contains(lowerSearchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(StringFunctions.encodeHTML((String)folder.getName()), "page/configuration.ticketprocess/processfolder/" + folder.getId().toString(), this.getShortDisplayName(), 10));
        }
        for (TicketProcessFolder subFolder : folder.getSubFolders()) {
            suggestions.addAll(this.createFolderSuggestion(lowerSearchTerm, subFolder));
        }
        return suggestions;
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.ticketprocess.html";
    }
}

