/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessRef;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ParallelTicketTimer;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessTicketEventLog;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.StartProcessActionExtension;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;

public class FinishProcessActionExtension
implements TicketActionExtensionFactory {
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepFields) {
        if (action.getId() == -34) {
            return new Extension();
        }
        return null;
    }

    private class Extension
    implements TicketActionExtension {
        private Extension() {
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            TicketProcess process = ProcessOperations.getProcessOfTicket(ticket);
            if (process == null) {
                TicketProcessPlugin.LOGGER.warn((Object)("Tried to finish process in a ticket without process: " + ticket.getTicketId()));
                return;
            }
            ProcessOperations.closeAllParallelTickets(ticket, true);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS, null);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ACTIVITY, null);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS, null);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, null);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_ORIGINAL_PROCESS, null);
            ticket.getNewTicketAttributes().put(TicketProcessManager.ATTRIBUTE_PROCESS_START_DATE, null);
            reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)StartProcessActionExtension.maxlen(process.getName(), 255));
            reaStep.getFields().put(TicketProcessManager.REASTEP_FIELD_PROCESS, (Object)new ProcessRef(process.getId(), process.getName()));
            ticket.getAfterWriteOperations().add(() -> {
                ProcessTicketEventLog.ProcessLeft.log(process, ticket.getTicketId());
                ParallelTicketTimer.getInstance().cancelTimersFor(ticket.getTicketId());
            });
        }
    }
}

