/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ActivityTransitionAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.ActionBeendenOnProcessExtension;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.NotActiveException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class ActionTransitionOnProcessExtension
implements TicketActionExtensionFactory {
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepFields) {
        if (ticket.getOldTicket().isPresent() && ((TicketVO)ticket.getOldTicket().get()).isSlaveInBundle()) {
            return null;
        }
        ActivityTransition activityTransition = this.getTransitionToApplyWithOperation(ticket.createIntermediateTicketVO(), action, arguments);
        if (activityTransition != null) {
            return new Extension(arguments, activityTransition);
        }
        TicketProcess tp = ProcessOperations.getProcessOfTicket(ticket);
        if (tp != null && Status.isClosedOrDeletedStatus((int)action.getStatusID())) {
            return new ActionBeendenOnProcessExtension();
        }
        return null;
    }

    private ActivityTransition getTransitionToApplyWithOperation(TicketVO ticket, ActionVO action, ExtensionArguments arguments) {
        if (ticket.isSlaveInBundle()) {
            return null;
        }
        if (action instanceof ActivityTransitionAction) {
            return ((ActivityTransitionAction)action).getTransition();
        }
        Activity activityOfTicket = TicketProcessManager.getActivityOfTicket(ticket);
        if (activityOfTicket != null && !Boolean.TRUE.equals(arguments.get(TicketProcessManager.EXT_ARG_TRANSITION_SUB_OPERATION))) {
            GUID ressId2;
            ProcessValueReference b;
            GUID targetResource;
            ExtensionArguments.ResourceActionExtensionData resourceActionExtensionData = (ExtensionArguments.ResourceActionExtensionData)arguments.get(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA);
            if (resourceActionExtensionData != null) {
                targetResource = resourceActionExtensionData.getTargetResID();
                for (ActivityTransition tra : activityOfTicket.getFollowUpActivities()) {
                    b = tra.getNextActivity().getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID);
                    if (tra.getActionid() != action.getId() || b == null) continue;
                    try {
                        ressId2 = (GUID)ProcessTools.getValueFromProcessTicketData(Tickets.FIELD_RESOURCE_GUID, tra.getNextActivity().getIncomingTicketData(), () -> ProcessTickets.createOldSnapshot(ticket));
                        if (!Objects.equals(targetResource, ressId2)) continue;
                        return tra;
                    }
                    catch (NotActiveException ressId2) {
                    }
                }
            }
            if (action.getId() == 5 && ticket.getValue((TicketField)Tickets.FIELD_RESOURCE_GUID) != null) {
                targetResource = (GUID)ticket.getValue((TicketField)Tickets.FIELD_RESOURCE_GUID);
                for (ActivityTransition tra : activityOfTicket.getFollowUpActivities()) {
                    b = tra.getNextActivity().getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID);
                    if (tra.getActionid() != action.getId() || b == null || tra.isAutoTransition()) continue;
                    try {
                        ressId2 = (GUID)ProcessTools.getValueFromProcessTicketData(Tickets.FIELD_RESOURCE_GUID, tra.getNextActivity().getIncomingTicketData(), () -> ProcessTickets.createOldSnapshot(ticket));
                        if (!Objects.equals(targetResource, ressId2)) continue;
                        return tra;
                    }
                    catch (NotActiveException notActiveException) {
                    }
                }
            }
            if (!activityOfTicket.getPossibleActions().contains(action.getId()) && action.getId() != 5 && action.getId() != 8) {
                for (ActivityTransition tra : activityOfTicket.getFollowUpActivities()) {
                    if (tra.getActionid() != action.getId() || tra.isAutoTransition()) continue;
                    ActionVO primaryAction = (ActionVO)arguments.get(ExtensionArguments.EXTARG_PRIMARY_ACTION);
                    if (primaryAction != null && !primaryAction.getUniqueID().equals(action.getUniqueID()) && this.getTransitionToApplyWithOperation(ticket, primaryAction, arguments) != null) {
                        return null;
                    }
                    return tra;
                }
            }
        }
        return null;
    }

    public String checkActionPreconditions(TicketVO ticket, ActionVO action, TicketPermissionContext ticketPermissionInfo) {
        int actionId = action.getId();
        switch (actionId) {
            case -37: 
            case -19: {
                ItilLinkManager linkManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
                if (linkManager.getItilMasterOf(ticket.getID()) != null) {
                    return TicketProcessManager.MSG.getMsg("handling.error.ticketIsItilSlave", new Object[0]);
                }
            }
            case -36: {
                if (!Status.isOpenStatus((int)ticket.getStatusID())) {
                    return TicketProcessManager.MSG.getMsg("handling.error.ticketClosed", new Object[0]);
                }
            }
            case -34: {
                if (!ticketPermissionInfo.hasSupporterWriteAccessToTicket()) {
                    return TicketProcessManager.MSG.getMsg("handling.error.requiresSupporterPermission", new Object[0]);
                }
                if (ticket.isSlaveInBundle()) {
                    return Tickets.MSG.getMsg("actionchecker.ticketMustNotBeSlave", new Object[0]);
                }
                if (actionId != -19 && actionId != -34 && actionId != -37 || ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) == null) break;
                return TicketProcessManager.MSG.getMsg("handling.error.cannotInvokeOnParallel", new Object[0]);
            }
            case -18: {
                return "Action cannot be invoked manually and field 'process activity' cannot be changed manually";
            }
        }
        Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
        if (activity != null) {
            if (action instanceof ActivityTransitionAction) {
                TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
                if (process.getActivity(((ActivityTransitionAction)action).getTransition().getNextActivity().getId()) == null) {
                    return TicketProcessManager.MSG.getMsg("handling.error.wrongProcess", new Object[0]);
                }
                if (ticket.isSlaveInBundle()) {
                    return Tickets.MSG.getMsg("actionchecker.ticketMustNotBeSlave", new Object[0]);
                }
                ActivityTransitionAction tra = (ActivityTransitionAction)action;
                if (tra.getTransition().isAutoTransition()) {
                    return TicketProcessManager.MSG.getMsg("handling.error.cannotInvokeAutoTransitionManually", new Object[0]);
                }
                return null;
            }
            List<Integer> possibleActions = activity.getPossibleActions();
            if (possibleActions.contains(actionId) || HDUsersAndGroups.isPrivilegedUser((GUID)UserManager.getInstance().getCurrentUserAccountID())) {
                return null;
            }
            if (TicketProcessManager.ALWAYS_ALLOWED_ACTIONS.contains(actionId)) {
                return null;
            }
            return TicketProcessManager.MSG.getMsg("handling.error.actionNotAllowedByActivity", new Object[]{action.getDisplayValue(), activity.getName()});
        }
        if (actionId == -34 || actionId == -37 || actionId == -36 || action instanceof ActivityTransitionAction) {
            return TicketProcessManager.MSG.getMsg("handling.error.actionOnlyPossibleOnProcess", new Object[]{action.getDisplayValue()});
        }
        return super.checkActionPreconditions(ticket, action, ticketPermissionInfo);
    }

    public List<ActionVO> additionalActionsForTicket(TicketVO ticket) {
        Activity activity = TicketProcessManager.getActivityOfTicket(ticket);
        if (activity != null) {
            ArrayList<ActionVO> additionalActions = new ArrayList<ActionVO>();
            for (ActivityTransition transition : activity.getFollowUpActivities()) {
                if (transition.isAutoTransition()) continue;
                ActionVO underlying = (ActionVO)ActionManager.getInstance().get(transition.getActionid());
                TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(ticket);
                if (processOfTicket == null) continue;
                additionalActions.add(new ActivityTransitionAction(underlying, transition, processOfTicket));
            }
            return additionalActions;
        }
        return super.additionalActionsForTicket(ticket);
    }

    public int getExecutionPriority() {
        return 40;
    }

    @Nonnull
    public Map<? extends TicketField<?>, ? extends String> checkForMandatoryFields(TicketVO ticket, ActionVO action, Consumer<TicketField<?>> checker, ExtensionArguments extensionArgs) {
        if (ticket == null) {
            return Collections.emptyMap();
        }
        ActivityTransition tra = action instanceof ActivityTransitionAction ? ((ActivityTransitionAction)action).getTransition() : this.getTransitionToApplyWithOperation(ticket, action, extensionArgs);
        if (tra != null) {
            TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket);
            if (!ticketPermissionInfo.hasDispatcherAccessToTicket() && !ticketPermissionInfo.hasResourceAccessToTicket()) {
                return Collections.emptyMap();
            }
            Activity nextActivity = tra.getNextActivity();
            nextActivity.getRequiredFieldKeys().stream().map(key -> Tickets.getFieldByKey((String)key)).forEach(f -> checker.accept((TicketField<?>)f));
        }
        return Collections.emptyMap();
    }

    private class Extension
    implements TicketActionExtension {
        private ExtensionArguments arguments;
        private ActivityTransition transition;

        public Extension(ExtensionArguments arguments, ActivityTransition transition) {
            Objects.requireNonNull(arguments);
            Objects.requireNonNull(transition);
            this.arguments = arguments;
            this.transition = transition;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            ProcessValueReference targetRess;
            String actionLabel;
            Activity nextActivity = this.transition.getNextActivity();
            if (action instanceof ActivityTransitionAction) {
                actionLabel = action.getDisplayValue();
            } else {
                TicketProcess processOfTicket = ProcessOperations.getProcessOfTicket(ticket);
                actionLabel = ActivityTransitionAction.generateLabelIfEmpty(action, this.transition, ProcessTools.startActivityOfBranchHoldingActivity(nextActivity.getId(), processOfTicket));
            }
            if (!StringFunctions.isEmpty((String)actionLabel)) {
                reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_ACTION_LABEL, (Object)actionLabel);
            }
            ProcessOperations.onNextActivity(ticket, reaStep, nextActivity, action);
            if (action.getId() == 8 && (targetRess = nextActivity.getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID)) != null) {
                try {
                    GUID resourceId = (GUID)ProcessTools.getValueFromProcessTicketData(Tickets.FIELD_RESOURCE_GUID, nextActivity.getIncomingTicketData(), () -> new ProcessTickets(ticket, ProcessOperations.getProcessOfTicket(ticket)));
                    if (Objects.equals(ticket.getFieldValue((TicketField)Tickets.FIELD_RESOURCE_GUID), resourceId)) {
                        ticket.getNewTicketData().put((TicketField)Tickets.FIELD_RESOURCE_GUID, null);
                    }
                    this.arguments.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)resourceId, (boolean)true));
                }
                catch (NotActiveException notActiveException) {
                    // empty catch block
                }
            }
        }
    }
}

