/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.SearchResultListener;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParallelTicketTimer {
    private static ParallelTicketTimer INSTANCE = new ParallelTicketTimer();
    private Map<Integer, List<DefaultTimerTask>> activeProcesses = new HashMap<Integer, List<DefaultTimerTask>>();

    public static ParallelTicketTimer getInstance() {
        return INSTANCE;
    }

    public synchronized void startTimersFor(final TicketVO ticket) {
        this.cancelTimersFor(ticket.getID());
        if (Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) {
            return;
        }
        ActiveProcess process = TicketProcessManager.getActiveProcessOfTicket(ticket);
        if (process == null || process.getSettings().getParallelTicketLatestStarts().isEmpty()) {
            return;
        }
        ArrayList<1> map = new ArrayList<1>();
        for (final Map.Entry<GUID, Long> en : process.getSettings().getParallelTicketLatestStarts().entrySet()) {
            if (((Map)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).get(en.getKey()) != null) continue;
            DefaultTimerTask task = new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    try (UserAccountScope sc = UserAccountScope.createPrivileged();){
                        TicketVO current = TicketManager.getReaderForSystem().getTicket(ticket.getID());
                        if (current == null || Status.isClosedOrDeletedStatus((int)current.getStatusID())) {
                            return;
                        }
                        TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(current);
                        if (processOfTicket == null) {
                            return;
                        }
                        Map children = (Map)current.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS);
                        Integer childId = (Integer)children.get(en.getKey());
                        if (childId == null) {
                            TicketManager.getManipulator().performManipulation(model -> ProcessOperations.createParallelTicket(processOfTicket.getParallelTicket((GUID)en.getKey()), ProcessTickets.createOldSnapshot(current), model));
                        }
                    }
                }
            };
            map.add(task);
            DefaultTimer.getInstance().schedule(task, new Date(en.getValue()));
        }
        this.activeProcesses.put(ticket.getID(), map);
    }

    public synchronized void cancelTimersFor(int ticketId) {
        List<DefaultTimerTask> map = this.activeProcesses.get(ticketId);
        if (map != null) {
            map.forEach(timer -> timer.cancel());
            this.activeProcesses.remove(ticketId);
        }
    }

    public void onServerStart() {
        TicketManager.getReader().getSearchEngine().addSearchResultListener((SearchResultListener)new SearchResultListener<Integer>(new SearchCommand(new SearchExpression[0])){

            protected void onPossibleChange() {
                Thread t = new Thread(() -> {
                    TicketProcessPlugin.LOGGER.debug((Object)"Initialize Timers for latest start of Process-Tickets");
                    try (UserAccountScope sc = UserAccountScope.createPrivileged();){
                        Set tickets = TicketManager.getReader().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(TicketProcessManager.ATTRIBUTE_PROCESS.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)""), new SearchCondition(Tickets.ATTRIBUTE_STATUS_ID.getKey(), SearchCondition.SearchTermOperator.LE, (Object)300), new SearchCondition(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey(), SearchCondition.SearchTermOperator.Equals, null)}));
                        for (Integer ticketId : tickets) {
                            TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                            if (ticket == null) continue;
                            ParallelTicketTimer.this.startTimersFor(ticket);
                        }
                    }
                });
                t.setDaemon(true);
                t.setName("Init Process Timers");
                t.start();
            }
        });
    }
}

