/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ActivityTransitionDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class ActivityDetailsDescription {
    public static final String DISPLAYTYPE_RELATIVEABSOLUTEDATEVALUE = "relativeabsolutedatevalue";
    private String id;
    private String name;
    private String description;
    private String nextProcessToStart;
    private Activity.Type type;
    private List<String> requiredFieldKeys;
    private List<ActivityTransitionDetailsDescription> transitions = new ArrayList<ActivityTransitionDetailsDescription>();
    private List<ActionDescription> allowedActions = new ArrayList<ActionDescription>();
    private Map<String, String> ticketDataToSetAtStartValues = new HashMap<String, String>();
    private Map<String, Integer> ticketDataToSetAtStartSettings = new HashMap<String, Integer>();
    private Map<String, String> ticketDataToReferencedFields = new HashMap<String, String>();
    private Map<String, FieldEditDescription> ticketDataToSetAtStartFields = new HashMap<String, FieldEditDescription>();
    private boolean appendTextOfMainTicketIntoParallel = false;

    public static ActivityDetailsDescription from(Activity activity) {
        ReaStepTextVO ticketText;
        ProcessTicketData processTicketData;
        List<Integer> possibleActions;
        ActivityDetailsDescription a = new ActivityDetailsDescription();
        a.id = activity.getId().toString();
        a.name = activity.getName();
        a.description = activity.getDescription();
        a.nextProcessToStart = activity.getNextProcessToStart() == null ? null : activity.getNextProcessToStart().toString();
        a.type = activity.getType();
        a.requiredFieldKeys = activity.getRequiredFieldKeys();
        a.appendTextOfMainTicketIntoParallel = activity.isAppendTextOfMainTicketIntoParallel();
        List<ActivityTransition> followUpActivities = activity.getFollowUpActivities();
        if (followUpActivities != null) {
            for (ActivityTransition activityTransition : followUpActivities) {
                a.transitions.add(ActivityTransitionDetailsDescription.from(activityTransition));
            }
        }
        if ((possibleActions = activity.getPossibleActions()) != null) {
            for (Integer actionId : possibleActions) {
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId.intValue());
                if (actionVO == null) continue;
                a.allowedActions.add(TicketFunctions.convertToActionDescription((ActionVO)actionVO));
            }
        }
        if ((processTicketData = activity.getIncomingTicketData()) != null) {
            MutableTicketAttributes attributes = new MutableTicketAttributes();
            attributes.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)0);
            MutableTicketData fields = new MutableTicketData();
            HashMap convertedDateValue = new HashMap();
            for (TicketField<?> field : processTicketData.getIncludedFields()) {
                ProcessValueReference processValueReference = processTicketData.get(field);
                if (processValueReference.hasConcreteValue()) {
                    Object value = processTicketData.get(field).getValue();
                    if (value instanceof RelativeOrAbsoluteDate) {
                        convertedDateValue.put(field, (RelativeOrAbsoluteDate)value);
                    } else {
                        fields.put(field, value);
                    }
                }
                if (processValueReference.hasReferenceValue()) {
                    GUID parallelTicketId = processValueReference.getParallelTicketId();
                    a.ticketDataToReferencedFields.put(field.getKey(), parallelTicketId == null ? "" : parallelTicketId.toString());
                }
                a.ticketDataToSetAtStartSettings.put(field.getKey(), processValueReference.getReferenceType());
            }
            TicketVOSingle ticketVOSingle = TicketVOSingle.create((int)Integer.MAX_VALUE, (MutableTicketAttributes)attributes, (MutableTicketData)fields);
            GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
            Map<String, TicketFieldDefinition> fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).stream().collect(Collectors.toMap(TicketFieldDefinition::getFieldKey, tfd -> tfd));
            for (TicketField<?> field : processTicketData.getIncludedFields()) {
                FieldEditDefinition editDefinition;
                TicketFieldDefinition tfd2 = fieldDefinitions.get(field.getKey());
                if (tfd2 == null || (editDefinition = tfd2.getEditDefinition()) == null || !editDefinition.isAvailable(null) && !Tickets.FIELD_OWNER_GUID.getKey().equals(editDefinition.getFieldKey())) continue;
                String displayType = editDefinition.getDisplayType();
                ProcessValueReference processValueReference = processTicketData.get(field);
                if ("datevalue".equals(displayType) || "dateonlyvalue".equals(displayType)) {
                    displayType = DISPLAYTYPE_RELATIVEABSOLUTEDATEVALUE;
                    RelativeOrAbsoluteDate ticketValue = (RelativeOrAbsoluteDate)convertedDateValue.get(field);
                    if (ticketValue == null) {
                        ticketValue = RelativeOrAbsoluteDate.createRelative((long)0L);
                    }
                    if (processValueReference.hasConcreteValue()) {
                        a.ticketDataToSetAtStartValues.put(editDefinition.getFieldKey(), new Json().toJson((Object)ticketValue));
                    }
                } else if (processValueReference.hasConcreteValue()) {
                    editDefinition.updateCurrentValue((TicketVO)ticketVOSingle, currentUserAccountID, a.ticketDataToSetAtStartValues);
                }
                a.ticketDataToSetAtStartFields.put(editDefinition.getFieldKey(), new FieldEditDescription(editDefinition.getFieldKey(), displayType, editDefinition.getDisplayName(), tfd2.getDescription(), tfd2.getProperties()));
            }
        }
        if ((ticketText = activity.getTicketText()) != null) {
            String text = ticketText.getText();
            text = ticketText.hasHtmlContent() ? TicketTextFunctions.getInlinedHtml((String)text, (boolean)true) : TicketTextFunctions.getLightHtmlFromPlainText((String)text);
            a.ticketDataToSetAtStartValues.put("htmleditor", text);
            a.ticketDataToSetAtStartValues.put("htmlcontent", Boolean.toString(ticketText.hasHtmlContent()));
            Font defaultFont = TicketTextFunctions.getDefaultFont();
            if (defaultFont != null) {
                a.ticketDataToSetAtStartValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
                a.ticketDataToSetAtStartValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
            }
        }
        return a;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNextProcessToStart() {
        return this.nextProcessToStart;
    }

    public Activity.Type getType() {
        return this.type;
    }

    public List<String> getRequiredFieldKeys() {
        return this.requiredFieldKeys;
    }

    public List<ActivityTransitionDetailsDescription> getTransitions() {
        return this.transitions;
    }

    public List<ActionDescription> getAllowedActions() {
        return this.allowedActions;
    }

    public Map<String, String> getTicketDataToSetAtStartValues() {
        return this.ticketDataToSetAtStartValues;
    }

    public Map<String, String> getTicketDataToReferencedFields() {
        return this.ticketDataToReferencedFields;
    }

    public Map<String, FieldEditDescription> getTicketDataToSetAtStartFields() {
        return this.ticketDataToSetAtStartFields;
    }

    public boolean isAppendTextOfMainTicketIntoParallel() {
        return this.appendTextOfMainTicketIntoParallel;
    }

    public Map<String, Integer> getTicketDataToSetAtStartSettings() {
        return this.ticketDataToSetAtStartSettings;
    }
}

