/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.reporting;

import com.inet.helpdesk.core.reporting.TicketDataSourceConfigurationExtension;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessTicketDataSourceExtension
implements TicketDataSourceConfigurationExtension {
    public static final String COLUMN_PROCESS_MAIN_TICKET_ID = TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey();

    public void patchColumns(List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols) {
        cols.add(Map.entry(COLUMN_PROCESS_MAIN_TICKET_ID, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_PROCESS_MAIN_TICKET_ID, TicketProcessManager.MSG.getMsg("datasource.columnMainticket.name", new Object[0]), 6)));
    }

    public boolean canHandle(String columnKey) {
        return columnKey.equals(COLUMN_PROCESS_MAIN_TICKET_ID) || columnKey.equals(TicketProcessManager.ATTRIBUTE_PROCESS.getKey());
    }

    public Object getColumnData(TicketVO ticket, String columnKey) {
        if (columnKey.equals(TicketProcessManager.ATTRIBUTE_PROCESS.getKey())) {
            ActiveProcess processOfTicket = TicketProcessManager.getActiveProcessOfTicket(ticket);
            return processOfTicket == null ? null : processOfTicket.getProcessDefinition().getName();
        }
        if (columnKey.equals(COLUMN_PROCESS_MAIN_TICKET_ID)) {
            if (ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) == null) {
                if (ticket.getAttribute(TicketProcessManager.ATTRIBUTE_PROCESS) != null) {
                    return ticket.getID();
                }
            } else {
                return ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
            }
        }
        return null;
    }

    public void patchSearchCommand(SearchCommand command) {
        this.replaceMainTicketConditionIfExists((SearchExpression)command.getSearchExpression());
    }

    private SearchExpression replaceMainTicketConditionIfExists(SearchExpression exp) {
        String leftOp;
        if (exp instanceof AndSearchExpression) {
            AndSearchExpression andSearchExpression = (AndSearchExpression)exp;
            for (int i = 0; i < andSearchExpression.size(); ++i) {
                SearchExpression sub = (SearchExpression)andSearchExpression.get(i);
                SearchExpression replacement = this.replaceMainTicketConditionIfExists(sub);
                if (replacement == null) continue;
                andSearchExpression.set(i, (Object)replacement);
            }
        } else if (exp instanceof OrSearchExpression) {
            OrSearchExpression orSearchExpression = (OrSearchExpression)exp;
            for (int i = 0; i < orSearchExpression.size(); ++i) {
                SearchExpression sub = (SearchExpression)orSearchExpression.get(i);
                SearchExpression replacement = this.replaceMainTicketConditionIfExists(sub);
                if (replacement == null) continue;
                orSearchExpression.set(i, (Object)replacement);
            }
        } else if (exp instanceof SearchCondition && Objects.equals(leftOp = ((SearchCondition)exp).getLeftOperand(), TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey())) {
            Object value = ((SearchCondition)exp).getRightOperand();
            switch (((SearchCondition)exp).getOperator()) {
                case Equals: {
                    OrSearchExpression orSearchExpression = new OrSearchExpression();
                    orSearchExpression.add((Object)new SearchCondition(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey(), SearchCondition.SearchTermOperator.Equals, value));
                    orSearchExpression.add((Object)new SearchCondition("ticketid", SearchCondition.SearchTermOperator.Equals, value));
                    return orSearchExpression;
                }
            }
            throw new UnsupportedOperationException(TicketProcessManager.MSG.getMsg("datasource.columnMainticket.limitationMessage", new Object[0]));
        }
        return null;
    }
}

