/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.ProcessOperations;
import com.inet.helpdesk.shared.model.Status;
import com.inet.usersandgroups.api.user.UserAccountScope;

public class ActionBeendenOnProcessExtension
implements TicketActionExtension,
TicketEventListener {
    public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
        if (ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) == null) {
            ProcessOperations.closeAllParallelTickets(ticket, false);
        } else {
            ProcessOperations.checkConditionsAfterClosingParallelTicket(ticket, action);
        }
    }

    public void handleEvent(TicketEvent event) {
        event.getChangedTickets().forEach(changed -> {
            TicketVO ticket = changed.getNewTicket();
            if (ticket == null) {
                return;
            }
            if (!Status.isClosedOrDeletedStatus((int)ticket.getStatusID()) || changed.getOldTicket() != null && Status.isClosedOrDeletedStatus((int)changed.getOldTicket().getStatusID())) {
                return;
            }
            TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
            if (process == null) {
                return;
            }
            try (UserAccountScope pr = UserAccountScope.createPrivileged();){
                if (ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) == null) {
                    TicketManager.getManipulator().performManipulation(model -> {
                        OperationChangedTicket opTicket = model.changeExistingTicket(ticket.getID());
                        if (Status.isClosedOrDeletedStatus((int)((Integer)opTicket.getAttributeValue((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID))) && ProcessOperations.getProcessOfTicket(opTicket) != null) {
                            ProcessOperations.closeAllParallelTickets(opTicket, false);
                        }
                    });
                } else {
                    TicketManager.getManipulator().performManipulation(model -> {
                        OperationChangedTicket opTicket = model.changeExistingTicket(ticket.getID());
                        ProcessOperations.checkConditionsAfterClosingParallelTicket(opTicket, (ActionVO)ActionManager.getInstance().get(2));
                    });
                }
            }
        });
    }
}

