/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.http.error.ServletErrorHandler;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;

public class TicketValueIcon
extends ServiceMethod<Void, Void> {
    private static URL fallBackImageURL = null;
    private static final int DEFAULT_SIZE = 16;

    public TicketValueIcon() {
        try {
            BufferedImage img = new BufferedImage(16, 16, 2);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "PNG", baos);
            fallBackImageURL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        catch (Throwable t) {
            TicketListServerPlugin.LOGGER.error(t);
        }
    }

    public String getMethodName() {
        return "ticketlist.ticketvalueicon";
    }

    public short getMethodType() {
        return 2;
    }

    public Void invoke(HttpServletRequest request, HttpServletResponse response, Void input) {
        String value = request.getParameter("value");
        String header = request.getParameter("header");
        String column = request.getParameter("column");
        String requestedSize = request.getParameter("size");
        Integer requestedSizeInt = 16;
        try {
            requestedSizeInt = Integer.parseInt(requestedSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (StringFunctions.isEmpty((String)column)) {
            try {
                AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (URL)fallBackImageURL, null, (String)"", (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition ticketFieldDefinition : ticketFieldDefinitions) {
            URL iconURL;
            if (!ticketFieldDefinition.getKey().equals(column)) continue;
            URL uRL = iconURL = "true".equalsIgnoreCase(header) ? ticketFieldDefinition.getColumnIcon(requestedSizeInt) : ticketFieldDefinition.getIconForValue(value, requestedSizeInt.intValue());
            if (iconURL == null) {
                iconURL = fallBackImageURL;
            }
            try {
                AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (URL)iconURL, null, (String)"", (boolean)true);
            }
            catch (IOException e) {
                if (ServletErrorHandler.isClientAbort((Throwable)e)) break;
                TicketListServerPlugin.LOGGER.error((Throwable)e);
                try {
                    AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (URL)fallBackImageURL, null, (String)"", (boolean)true);
                }
                catch (IOException iOException) {}
            }
            break;
        }
        return null;
    }
}

