/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.SaveAnnotationRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class SaveAnnotation
extends AbstractTicketListHandler<SaveAnnotationRequest, Void> {
    public String getMethodName() {
        return "ticketlist.extension.annotation.saveannotation";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, SaveAnnotationRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        boolean hasPermission = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        try {
            if (!hasPermission) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.permissionrequired.supporter", new Object[0]));
            }
            int ticketId = input.getTicketId();
            MutableTicketData ticketData = new MutableTicketData();
            ticketData.put((TicketField)Tickets.FIELD_ANNOTATION, (Object)input.getAnnotation());
            TicketManager.getManipulator().updateTicketData(ticketId, ticketData);
        }
        catch (AccessDeniedException | IllegalArgumentException iae) {
            TicketListServerPlugin.LOGGER.debug((Object)iae);
            throw new ClientMessageException(iae.getMessage());
        }
        return null;
    }
}

