/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetAnnotationRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetAnnotationResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class GetAnnotation
extends AbstractTicketListHandler<GetAnnotationRequest, GetAnnotationResponse> {
    public String getMethodName() {
        return "ticketlist.extension.annotation.getannotation";
    }

    @Override
    protected GetAnnotationResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetAnnotationRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        boolean supporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        if (!supporter) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.permissionrequired.supporter", new Object[0]));
        }
        String annotation = null;
        int ticketId = input.getTicketId();
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket != null) {
            annotation = ticket.getAnnotation();
        }
        return new GetAnnotationResponse(annotation);
    }
}

