/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.ChangeLinksRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChangeLinks
extends AbstractTicketListHandler<ChangeLinksRequest, Void> {
    public String getMethodName() {
        return "ticketlist.extension.links.changeticketlinks";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, ChangeLinksRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        int currentTicketId = input.getCurrentTicketId();
        List<Integer> opponentTicketIds = input.getOpponentTicketIds();
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(currentTicketId)) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{currentTicketId}));
        }
        ArrayList<Integer> errorIds = new ArrayList<Integer>();
        if (input.isItil()) {
            for (Integer ticketId : opponentTicketIds) {
                if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId.intValue())) {
                    errorIds.add(ticketId);
                    continue;
                }
                ItilLinkManager itilManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
                this.checkCanChangeOpponentTicket(ticketId);
                if (input.isUnlink()) {
                    itilManager.removeLinkFromItilSlaveToItilMaster(ticketId.intValue());
                    continue;
                }
                itilManager.linkItilSlavesToItilMaster(currentTicketId, Set.of(ticketId), (String)currentUser.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
            }
            if (!errorIds.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < errorIds.size(); ++i) {
                    sb.append("#").append((Integer)errorIds.get(i));
                    if (i >= errorIds.size() - 1) continue;
                    sb.append(",");
                }
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.noaccesstotickets", new Object[]{sb}));
            }
            return null;
        }
        if (opponentTicketIds.size() > 0) {
            for (Integer ticketId : opponentTicketIds) {
                int opponentTicketId = ticketId;
                if (input.isSwitchDirection()) {
                    opponentTicketId = input.getCurrentTicketId();
                    currentTicketId = ticketId;
                }
                if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(opponentTicketId)) {
                    errorIds.add(ticketId);
                    continue;
                }
                ActionVO linkAction = (ActionVO)ActionManager.getInstance().get(-35);
                if (linkAction == null || TicketManager.getTicketActionChecker().checkAction(linkAction, currentTicketId) != null) {
                    errorIds.add(ticketId);
                    continue;
                }
                if (input.isUnlink()) {
                    if (input.isBidirectional()) {
                        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(opponentTicketId)) {
                            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{opponentTicketId}));
                        }
                        this.checkCanChangeOpponentTicket(opponentTicketId);
                        if (TicketManager.getTicketActionChecker().checkAction(linkAction, opponentTicketId) != null) {
                            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.linkingnotallowed", new Object[]{opponentTicketId}));
                        }
                        TicketManager.getTicketLinking().removeBiDirectionalLinkBetween(currentTicketId, opponentTicketId);
                        continue;
                    }
                    TicketManager.getTicketLinking().removeUniDirectionalLinkBetween(currentTicketId, opponentTicketId);
                    continue;
                }
                if (input.isBidirectional()) {
                    if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(opponentTicketId)) {
                        throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{opponentTicketId}));
                    }
                    this.checkCanChangeOpponentTicket(opponentTicketId);
                    if (TicketManager.getTicketActionChecker().checkAction(linkAction, opponentTicketId) != null) {
                        throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.linkingnotallowed", new Object[]{opponentTicketId}));
                    }
                    TicketManager.getTicketLinking().addBidirectionalLinkBetween(currentTicketId, opponentTicketId);
                    continue;
                }
                TicketManager.getTicketLinking().addUniDirectionalLink(currentTicketId, opponentTicketId);
            }
            if (!errorIds.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < errorIds.size(); ++i) {
                    sb.append("#").append((Integer)errorIds.get(i));
                    if (i >= errorIds.size() - 1) continue;
                    sb.append(",");
                }
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.noaccesstotickets", new Object[]{sb}));
            }
        } else {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.noaccesstoticket", new Object[0]));
        }
        return null;
    }

    private void checkCanChangeOpponentTicket(int opponentTicketId) {
        TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        TicketAccessInfo ticketAccessInfo = ticketAccessInformationsProvider.getTicketAccessInfo(opponentTicketId);
        if (ticketAccessInfo != null && ticketAccessInfo.getWriteSession() != null && !ticketAccessInfo.getWriteSession().getUser().equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{opponentTicketId}));
        }
    }
}

