/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.datasource;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithDate;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class TicketListFieldsDataSourceConfiguration
extends BaseDataFactory {
    private static final MemoryStoreMap<String, byte[]> ICON_CACHE = new MemoryStoreMap(30, true);
    private static MemoryStoreMap<UserAccount, ArrayList<String>> mapVisiblityTicketList = new MemoryStoreMap(30, false);
    public static final String TABLE_TICKETFIELDS = "TicketFields";

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Hardcoded for ticket reports")
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        ArrayList<String> columns = new ArrayList<String>();
        List<ColumnInfo> cols = this.getColumns(ts);
        cols.stream().filter(c -> c.getColumnType() == 3).forEach(c -> columns.add(c.getName()));
        List<Number> ticketIDs = new ArrayList<Number>();
        List prompts = ts.getInputParameters();
        if (!prompts.isEmpty()) {
            PromptField field = (PromptField)prompts.get(0);
            Object value = field.getPromptValue();
            if (value instanceof Object[]) {
                ticketIDs = Arrays.stream((Object[])value).filter(Number.class::isInstance).map(Number.class::cast).collect(Collectors.toList());
            } else if (value instanceof Number) {
                ticketIDs.add((Number)value);
            }
        }
        Set<Integer> searchResult = ticketIDs.stream().map(Number::intValue).collect(Collectors.toSet());
        SimpleResultSet rs = this.getResultSet(columns, searchResult);
        TableData tableData = new TableData((ResultSet)rs);
        return tableData;
    }

    protected SimpleResultSet getResultSet(ArrayList<String> columns, final Set<Integer> searchResult) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        this.initVisibilitiesForTicketList(currentUserAccount);
        final List listTicketFieldVisibility = (List)mapVisiblityTicketList.get((Object)currentUserAccount);
        SimpleResultSet rs = new SimpleResultSet(columns.toArray(new String[columns.size()])){
            private final Iterator<Integer> ids;
            {
                super(arg0);
                this.ids = searchResult.iterator();
            }

            @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only reading saved icon files")
            public boolean next() throws SQLException {
                if (this.getRowCount() > 0) {
                    return super.next();
                }
                while (this.ids.hasNext()) {
                    Integer id = this.ids.next();
                    TicketVO ticket = TicketListFieldsDataSourceConfiguration.this.getTicketForId(id);
                    if (ticket == null) continue;
                    List<TicketFieldDefinition> includedFields = TicketListFieldsDataSourceConfiguration.this.filterAndSortIncludedFieldDefinitions(listTicketFieldVisibility);
                    for (TicketFieldDefinition field : includedFields) {
                        String valueAsStringForIcon;
                        Long plainValue;
                        Object[] rowData = new Object[5];
                        rowData[0] = id;
                        rowData[1] = field.getLabel();
                        rowData[2] = field.getKey();
                        String displayValue = field.getDisplayValue(ticket);
                        if (field instanceof AbstractTicketFieldDefinitionWithDate && (plainValue = ((AbstractTicketFieldDefinitionWithDate)field).getPlainValue(ticket)) != null) {
                            displayValue = DateTimeUtils.dateTimeToLongFormat((long)plainValue);
                        }
                        rowData[3] = displayValue;
                        rowData[4] = null;
                        if (field.supportsIcon() && (valueAsStringForIcon = field.getValueAsStringForIcon(ticket)) != null) {
                            URL icon;
                            String cacheKey = field.getKey() + valueAsStringForIcon;
                            byte[] bytes = (byte[])ICON_CACHE.get((Object)cacheKey);
                            if (bytes == null && (icon = field.getIconForValue(field.getValueAsStringForIcon(ticket), 32)) != null) {
                                try (InputStream in = icon.openStream();){
                                    bytes = IOFunctions.readBytes((InputStream)in);
                                    ICON_CACHE.put((Object)cacheKey, (Object)bytes);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            rowData[4] = bytes;
                        }
                        if (StringFunctions.isEmpty((String)displayValue)) continue;
                        this.getAllRows().add(rowData);
                    }
                    return super.next();
                }
                return super.next();
            }
        };
        return rs;
    }

    protected void initVisibilitiesForTicketList(UserAccount currentUserAccount) {
        if (mapVisiblityTicketList.containsKey((Object)currentUserAccount)) {
            return;
        }
        ArrayList visibleCols = new ArrayList();
        TicketListLayoutDescription currentLayout = TicketListLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        ArrayList<TicketListColumnDescription> columnsNames = new ArrayList<TicketListColumnDescription>();
        if (currentLayout.getIdentifierColumns() != null && currentLayout.getIdentifierColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getIdentifierColumns());
        }
        if (currentLayout.getFixedColumns() != null && currentLayout.getFixedColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getFixedColumns());
        }
        if (currentLayout.getAdditionalColumns() != null && currentLayout.getAdditionalColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getAdditionalColumns());
        }
        columnsNames.forEach(col -> visibleCols.add(col.getKey()));
        mapVisiblityTicketList.put((Object)currentUserAccount, visibleCols);
    }

    public List<TicketFieldDefinition> filterAndSortIncludedFieldDefinitions(List<String> visibleFieldsList) {
        List<TicketFieldDefinition> includedFields = this.getTicketFieldDefinitions();
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("ticketid");
        excludes.add("subject");
        excludes.add("attachments");
        excludes.add("preview");
        return includedFields.stream().filter(TicketFieldDefinition::isAvailable).filter(a -> visibleFieldsList.contains(a.getFieldKey())).filter(a -> !excludes.contains(a.getFieldKey())).sorted(Comparator.comparingInt(f -> visibleFieldsList.indexOf(f.getFieldKey()))).collect(Collectors.toList());
    }

    protected TicketVO getTicketForId(Integer id) {
        return TicketManager.getReader().getTicket(id.intValue());
    }

    protected IndexSearchEngine<Integer> getSearchEngine() {
        return TicketManager.getReader().getSearchEngine();
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Collections.singletonMap(TABLE_TICKETFIELDS, new TableSourceInfo(null, null, TABLE_TICKETFIELDS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals(TABLE_TICKETFIELDS)) {
            cols.add(new ColumnInfo("TicketId", 6));
            cols.add(new ColumnInfo("Label", 11));
            cols.add(new ColumnInfo("FieldKey", 11));
            cols.add(new ColumnInfo("Value", 11));
            cols.add(new ColumnInfo("Icon", 14));
            cols.add(new ColumnInfo("ticketid", 6, 1, 4, 0));
        }
        return cols;
    }

    protected List<TicketFieldDefinition> getTicketFieldDefinitions() {
        List ticketFields = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        return ticketFields;
    }
}

