/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewCategory;
import com.inet.helpdesk.core.ticketview.TicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.TicketViewVisibility;
import com.inet.helpdesk.plugins.ticketlist.server.data.LoadTicketViewSortSettingsResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.data.PossibleParent;
import com.inet.helpdesk.plugins.ticketlist.server.data.SortDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.SubViewGroupingDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewGroupDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewGroups;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.values.MemberChild;
import com.inet.usersandgroups.api.ui.fields.values.MemberEntry;
import com.inet.usersandgroups.api.ui.fields.values.MemberParent;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LoadTicketViewSortSettingsHandler
extends AbstractTicketListHandler<Void, LoadTicketViewSortSettingsResponseData> {
    public String getMethodName() {
        return "ticketlist.loadticketviewsortsettings";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected LoadTicketViewSortSettingsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        boolean canManageTemplates = SystemPermissionChecker.checkAccess((Permission)HdPermissions.TEMPLATE_DEFINITION);
        boolean hasAccessUsersAndGroups = ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        @Nonnull List categories = ServerPluginManager.getInstance().get(TicketViewCategory.class);
        TicketViewManager tvm = TicketViewManager.getInstance();
        ArrayList<TicketViewVisibility> viewVisibilities = new ArrayList<TicketViewVisibility>(tvm.getViewVisibilities());
        List ticketViewDefinitions = tvm.getViewDefinitions();
        this.mergeOrder(viewVisibilities, ticketViewDefinitions);
        HashMap<String, TicketViewDescription> ticketViewDescriptions = new HashMap<String, TicketViewDescription>();
        for (Object ticketView : ticketViewDefinitions) {
            boolean customView = false;
            String searchCommand = null;
            String parentId = null;
            TicketViewGroups groups = null;
            boolean editable = false;
            TicketViewGroupDescription grouping = null;
            boolean tokenizeGroupingValues = false;
            boolean hideSubnodeTickets = false;
            String rawDisplayName = ticketView.getDisplayName();
            String rawDescription = ticketView.getDescription();
            GUID originalCreator = null;
            if (ticketView instanceof CustomTicketViewDefinition) {
                CustomTicketViewDefinition customTicketViewDefinition = (CustomTicketViewDefinition)ticketView;
                customView = true;
                rawDisplayName = customTicketViewDefinition.getRawDisplayName();
                rawDescription = customTicketViewDefinition.getRawDescription();
                searchCommand = customTicketViewDefinition.getSearchPhrase();
                parentId = customTicketViewDefinition.getParentID();
                originalCreator = customTicketViewDefinition.getOriginalCreator();
                tokenizeGroupingValues = customTicketViewDefinition.isTokenizeGroupingValues();
                hideSubnodeTickets = customTicketViewDefinition.isHideSubnodeTickets();
                if (customTicketViewDefinition.getUserGroups() == null) {
                    editable = true;
                } else if (canManageTemplates) {
                    editable = true;
                    HashMap<Type, Set<MemberEntry>> targetValue = new HashMap<Type, Set<MemberEntry>>();
                    HashSet<UserGroupInfo> groupInfo = new HashSet<UserGroupInfo>();
                    UserGroupManager man = UserGroupManager.getRecoveryEnabledInstance();
                    customTicketViewDefinition.getUserGroups().stream().forEach(o -> {
                        UserGroupInfo group = man.getGroup(GUID.valueOf((String)o));
                        if (group != null && group.isActive()) {
                            groupInfo.add(group);
                        }
                    });
                    Set<MemberEntry> entrys = this.fillFields(groupInfo);
                    targetValue.put(Type.group, entrys);
                    groups = new TicketViewGroups(new Json().toJson(entrys));
                }
            }
            String categoryKey = ticketView.getCategoryKey();
            Optional<@Nonnull TicketViewCategory> category = categories.stream().filter(c -> c.getKey().equals(categoryKey)).findFirst();
            grouping = category.isPresent() ? new TicketViewGroupDescription(category.get().getKey(), category.get().getDisplayName(), category.get().getDescription()) : new TicketViewGroupDescription(categoryKey, categoryKey, ticketView.getDescription());
            TicketViewDescription value = new TicketViewDescription(ticketView.getID(), grouping, ticketView.getDisplayName(), rawDisplayName, ticketView.getDescription(), rawDescription, customView, searchCommand, parentId, editable, groups, ticketView.getSubViewGroupingKey(), originalCreator, tokenizeGroupingValues, hideSubnodeTickets);
            ticketViewDescriptions.put(ticketView.getID(), value);
        }
        LinkedHashMap<String, ArrayList> ticketViewSortDescriptions = new LinkedHashMap<String, ArrayList>();
        for (TicketViewVisibility ticketVisibility : viewVisibilities) {
            TicketViewDescription ticketViewDescription = (TicketViewDescription)ticketViewDescriptions.get(ticketVisibility.getId());
            if (ticketViewDescription == null) continue;
            String parent = ticketViewDescription.getGrouping() == null || ticketViewDescription.getGrouping().getKey() == null ? ticketViewDescription.getId() : ticketViewDescription.getGrouping().getKey();
            ArrayList childrensList = ticketViewSortDescriptions.computeIfAbsent(parent, k -> new ArrayList());
            childrensList.add(new SortDescription(ticketVisibility.getId(), ticketVisibility.isVisible()));
        }
        ArrayList flatTicketViewSortDescriptions = new ArrayList();
        Set keys = ticketViewSortDescriptions.keySet();
        for (String string : keys) {
            flatTicketViewSortDescriptions.addAll((Collection)ticketViewSortDescriptions.get(string));
        }
        List subViewGroupingDefinitions = TicketViewManager.getInstance().getSubViewGroupingDefinitions();
        ArrayList<SubViewGroupingDescription> subGroupOptionsdescriptions = new ArrayList<SubViewGroupingDescription>();
        for (SubViewGroupingDefinition subViewGroupingDefinition : subViewGroupingDefinitions) {
            subGroupOptionsdescriptions.add(new SubViewGroupingDescription(subViewGroupingDefinition.getKey(), subViewGroupingDefinition.getDisplayName(), subViewGroupingDefinition.supportsTokenizeGroupingValues(), subViewGroupingDefinition.supportsHideSubnodeTickets()));
        }
        TicketViewCategory myViewsCategory = categories.stream().filter(c -> c.getKey().equals("myviews")).findFirst().orElseThrow();
        TicketViewCategory globalViewsCategory = categories.stream().filter(c -> c.getKey().equals("globalviews")).findFirst().orElseThrow();
        TicketViewGroupDescription myViewsDescription = new TicketViewGroupDescription(myViewsCategory.getKey(), myViewsCategory.getDisplayName(), myViewsCategory.getDescription());
        TicketViewGroupDescription globalViewsDescription = new TicketViewGroupDescription(globalViewsCategory.getKey(), globalViewsCategory.getDisplayName(), globalViewsCategory.getDescription());
        String dummyClientID = GUID.generateNew().toString();
        ArrayList<PossibleParent> possibleParents = new ArrayList<PossibleParent>();
        Collection currentViewStates = tvm.registerTicketViews(dummyClientID);
        tvm.unregisterTicketList(dummyClientID);
        HashSet addedParentIDs = new HashSet();
        flatTicketViewSortDescriptions.stream().forEach(v -> {
            TicketViewDescription d = (TicketViewDescription)ticketViewDescriptions.get(v.getId());
            if (d == null || d.getGrouping() == null || d.getGrouping().getKey() == null) {
                return;
            }
            addedParentIDs.add(d.getId());
            possibleParents.add(new PossibleParent(d.getId(), d.getDisplayName(), new LocalizedKey(d.getGrouping().getKey(), d.getGrouping().getDisplayName()), null, 0));
        });
        currentViewStates.stream().forEach(s -> this.addViewStateAsPossibleParent(possibleParents, addedParentIDs, (TicketViewState)s, 0));
        List collect = flatTicketViewSortDescriptions.stream().filter(a -> ticketViewDescriptions.containsKey(a.getId())).collect(Collectors.toList());
        return new LoadTicketViewSortSettingsResponseData(ticketViewDescriptions, new ArrayList<SortDescription>(collect), canManageTemplates, hasAccessUsersAndGroups, subGroupOptionsdescriptions, myViewsDescription, globalViewsDescription, possibleParents);
    }

    private void addViewStateAsPossibleParent(ArrayList<PossibleParent> possibleParents, HashSet<String> addedParentIDs, TicketViewState s, int level) {
        if (!addedParentIDs.contains(s.getID())) {
            addedParentIDs.add(s.getID());
            PossibleParent possibleEntry = new PossibleParent(s.getID(), s.getDisplayName(), new LocalizedKey(s.getCategory().getKey(), s.getCategory().getDisplayName()), s.getIconKey(), level);
            int position = -1;
            boolean groupFound = false;
            for (int i = 0; i < possibleParents.size(); ++i) {
                PossibleParent existing = possibleParents.get(i);
                if (existing == null || possibleEntry == null || existing.getKey() == null || possibleEntry.getKey() == null) continue;
                if (existing.getKey().equals(possibleEntry.getKey())) {
                    position = i + 1;
                    break;
                }
                if (!groupFound) {
                    if (!existing.getGrouping().getKey().equals(possibleEntry.getGrouping().getKey())) continue;
                    groupFound = true;
                    continue;
                }
                if (existing.getGrouping().getKey().equals(possibleEntry.getGrouping().getKey())) continue;
                position = i;
                break;
            }
            if (position == -1) {
                possibleParents.add(possibleEntry);
            } else {
                possibleParents.add(position, possibleEntry);
            }
            s.stream().forEach(c -> this.addViewStateAsPossibleParent(possibleParents, addedParentIDs, (TicketViewState)c, level + 1));
        }
    }

    private Set<MemberEntry> fillFields(Set<UserGroupInfo> groupsForUser) {
        HashSet<MemberEntry> members = new HashSet<MemberEntry>();
        UserGroupManager groupManager = UserGroupManager.getRecoveryEnabledInstance();
        HashMap<GUID, List<GUID>> childTree = this.createParentToChildrenMap(groupManager);
        for (UserGroupInfo group : groupsForUser) {
            ArrayList<MemberParent> parents = this.getAncestors(groupManager, group);
            ArrayList<MemberChild> children = this.getChildren(childTree, group);
            MemberEntry memberEntry = MemberEntry.ofGuid((GUID)group.getID(), (Type)Type.group, (String)group.getType().getName(), (String)group.getDisplayName());
            memberEntry.setParents(parents);
            memberEntry.setChildren(children);
            members.add(memberEntry);
        }
        return members;
    }

    private ArrayList<MemberParent> getAncestors(UserGroupManager groupManager, UserGroupInfo group) {
        UserGroupInfo parentGroup;
        ArrayList<MemberParent> parents = new ArrayList<MemberParent>();
        GUID parentID = group.getParentID();
        while (parentID != null && (parentGroup = groupManager.getGroup(parentID)) != null) {
            parents.add(0, new MemberParent(parentID, parentGroup.getDisplayName()));
            parentID = parentGroup.getParentID();
        }
        return parents;
    }

    private HashMap<GUID, List<GUID>> createParentToChildrenMap(UserGroupManager groupManager) {
        HashMap<GUID, List<GUID>> childTree = new HashMap<GUID, List<GUID>>();
        Set allGroups = groupManager.getAllGroups();
        for (UserGroupInfo ugi : allGroups) {
            GUID parentID = ugi.getParentID();
            if (parentID == null) continue;
            List<GUID> list = childTree.get(parentID);
            if (list == null) {
                list = new ArrayList<GUID>();
                childTree.put(parentID, list);
            }
            list.add(ugi.getID());
        }
        return childTree;
    }

    private ArrayList<MemberChild> getChildren(HashMap<GUID, List<GUID>> childTree, UserGroupInfo group) {
        ArrayList<MemberChild> children = new ArrayList<MemberChild>();
        if (group != null) {
            List<GUID> childrenInTree;
            if (childTree == null) {
                childTree = this.createParentToChildrenMap(UserGroupManager.getRecoveryEnabledInstance());
            }
            if ((childrenInTree = childTree.get(group.getID())) != null) {
                this.addChildren(childTree, children, childrenInTree);
            }
        }
        return children;
    }

    private void addChildren(HashMap<GUID, List<GUID>> childTree, ArrayList<MemberChild> children, List<GUID> childrenInTree) {
        UserGroupManager manager = UserGroupManager.getRecoveryEnabledInstance();
        for (GUID cid : childrenInTree) {
            UserGroupInfo group = manager.getGroup(cid);
            if (group == null) continue;
            MemberChild memberChild = new MemberChild(cid, group.getDisplayName());
            children.add(memberChild);
            memberChild.setChildren(this.getChildren(childTree, group));
        }
    }

    private void mergeOrder(List<TicketViewVisibility> order, List<TicketViewDefinition> views) {
        views.removeIf(v -> v.getID() == null);
        LinkedHashMap orderMap = new LinkedHashMap();
        order.forEach(visibility -> orderMap.computeIfAbsent(visibility.getId(), id -> visibility));
        List additionals = views.stream().filter(v -> !orderMap.containsKey(v.getID())).map(v -> new TicketViewVisibility(v.getID(), true)).collect(Collectors.toList());
        order.addAll(additionals);
    }
}

