/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetLinksRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetLinksResponse;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketLink;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GetLinks
extends AbstractTicketListHandler<GetLinksRequest, GetLinksResponse> {
    public String getMethodName() {
        return "ticketlist.extension.links.getlinks";
    }

    @Override
    protected GetLinksResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetLinksRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        SearchTag tag;
        TicketVO ticket;
        Optional<TicketFieldDefinition> findFirst;
        String textField = input.getTextField();
        String iconField = input.getIconField();
        List ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
        TicketFieldDefinition textFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(textField)).findFirst().orElse(null);
        TicketFieldDefinition iconFieldDefinition = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(iconField)).findFirst().orElse(null);
        if (textFieldDefinition == null && (findFirst = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(Tickets.FIELD_SUBJECT.getKey())).findFirst()).isPresent()) {
            textFieldDefinition = findFirst.get();
        }
        if (iconFieldDefinition == null && (findFirst = ticketFieldDefinitions.stream().filter(tfd -> tfd.getKey().equals(Tickets.ATTRIBUTE_STATUS_ID.getKey())).findFirst()).isPresent()) {
            iconFieldDefinition = findFirst.get();
        }
        ArrayList<TicketLink> links = new ArrayList<TicketLink>();
        boolean canAddItilSlave = false;
        boolean canAddItilMaster = false;
        int ticketId = input.getTicketId();
        Integer itilSecondaryCount = 0;
        TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId);
        if (ticketPermissionInfo != null && !ticketPermissionInfo.hasEnduserAccessToTicket() && (ticket = TicketManager.getReader().getTicket(ticketId)) != null) {
            boolean canEdititils;
            if (ticket.isSlaveInBundle()) {
                int masterTicketId = ticket.getBundleID();
                if (TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(masterTicketId)) {
                    TicketVO masterTicket = TicketManager.getReader().getTicket(masterTicketId);
                    links.add(new TicketLink(TicketLink.LinkGroup.bundle, TicketLink.LinkType.bundlemaster, masterTicketId, false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(masterTicket) : null, textFieldDefinition != null ? textFieldDefinition.getDisplayValue(masterTicket) : null, null));
                }
            } else if (ticket.isMasterInBundle()) {
                ArrayList<Integer> availableActions = new ArrayList<Integer>();
                ActionVO unbundleAction = (ActionVO)ActionManager.getInstance().get(-13);
                if (unbundleAction != null && TicketManager.getTicketActionChecker().checkAction(unbundleAction, ticketId) == null) {
                    availableActions.add(unbundleAction.getId());
                }
                List ticketsInBundle = TicketManager.getReader().getTicketsInBundle(ticketId, false);
                for (TicketVOSingle slaveTicket : ticketsInBundle) {
                    links.add(new TicketLink(TicketLink.LinkGroup.bundle, TicketLink.LinkType.bundleslave, slaveTicket.getID(), false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon((TicketVO)slaveTicket) : null, textFieldDefinition != null ? textFieldDefinition.getDisplayValue((TicketVO)slaveTicket) : null, availableActions));
                }
            }
            Set linkedTicketIds = ticket.getLinkedTickets();
            if (!linkedTicketIds.isEmpty()) {
                for (Integer linkedTicketId : linkedTicketIds) {
                    TicketVO linkedTicket;
                    if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(linkedTicketId.intValue()) || (linkedTicket = TicketManager.getReader().getTicket(linkedTicketId.intValue())) == null) continue;
                    ArrayList<Integer> availableActions = new ArrayList<Integer>();
                    ActionVO linkAction = (ActionVO)ActionManager.getInstance().get(-35);
                    if (linkAction != null && TicketManager.getTicketActionChecker().checkAction(linkAction, ticketId) == null) {
                        availableActions.add(linkAction.getId());
                    }
                    boolean bidirectional = TicketManager.getTicketLinking().bidirectionalLinkExistsbetween(ticket.getID(), linkedTicket.getID());
                    links.add(new TicketLink(TicketLink.LinkGroup.free, TicketLink.LinkType.freelink, linkedTicket.getID(), bidirectional, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(linkedTicket) : null, textFieldDefinition != null ? textFieldDefinition.getDisplayValue(linkedTicket) : null, availableActions));
                }
            }
            ItilVO itilVO = (ItilVO)ItilManager.getInstance().get(ticket.getItilID());
            ActionVO requiredAction = (ActionVO)ActionManager.getInstance().get(-15);
            boolean bl = canEdititils = TicketManager.getTicketActionChecker().checkAction(requiredAction, ticketId) == null;
            if (canEdititils) {
                if (itilVO.isMasterType()) {
                    canAddItilSlave = true;
                } else {
                    canAddItilMaster = true;
                }
            }
            ItilLinkManager itilManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
            Set itilSecondarys = itilManager.getItilSlavesLinkedTo(ticketId).stream().filter(t -> TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(t.intValue())).collect(Collectors.toSet());
            itilSecondaryCount = itilSecondarys.size();
            for (Integer slaveId : itilSecondarys.stream().limit(15L).collect(Collectors.toSet())) {
                TicketVO linkedTicket = TicketManager.getReader().getTicket(slaveId.intValue());
                if (linkedTicket == null) continue;
                ArrayList<Integer> availableActions = new ArrayList<Integer>();
                if (requiredAction != null && canEdititils && TicketManager.getTicketActionChecker().checkAction(requiredAction, slaveId.intValue()) == null) {
                    availableActions.add(requiredAction.getId());
                }
                links.add(new TicketLink(TicketLink.LinkGroup.itilslave, TicketLink.LinkType.itilslave, linkedTicket.getID(), false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(linkedTicket) : null, textFieldDefinition != null ? textFieldDefinition.getDisplayValue(linkedTicket) : null, availableActions));
            }
            Integer itilMaster = itilManager.getItilMasterOf(ticketId);
            if (itilMaster != null) {
                TicketVO linkedTicket;
                canAddItilMaster = false;
                if (TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(itilMaster.intValue()) && (linkedTicket = TicketManager.getReader().getTicket(itilMaster.intValue())) != null) {
                    ArrayList<Integer> availableActions = new ArrayList<Integer>();
                    if (requiredAction != null && canEdititils && TicketManager.getTicketActionChecker().checkAction(requiredAction, linkedTicket.getID()) == null) {
                        availableActions.add(requiredAction.getId());
                    }
                    links.add(new TicketLink(TicketLink.LinkGroup.itilmaster, TicketLink.LinkType.itilmaster, linkedTicket.getID(), false, iconFieldDefinition != null ? iconFieldDefinition.getValueAsStringForIcon(linkedTicket) : null, textFieldDefinition != null ? textFieldDefinition.getDisplayValue(linkedTicket) : null, availableActions));
                }
            }
        }
        String itillinks = "";
        IndexSearchEngine searchEngine = TicketManager.getReader().getSearchEngine();
        if (searchEngine.getTag("itilLinks") != null && (tag = searchEngine.getTag("itilLinks")) != null) {
            itillinks = tag.getDisplayName().replace(" ", "-");
        }
        return new GetLinksResponse(links, TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-35), canAddItilMaster, canAddItilSlave, itillinks, itilSecondaryCount);
    }
}

