/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.server.data.ChangeEffortRequest;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketPageUpdateStart;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;

public class ChangeEffort
extends AbstractTicketListHandler<ChangeEffortRequest, Void> {
    public String getMethodName() {
        return "ticketlist.changeeffort";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, ChangeEffortRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        String endDate;
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
        int ticketId = input.getTicketId();
        int stepId = input.getStepId();
        EditDuration duration = input.getDuration();
        if (!isSupporter) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.permissionrequired.supporter", new Object[0]));
        }
        if (!((Boolean)TicketPageUpdateStart.EFFORT_CHANGEABLE.get()).booleanValue()) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.changeeffort.disabled", new Object[0]));
        }
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId)) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{ticketId}));
        }
        List reaStepVOs = TicketManager.getReader().getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
        if (!reaStepVOs.stream().anyMatch(s -> s.getID() == stepId)) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.noaccess.tostep", new Object[0]));
        }
        Integer durationValue = 0;
        Long endDateTimestamp = null;
        String value = duration.getValue();
        if (!StringFunctions.isEmpty((String)value)) {
            try {
                durationValue = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidDuration", new Object[0]));
            }
        }
        if (!StringFunctions.isEmpty((String)(endDate = duration.getEndDate()))) {
            try {
                endDateTimestamp = Long.valueOf(endDate);
            }
            catch (NumberFormatException nfe) {
                throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidEndDate", new Object[0]));
            }
        }
        MutableReaStepData stepData = new MutableReaStepData();
        long end = endDateTimestamp == null ? System.currentTimeMillis() : endDateTimestamp;
        ProcessingTime processingTime = ProcessingTime.ofEffortWithEndTime((int)durationValue, (long)end);
        stepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)processingTime);
        TicketManager.getManipulator().updateReaStepData(stepId, stepData);
        return null;
    }
}

