/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ai.summarize;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.SuggestAIUtils;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ai.api.AITool;
import com.inet.plugin.ai.api.AIToolException;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GetTicketTimelineAITool
implements AITool {
    private static final String KEY_DATE = "date";
    private static final String KEY_USER = "userDisplayName";
    private static final String KEY_TEXT = "text";
    private static final String KEY_ACTION_LABEL = "actionLabel";
    private static final String KEY_STEP_ORDER = "order";
    static final String NAME = "get_ticket_timeline";

    @Nonnull
    public String getName() {
        return NAME;
    }

    @Nonnull
    public String getDescription() {
        return "### Tool Output\nThe tool returns a JSON array of ticket step objects, ordered from oldest to newest.\nEach object contains the following fields:\n- **`date`**: *string* \u2014 The timestamp of the ticket step in ISO 8601 format with time and offset\n- **`userDisplayName`**: *string* \u2014 Display name of the user responsible for this step\n- **`actionLabel`**: *string* \u2014 Describes the action performed in this step\n- **`text`**: *string* \u2014 The textual content of the ticket step (may be empty)\n- **`order`**: *integer* \u2014 The chronological index of the step (starting at 0)\n";
    }

    @Nonnull
    public List<AITool.ParameterDescription> getRequiredParameters() {
        return List.of(new AITool.ParameterDescription("ticketID", "An integer representing the unique ID of the ticket whose history should be retrieved.", AITool.ParameterType.integer));
    }

    @Nonnull
    public List<AITool.ParameterDescription> getOptionalParameters() {
        return new ArrayList<AITool.ParameterDescription>();
    }

    @Nullable
    public Object call(Map<String, Object> map) throws AIToolException {
        Object ticketIDObject = map.get("ticketID");
        Integer ticketID = null;
        if (ticketIDObject instanceof String) {
            try {
                ticketID = Integer.valueOf((String)ticketIDObject);
            }
            catch (NumberFormatException exc) {
                HDLogger.debug((Object)("unknown ticket ID format => " + String.valueOf(ticketIDObject)));
            }
        } else if (ticketIDObject instanceof Integer) {
            ticketID = (Integer)ticketIDObject;
        }
        if (ticketID == null) {
            return null;
        }
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
        List reaSteps = this.getTicketReader().getReaStepsForTicket(ticketID.intValue(), isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
        TicketVO ticket = this.getTicketReader().getTicket(ticketID.intValue());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = reaSteps.size() - 1; i >= 0; --i) {
            ReaStepVO step = (ReaStepVO)reaSteps.get(i);
            Map<String, Object> entry = this.generateEntryForReaStep(ticket, step, reaSteps.size() - 1 - i);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    protected TicketReader getTicketReader() {
        return TicketManager.getReader();
    }

    private Map<String, Object> generateEntryForReaStep(TicketVO ticket, @Nonnull ReaStepVO step, int stepOrder) {
        if (step.getActionID() == -22) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String stepContent = this.getReaStepContent(step.getID());
        String plainText = "";
        if (!StringFunctions.isEmpty((String)stepContent)) {
            plainText = HtmlConverter.html2text((String)stepContent);
        }
        if (plainText == null) {
            plainText = "";
        }
        String actionLabel = step.getActionLabel() != null ? step.getActionLabel() : ((ActionVO)ActionManager.getInstance().get(((Integer)step.getAttribute((ReaStepAttribute)ReaStepVO.ATTRIBUTE_ACTION_ID)).intValue())).getDisplayValue();
        result.put(KEY_ACTION_LABEL, actionLabel);
        result.put(KEY_TEXT, plainText);
        ZoneId zone = ZoneId.systemDefault();
        ZonedDateTime zdt = Instant.ofEpochMilli(step.getStartDate()).atZone(zone);
        result.put(KEY_DATE, DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zdt));
        String userDisplayName = step.getDisplayName();
        result.put(KEY_USER, userDisplayName != null ? userDisplayName : "system:automatic");
        result.put(KEY_STEP_ORDER, stepOrder);
        return result;
    }

    protected String getReaStepContent(int id) {
        return SuggestAIUtils.getReaStepContent(id);
    }
}

