/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepFieldDefinitionEmailUserInfo
extends AdditionalReaStepFieldDefinition<String> {
    public AdditionalReaStepFieldDefinitionEmailUserInfo() {
        super((ReaStepField)ReaStepVO.FIELD_EMAIL_USER_INFO);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        if (!HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return null;
        }
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        String emailUserInfo = (String)step.getValue((ReaStepField)ReaStepVO.FIELD_EMAIL_USER_INFO);
        if (!StringFunctions.isEmpty((String)emailUserInfo)) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("iconclass", "icon-additionalreastepfield-emailuserinfo");
            values.put("title", emailUserInfo);
            GUID userID = step.getUserID();
            if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS) && userID != null) {
                values.put("url", "usersandgroups/user/" + userID.toString());
            }
            list.add(new AdditionalReaStepFieldDescription("externallink", values));
            return list;
        }
        return null;
    }
}

