/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.signing;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.plugins.ticketlist.server.signing.TicketSigning;
import com.inet.helpdesk.plugins.ticketlist.server.signing.TicketSigningValue;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TicketSigningApplyActionRendererExtension
implements ApplyActionRendererExtension {
    @Override
    public int getPriority() {
        return 10000;
    }

    @Override
    public List<String> getUpdateRendererIds(List<String> rendererIds, @Nonnull ActionVO action, TicketVO ticket) {
        if (action.getId() != -214) {
            return rendererIds;
        }
        rendererIds.clear();
        rendererIds.add("ticketsigningimage");
        return rendererIds;
    }

    @Override
    public void prepareReastepActionData(MutableReaStepData stepData, MutableReaStepText stepText, ExtensionArguments extensionArgs, ActionVO action, Map<String, String> values, boolean validationRequired) {
        if (action.getId() == -214) {
            TicketSigningValue value;
            String strValue = values.get("ticketsigningimage");
            if (!StringFunctions.isEmpty((String)strValue) && (value = (TicketSigningValue)new Json().fromJson(strValue, TicketSigningValue.class)) != null) {
                if (validationRequired) {
                    if (StringFunctions.isEmpty((String)value.getSigner())) {
                        throw new ClientMessageException(TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.applyaction.ticketsigningimage.signer.missing", new Object[0]));
                    }
                    if (value.getPath() == null || value.getPath().isEmpty()) {
                        throw new ClientMessageException(TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.applyaction.ticketsigningimage.image.missing", new Object[0]));
                    }
                    if (StringFunctions.isEmpty((String)value.getImage())) {
                        throw new ClientMessageException(TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.applyaction.ticketsigningimage.image.missing", new Object[0]));
                    }
                }
                stepText.setIsHtml(true);
                stepText.setText("<img src=\"" + value.getImage() + "\">");
                stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)value.getSigner());
                extensionArgs.put(TicketSigning.EXTARG_TICKET_SIGNING_IMAGE, (Object)new TicketSigningValue(value.getSigner(), value.getPath()));
                return;
            }
            throw new ClientMessageException(TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.applyaction.ticketsigningimage.image.missing", new Object[0]));
        }
    }

    @Override
    public Map<String, String> getInitialProperties(ActionVO action, TicketVO ticket, Integer stepId, String flag, ReaStepTextVO stepText, ExtensionArguments extensionArguments) {
        if (action.getId() == -214) {
            TicketSigningValue ticketSigningValue;
            if (extensionArguments != null && (ticketSigningValue = (TicketSigningValue)extensionArguments.get(TicketSigning.EXTARG_TICKET_SIGNING_IMAGE)) != null) {
                return Map.of("ticketsigningimage", new Json().toJson((Object)ticketSigningValue));
            }
            String signer = "";
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount != null) {
                signer = currentUserAccount.getDisplayName();
            }
            return Map.of("ticketsigningimage", new Json().toJson((Object)new TicketSigningValue(signer)));
        }
        return Collections.emptyMap();
    }
}

