/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.EmailUserVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.EmailUser;
import com.inet.helpdesk.plugins.ticketlist.api.data.RecipientsCombined;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetStepEmailUsersCombinedRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetStepEmailUsersCombinedResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class GetStepEmailUsersCombined
extends AbstractTicketListHandler<GetStepEmailUsersCombinedRequest, GetStepEmailUsersCombinedResponse> {
    public String getMethodName() {
        return "ticketlist.getstepemailuserscombined";
    }

    @Override
    protected GetStepEmailUsersCombinedResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetStepEmailUsersCombinedRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ArrayList<EmailUser> recipientsTo = new ArrayList<EmailUser>();
        ArrayList<EmailUser> recipientsCC = new ArrayList<EmailUser>();
        ArrayList<EmailUser> recipientsBCC = new ArrayList<EmailUser>();
        TicketReader ticketReader = TicketManager.getReader();
        String flag = input.getFlag();
        int ticketId = input.getTicketId();
        TicketVO ticket = null;
        try {
            ticket = TicketManager.getReader().getTicket(ticketId);
        }
        catch (AccessDeniedException ade) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.novalidticketid", new Object[0]));
        }
        List<Integer> stepIds = input.getStepIds();
        if (stepIds != null) {
            HashSet<Integer> availableStepsIds = new HashSet<Integer>();
            List reaStepVOs = ticketReader.getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            for (ReaStepVO step : reaStepVOs) {
                availableStepsIds.add(step.getID());
            }
            HashSet<String> addedMailAddresses = new HashSet<String>();
            stepIds.removeIf(id -> !availableStepsIds.contains(id));
            stepIds.sort(Comparator.reverseOrder());
            for (Integer stepId : stepIds) {
                ReaStepVO reaStep = ticketReader.getReaStep(stepId.intValue());
                if (reaStep == null) continue;
                ReaStepEmailUsersVO reaStepEmailUsers = ticketReader.getReaStepEmailUsers(stepId.intValue());
                if (flag == null || reaStepEmailUsers == null) continue;
                switch (flag) {
                    case "reply": {
                        EmailUserVO senderVO = reaStepEmailUsers.getSender();
                        if (senderVO == null || addedMailAddresses.contains(senderVO.getEmailAddress())) break;
                        recipientsTo.add(new EmailUser(senderVO.getAccountID(), TicketFunctions.createPublicDisplayName(senderVO.getDisplayName(), senderVO.getEmailAddress()), "", "", senderVO.getEmailAddress()));
                        addedMailAddresses.add(senderVO.getEmailAddress());
                        break;
                    }
                    case "replyall": {
                        EmailUserVO senderVO = reaStepEmailUsers.getSender();
                        if (senderVO != null && !addedMailAddresses.contains(senderVO.getEmailAddress())) {
                            recipientsTo.add(new EmailUser(senderVO.getAccountID(), TicketFunctions.createPublicDisplayName(senderVO.getDisplayName(), senderVO.getEmailAddress()), "", "", senderVO.getEmailAddress()));
                            addedMailAddresses.add(senderVO.getEmailAddress());
                        }
                        recipientsTo.addAll(this.filterAndConverRecipients(reaStepEmailUsers.getTo(), addedMailAddresses));
                        recipientsCC.addAll(this.filterAndConverRecipients(reaStepEmailUsers.getCc(), addedMailAddresses));
                        recipientsBCC.addAll(this.filterAndConverRecipients(reaStepEmailUsers.getBcc(), addedMailAddresses));
                        break;
                    }
                }
            }
        }
        return new GetStepEmailUsersCombinedResponse(new Json().toJson((Object)new RecipientsCombined(ApplyActionRendererProvider.getInstance().getSender(ticket), (Boolean)ApplyActionRendererProvider.SENDER_ALLOW_CUSTOM.get(), recipientsTo, recipientsCC, recipientsBCC)));
    }

    @Nonnull
    private @Nonnull Collection<@Nonnull EmailUser> filterAndConverRecipients(List<EmailUserVO> recipients, HashSet<String> addedMailAddresses) {
        return recipients.stream().filter(t -> !addedMailAddresses.contains(t.getEmailAddress())).map(t -> {
            addedMailAddresses.add(t.getEmailAddress());
            return new EmailUser(t.getAccountID(), TicketFunctions.createPublicDisplayName(t.getDisplayName(), t.getEmailAddress()), "", "", t.getEmailAddress());
        }).collect(Collectors.toList());
    }
}

