/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugins.ticketlist.server.data.FieldDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.NewUserResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GetNewUserInformation
extends AbstractTicketListHandler<Void, NewUserResponseData> {
    public String getMethodName() {
        return "ticketpage.getnewuserfields";
    }

    @Override
    protected NewUserResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ArrayList<FieldDescription> fields = new ArrayList<FieldDescription>();
        ArrayList fieldsToDisplay = new ArrayList();
        if (ServerPluginManager.getInstance().isPluginLoaded("fieldsettings")) {
            UserFieldSettingsManager manager = UserFieldSettingsManager.getInstance();
            manager.getSettings().forEach(setting -> {
                if ("true".equalsIgnoreCase(setting.getSpecificProperty("showFieldForNewUser"))) {
                    UF_Visibility av;
                    String propVisibility = setting.getSpecificProperty("users_visibility");
                    if (!(propVisibility == null || (av = UF_Visibility.valueOf((String)propVisibility)) != null && av.isVisible())) {
                        return;
                    }
                    UserFieldDefinition def = (UserFieldDefinition)manager.getDefinitionForSetting(setting.getKey());
                    if (def != null) {
                        fieldsToDisplay.add(def);
                    }
                }
            });
        } else {
            List<String> predefinedFieldKeys = Arrays.asList(UsersAndGroups.FIELD_FIRSTNAME.getKey(), UsersAndGroups.FIELD_LASTNAME.getKey(), UsersAndGroups.FIELD_EMAIL.getKey(), HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), HDUsersAndGroups.FIELD_CLASS_ID.getKey());
            DynamicExtensionManager.getInstance().get(FieldDefinition.class).forEach(def -> {
                String fieldKey = def.getFieldKey();
                if (fieldKey != null && def.getGroupingType() == Type.user && predefinedFieldKeys.contains(fieldKey)) {
                    fieldsToDisplay.add((UserFieldDefinition)def);
                }
            });
        }
        fieldsToDisplay.sort((d1, d2) -> d1.getPriority() - d2.getPriority());
        for (UserFieldDefinition def2 : fieldsToDisplay) {
            String fieldTypeStr = def2.getDisplayType();
            FieldDescription firstNameDescription = new FieldDescription("user.masterdata", def2.getFieldKey(), def2.getLabel(), def2.getDescription(), fieldTypeStr);
            FieldValue fieldValue = def2.getFieldValue(null);
            fieldValue.setEnabled(true);
            firstNameDescription.setFieldValue(fieldValue);
            fields.add(firstNameDescription);
        }
        boolean createNewLocationsEnabled = true;
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 1 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER})) {
            createNewLocationsEnabled = false;
        }
        return new NewUserResponseData(fields, createNewLocationsEnabled);
    }
}

