/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api.editing;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAutoCC;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.EmailUserVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.api.data.EmailUser;
import com.inet.helpdesk.plugins.ticketlist.api.data.RecipientsCombined;
import com.inet.helpdesk.plugins.ticketlist.api.data.Sender;
import com.inet.helpdesk.plugins.ticketlist.api.editing.AdditionalCloseActions;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.SuggestExecuter;
import com.inet.helpdesk.plugins.ticketlist.server.handler.GetSender;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ApplyActionRendererProvider {
    public static final String ADDITIONAL_CLOSE_FLAG_SUPPRESS_AUTO_MAIL = "suppressAutoMail";
    public static final String ADDITIONAL_CLOSE_FLAG_AUTHORIZE = "authorize";
    public static final String ADDITIONAL_CLOSE_FLAG_AUTHORIZE_AND_DONT_OPEN = "authorizeAndDontOpen";
    public static final String ADDITIONAL_CLOSE_FLAG_AUTHORIZE_AND_SUPPRESS_AUTO_MAIL = "authorizeAndSuppressAutoMail";
    public static final String ADDITIONAL_CLOSE_FLAG_ONLY_CREATE_INQUIRY = "onlyCreateInquiry";
    public static final String ADDITIONAL_CLOSE_FLAG_ONLY_CREATE_INQUIRY_DONT_OPEN = "onlyCreateInquiryAndDontOpen";
    public static final String ADDITIONAL_CLOSE_LEAVE_TICKET = "leaveTicket";
    private static final ConfigValue<Integer> DEFAULT_EMAIL_SEND_CLOSE_TIME = new ConfigValue(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME);
    private static final ConfigValue<Integer> DEFAULT_RESUBMISSION_TIME = new ConfigValue(HDConfigKeys.DEFAULT_RESUBMISSION_TIME);
    public static final ConfigValue<Boolean> DEFAULT_TICKET_PLAINTEXT_REASTEP = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_PLAINTEXT_REASTEP);
    private static final ConfigValue<Boolean> AUTOMAIL_TO_USER_BY_AUTHORIZE = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);
    private static final ConfigValue<Boolean> AUTOMAIL_TO_USER_BY_CLOSE = new ConfigValue(HDConfigKeys.MAIL_BEENDEN_USER);
    public static final ConfigValue<Boolean> SENDER_ALLOW_CUSTOM = new ConfigValue(HDConfigKeys.MAIL_SENDER_ALLOW_CUSTOM);
    public static final Set<Integer> ACTIONS_WITHOUT_CUSTOM_DURATION_ENDDATE = new HashSet<Integer>(){
        {
            this.add(5);
            this.add(8);
            this.add(-7);
            this.add(-3);
            this.add(9);
            this.add(-2);
        }
    };
    public static final Set<Integer> STATUS_WITHOUT_CUSTOM_DURATION_ENDDATE = new HashSet<Integer>(){
        {
            this.add(211);
            this.add(101);
            this.add(260);
            this.add(150);
        }
    };
    public static final ConfigValue<Integer> EFFORTTIME = new ConfigValue<Integer>(HDConfigKeys.CLIENT_EFFORTTIME_CONFIG){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            if (strValue == null) {
                strValue = ServerOptions.isOptionSet((int)0x800000) ? "0" : "1";
            }
            super.setValue(strValue);
        }
    };

    @Nonnull
    public static ApplyActionRendererProvider getInstance() {
        return Singleton.getInstance();
    }

    private ApplyActionRendererProvider() {
    }

    private List<String> getDefaultRendererIds() {
        return new ArrayList<String>(){
            {
                this.add(TicketFieldRendererId.htmleditor.name());
            }
        };
    }

    public List<String> getRendererIds(ActionVO action, TicketVO ticket) {
        List<String> defaultRendererIds = this.getDefaultRendererIds();
        int actionId = action.getId();
        block0 : switch (actionId) {
            case 10: {
                defaultRendererIds.add(0, TicketFieldRendererId.appointment.name());
                break;
            }
            case -3: {
                defaultRendererIds.add(0, TicketFieldRendererId.resubmission.name());
                break;
            }
            case -7: {
                defaultRendererIds.add(0, TicketFieldRendererId.recipients.name());
                defaultRendererIds.add(TicketFieldRendererId.subject.name());
                break;
            }
            case -22: {
                defaultRendererIds.clear();
                defaultRendererIds.add(TicketFieldRendererId.htmleditor.name());
                break;
            }
            default: {
                int statusId = action.getStatusID();
                switch (statusId) {
                    case 260: {
                        defaultRendererIds.add(0, TicketFieldRendererId.appointment.name());
                        break block0;
                    }
                    case 150: {
                        defaultRendererIds.add(0, TicketFieldRendererId.resubmission.name());
                        break block0;
                    }
                    case 211: {
                        defaultRendererIds.add(0, TicketFieldRendererId.recipients.name());
                        defaultRendererIds.add(TicketFieldRendererId.subject.name());
                        break block0;
                    }
                }
            }
        }
        List aares = ServerPluginManager.getInstance().get(ApplyActionRendererExtension.class);
        Collections.sort(aares, (a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
        for (ApplyActionRendererExtension aare : aares) {
            List<String> changedRendererIds = aare.getUpdateRendererIds(defaultRendererIds, action, ticket);
            if (changedRendererIds == null) continue;
            defaultRendererIds = changedRendererIds;
        }
        Collections.sort(defaultRendererIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean attachments2;
                boolean editor2;
                boolean editor1 = TicketFieldRendererId.htmleditor.name().equals(o1);
                if (editor1 != (editor2 = TicketFieldRendererId.htmleditor.name().equals(o2))) {
                    return editor1 ? 1 : -1;
                }
                boolean attachments1 = TicketFieldRendererId.attachments.name().equals(o1);
                if (attachments1 != (attachments2 = TicketFieldRendererId.attachments.name().equals(o2))) {
                    return attachments1 ? 1 : -1;
                }
                return 0;
            }
        });
        return defaultRendererIds;
    }

    public HashMap<String, String> getInitialProperties(@Nullable String clientId, ActionVO action, TicketVO ticket, Integer stepId, String flag, ReaStepTextVO stepText, ExtensionArguments extensionArguments) {
        String textContent;
        HashMap<String, String> initialProperties;
        block65: {
            ArrayList<EmailUser> recipientsBCC;
            ArrayList<EmailUser> recipientsCC;
            ArrayList<EmailUser> recipientsTo;
            block66: {
                block68: {
                    AutoTextManager autoTextManager;
                    TicketReader ticketReader;
                    block67: {
                        Long appointment;
                        initialProperties = new HashMap<String, String>();
                        initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
                        initialProperties.put(TicketFieldRendererId.htmleditor.name(), "");
                        initialProperties.put(TicketFieldRendererId.attachments.name(), "0");
                        Font defaultFont = TicketTextFunctions.getDefaultFont();
                        if (defaultFont != null) {
                            initialProperties.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
                            initialProperties.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
                        }
                        if (stepText != null && !stepText.isEmpty()) {
                            textContent = stepText.getText();
                            textContent = stepText.hasHtmlContent() ? TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)false) : TicketTextFunctions.getLightHtmlFromPlainText((String)textContent);
                            initialProperties.put(TicketFieldRendererId.htmleditor.name(), textContent);
                            initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(stepText.hasHtmlContent()));
                        }
                        if (10 == action.getId() || 260 == action.getStatusID()) {
                            initialProperties.put(TicketFieldRendererId.appointment.name(), String.valueOf(System.currentTimeMillis() + 604800000L));
                            if (extensionArguments != null && (appointment = (Long)extensionArguments.get(ExtensionArguments.EXTARG_APPOINTMENT)) != null) {
                                initialProperties.put(TicketFieldRendererId.appointment.name(), String.valueOf(appointment));
                            }
                        }
                        if (-3 == action.getId() || 150 == action.getStatusID()) {
                            initialProperties.put(TicketFieldRendererId.resubmission.name(), String.valueOf(System.currentTimeMillis() + 86400000L * (long)((Integer)DEFAULT_RESUBMISSION_TIME.get()).intValue()));
                            if (extensionArguments != null && (appointment = (Long)extensionArguments.get(ExtensionArguments.EXTARG_APPOINTMENT)) != null) {
                                initialProperties.put(TicketFieldRendererId.resubmission.name(), String.valueOf(appointment));
                            }
                        }
                        if (-7 != action.getId() && 211 != action.getStatusID()) break block65;
                        ticketReader = TicketManager.getReader();
                        if (ticket != null) {
                            Object subject = ticket.getSubject();
                            if (stepId != null) {
                                ReaStepVO reaStep = ticketReader.getReaStep(stepId.intValue());
                                if (reaStep != null) {
                                    subject = reaStep.getDescription();
                                }
                                subject = "forward".equals(flag) ? "Fwd: " + (String)subject : ("newemailfromstep".equals(flag) ? ticket.getSubject() : "Re: " + (String)subject);
                            }
                            initialProperties.put(TicketFieldRendererId.subject.name(), (String)subject);
                        }
                        autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
                        recipientsTo = new ArrayList<EmailUser>();
                        recipientsCC = new ArrayList<EmailUser>();
                        recipientsBCC = new ArrayList<EmailUser>();
                        if (ticket == null) break block66;
                        if (stepId != null) break block67;
                        if (ServerOptions.isOptionSet((int)524288)) break block68;
                        GUID ownerID = ticket.getOwnerID();
                        if (ownerID != null) {
                            String firstEmailAddress;
                            UserAccount owner = UserManager.getInstance().getUserAccount(ownerID);
                            if (owner != null && !StringFunctions.isEmpty((String)(firstEmailAddress = EmailAddressHelper.get().getFirstEmailAddress((String)owner.getValue((UserField)UsersAndGroups.FIELD_EMAIL))))) {
                                recipientsTo.add(new EmailUser(ownerID, owner.getDisplayName(), "", "", firstEmailAddress));
                            }
                        } else {
                            String emailSenderAddress;
                            ReaStepVO initialStep = ticketReader.getReaStep(ticket.getInitialReaStepID());
                            if (initialStep != null && !StringFunctions.isEmpty((String)(emailSenderAddress = initialStep.getEmailSenderAddress()))) {
                                String displayName = TicketFunctions.createPublicDisplayName(initialStep.getDisplayName(), emailSenderAddress);
                                recipientsTo.add(new EmailUser(null, displayName, "", "", emailSenderAddress));
                            }
                        }
                        String signature = autoTextManager.getAutoUserSignature(Integer.valueOf(ticket.getID()), stepId);
                        if (signature != null) {
                            initialProperties.put(TicketFieldRendererId.htmleditor.name(), TicketFunctions.getAutoTextHtml(signature.getContentText()));
                            initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(true));
                        }
                        break block68;
                    }
                    ReaStepEmailUsersVO reaStepEmailUsers = ticketReader.getReaStepEmailUsers(stepId.intValue());
                    if (flag != null && reaStepEmailUsers != null) {
                        switch (flag) {
                            case "newemailfromstep": {
                                String emailSenderAddress;
                                if (ServerOptions.isOptionSet((int)524288)) break;
                                GUID ownerID = ticket.getOwnerID();
                                if (ownerID != null) {
                                    String firstEmailAddress;
                                    UserAccount owner = UserManager.getInstance().getUserAccount(ownerID);
                                    if (owner == null || StringFunctions.isEmpty((String)(firstEmailAddress = EmailAddressHelper.get().getFirstEmailAddress((String)owner.getValue((UserField)UsersAndGroups.FIELD_EMAIL))))) break;
                                    recipientsTo.add(new EmailUser(ownerID, owner.getDisplayName(), "", "", firstEmailAddress));
                                    break;
                                }
                                ReaStepVO initialStep = ticketReader.getReaStep(ticket.getInitialReaStepID());
                                if (initialStep == null || StringFunctions.isEmpty((String)(emailSenderAddress = initialStep.getEmailSenderAddress()))) break;
                                String displayName = TicketFunctions.createPublicDisplayName(initialStep.getDisplayName(), emailSenderAddress);
                                recipientsTo.add(new EmailUser(null, displayName, "", "", emailSenderAddress));
                                break;
                            }
                            case "reply": 
                            case "replywithai": {
                                EmailUserVO senderVO = reaStepEmailUsers.getSender();
                                if (senderVO == null) break;
                                recipientsTo.add(new EmailUser(senderVO.getAccountID(), TicketFunctions.createPublicDisplayName(senderVO.getDisplayName(), senderVO.getEmailAddress()), "", "", senderVO.getEmailAddress()));
                                break;
                            }
                            case "replyall": 
                            case "replyallwithai": {
                                EmailUserVO senderVO = reaStepEmailUsers.getSender();
                                if (senderVO != null) {
                                    recipientsTo.add(new EmailUser(senderVO.getAccountID(), TicketFunctions.createPublicDisplayName(senderVO.getDisplayName(), senderVO.getEmailAddress()), "", "", senderVO.getEmailAddress()));
                                }
                                recipientsTo.addAll(reaStepEmailUsers.getTo().stream().map(t -> new EmailUser(t.getAccountID(), TicketFunctions.createPublicDisplayName(t.getDisplayName(), t.getEmailAddress()), "", "", t.getEmailAddress())).collect(Collectors.toList()));
                                recipientsCC.addAll(reaStepEmailUsers.getCc().stream().map(c -> new EmailUser(c.getAccountID(), TicketFunctions.createPublicDisplayName(c.getDisplayName(), c.getEmailAddress()), "", "", c.getEmailAddress())).collect(Collectors.toList()));
                                break;
                            }
                            case "forward": {
                                break;
                            }
                            case "resend": {
                                recipientsTo.addAll(reaStepEmailUsers.getTo().stream().map(t -> new EmailUser(t.getAccountID(), TicketFunctions.createPublicDisplayName(t.getDisplayName(), t.getEmailAddress()), "", "", t.getEmailAddress())).collect(Collectors.toList()));
                                recipientsCC.addAll(reaStepEmailUsers.getCc().stream().map(c -> new EmailUser(c.getAccountID(), TicketFunctions.createPublicDisplayName(c.getDisplayName(), c.getEmailAddress()), "", "", c.getEmailAddress())).collect(Collectors.toList()));
                                break;
                            }
                        }
                    }
                    ReaStepTextVO reaStepText = ticketReader.getReaStepText(stepId.intValue());
                    if (flag != null && reaStepText != null) {
                        switch (flag) {
                            case "resend": {
                                String textContent2 = reaStepText.getText();
                                if (!reaStepText.hasHtmlContent()) {
                                    textContent2 = TicketTextFunctions.getLightHtmlFromPlainText((String)textContent2);
                                }
                                initialProperties.put(TicketFieldRendererId.htmleditor.name(), TicketTextFunctions.getInlinedHtml((String)textContent2, (boolean)false));
                                initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(reaStepText.hasHtmlContent()));
                                break;
                            }
                            default: {
                                Object htmlEditor;
                                String fullPlaceholder;
                                String signatureContent = null;
                                boolean reastepPlaceholderAlreadyReplaced = false;
                                AutoTextVO signature = autoTextManager.getAutoUserSignature();
                                if (signature != null && !StringFunctions.isEmpty((String)(signatureContent = signature.getContentText())) && signatureContent.indexOf(fullPlaceholder = "{reastep}") >= 0) {
                                    reastepPlaceholderAlreadyReplaced = true;
                                }
                                Object object = (htmlEditor = "replywithai".equals(flag) || "replyallwithai".equals(flag) ? new SuggestExecuter(ticket.getID(), stepId, clientId).getInstantSuggestion(signatureContent) : autoTextManager.fillPlaceholders(signatureContent, Integer.valueOf(ticket.getID()), stepId)) == null ? "" : (htmlEditor = reaStepText.hasHtmlContent() ? TicketFunctions.getAutoTextHtml((String)htmlEditor) : TicketTextFunctions.convertToPlainText((String)htmlEditor));
                                if (("forward".equals(flag) || "newemailfromstep".equals(flag)) && !reastepPlaceholderAlreadyReplaced) {
                                    ReaStepVO reaStep = TicketManager.getReader().getReaStep(stepId.intValue());
                                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale());
                                    Object stepContent = "";
                                    if (reaStepText.hasHtmlContent()) {
                                        String stepHtmlContent = TicketTextFunctions.getInlinedHtml((String)reaStepText.getText(), (boolean)false);
                                        if (reaStep != null) {
                                            Object userDisplayName = "";
                                            if (!StringFunctions.isEmpty((String)reaStep.getDisplayName())) {
                                                userDisplayName = (String)userDisplayName + reaStep.getDisplayName();
                                            }
                                            if (!StringFunctions.isEmpty((String)reaStep.getEmailSenderAddress())) {
                                                if (((String)userDisplayName).length() > 0) {
                                                    userDisplayName = (String)userDisplayName + " ";
                                                }
                                                userDisplayName = (String)userDisplayName + "&lt;";
                                                userDisplayName = (String)userDisplayName + reaStep.getEmailSenderAddress();
                                                userDisplayName = (String)userDisplayName + "&gt;";
                                            }
                                            stepContent = (String)stepContent + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{dateFormat.format(new Date(reaStep.getStartDate())), userDisplayName});
                                            stepContent = (String)stepContent + "<br>";
                                        }
                                        stepContent = (String)stepContent + "<div style=\"border-top-style:none;border-right-style:none;border-bottom-style:none;border-left-style:solid;border-left-color:blue;border-left-width:1.5pt;padding-top:0cm;padding-right:0cm;padding-bottom:0cm;padding-left:4pt;\">" + stepHtmlContent + "</div>";
                                    } else {
                                        String stepTextContent = reaStepText.getText();
                                        String[] lines = stepTextContent.split("\n");
                                        StringBuilder b2 = new StringBuilder();
                                        for (String line : lines) {
                                            b2.append("> ").append(line).append("\n");
                                        }
                                        stepTextContent = b2.toString();
                                        if (reaStep != null) {
                                            stepContent = (String)stepContent + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{dateFormat.format(new Date(reaStep.getStartDate())), (reaStep.getDisplayName() != null ? reaStep.getDisplayName() : "") + " <" + reaStep.getEmailSenderAddress() + "> "});
                                            stepContent = (String)stepContent + "\n";
                                        }
                                        stepContent = (String)stepContent + stepTextContent;
                                    }
                                    if (htmlEditor != null) {
                                        if (!reaStepText.hasHtmlContent()) {
                                            htmlEditor = TicketTextFunctions.convertToPlainText((String)htmlEditor);
                                            htmlEditor = (String)htmlEditor + "\n\n" + (String)stepContent;
                                        } else {
                                            htmlEditor = (String)htmlEditor + "<br><br>" + (String)stepContent;
                                        }
                                    } else {
                                        htmlEditor = stepContent;
                                    }
                                }
                                if (htmlEditor == null) break;
                                if (!reaStepText.hasHtmlContent()) {
                                    htmlEditor = TicketTextFunctions.getLightHtmlFromPlainText((String)htmlEditor);
                                }
                                initialProperties.put(TicketFieldRendererId.htmleditor.name(), (String)htmlEditor);
                                initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(reaStepText.hasHtmlContent()));
                                break;
                            }
                        }
                    }
                }
                ApplyActionRendererProvider.addRecipientsFromAutoCC(ticket, recipientsCC);
            }
            initialProperties.put(TicketFieldRendererId.recipients.name(), new Json().toJson((Object)new RecipientsCombined(this.getSender(ticket), (Boolean)SENDER_ALLOW_CUSTOM.get(), recipientsTo, recipientsCC, recipientsBCC)));
        }
        if (-22 == action.getId() && (stepText == null || stepText.isEmpty())) {
            TicketReader ticketReader;
            ReaStepTextVO reaStepText;
            textContent = "";
            boolean htmlContent = false;
            if (stepId != null && (reaStepText = (ticketReader = TicketManager.getReader()).getReaStepText(stepId.intValue())) != null) {
                textContent = reaStepText.getText();
                htmlContent = reaStepText.hasHtmlContent();
                textContent = htmlContent ? TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)false) : TicketTextFunctions.getLightHtmlFromPlainText((String)textContent);
            }
            initialProperties.put(TicketFieldRendererId.htmleditor.name(), textContent);
            initialProperties.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(htmlContent));
        }
        List aares = ServerPluginManager.getInstance().get(ApplyActionRendererExtension.class);
        Collections.sort(aares, (a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
        for (ApplyActionRendererExtension aare : aares) {
            Map<String, String> moreInitialProps = aare.getInitialProperties(action, ticket, stepId, flag, stepText, extensionArguments);
            if (moreInitialProps == null) continue;
            initialProperties.putAll(moreInitialProps);
        }
        return initialProperties;
    }

    static void addRecipientsFromAutoCC(@Nonnull TicketVO ticket, ArrayList<EmailUser> recipientsCC) {
        String[] lines;
        String emails = (String)ticket.getValue((TicketField)Tickets.FIELD_AUTO_CC);
        if (emails == null) {
            emails = "";
        }
        emails = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat((String)emails);
        for (String line : lines = emails.split("\n")) {
            String add;
            String email = line.replaceAll("[^<]*<([^>@]+@[^>]+)>.*", "$1");
            String displayName = line.replaceAll("\"?([^<\"]*)\"?\\s*<[^>@]+@[^>]+>.*", "$1").trim();
            if (displayName.isEmpty()) {
                displayName = email;
            }
            if ((add = EmailAddressHelper.get().getFirstEmailAddress(email)) == null) continue;
            recipientsCC.add(new EmailUser(null, displayName, "", "", add));
        }
    }

    public void prepareReastepActionData(MutableReaStepData stepData, MutableReaStepText stepText, ExtensionArguments extensionArgs, ActionVO action, Map<String, String> values, HttpServletRequest request, EditDuration duration, List<AttachmentDescription> attachments) throws IOException, ServletException {
        this.prepareReastepActionData(stepData, stepText, extensionArgs, action, values, request, duration, attachments, true);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareReastepActionData(MutableReaStepData stepData, MutableReaStepText stepText, ExtensionArguments extensionArgs, ActionVO action, Map<String, String> values, HttpServletRequest request, EditDuration duration, List<AttachmentDescription> attachments, boolean validationRequired) throws IOException, ServletException {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            switch (entry.getKey()) {
                case "recipients": 
                case "subject": {
                    if (extensionArgs.containsExtArg(ExtensionArguments.EXTARG_APPLY_ANSWER)) break;
                    Sender sender = null;
                    ArrayList<EmailUser> receiversTo = null;
                    ArrayList<EmailUser> receiversCC = null;
                    ArrayList<EmailUser> receiversBCC = null;
                    String recipients = values.get(TicketFieldRendererId.recipients.name());
                    if (!StringFunctions.isEmpty((String)recipients)) {
                        RecipientsCombined recipientsCombined = (RecipientsCombined)new Json().fromJson(recipients, RecipientsCombined.class);
                        sender = recipientsCombined.getSender();
                        receiversTo = recipientsCombined.getRecipients();
                        receiversCC = recipientsCombined.getCC();
                        receiversBCC = recipientsCombined.getBCC();
                    }
                    String subject = values.get(TicketFieldRendererId.subject.name());
                    if (sender == null) {
                        sender = new Sender("", "", "", null);
                    }
                    if (subject == null) {
                        subject = "";
                    }
                    String receiversToStr = receiversTo == null ? "" : receiversTo.stream().map(EmailUser::getEmail).collect(Collectors.joining(";"));
                    String receiversCCStr = receiversCC == null ? "" : receiversCC.stream().map(EmailUser::getEmail).collect(Collectors.joining(";"));
                    String receiversBCCStr = receiversBCC == null ? "" : receiversBCC.stream().map(EmailUser::getEmail).collect(Collectors.joining(";"));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_IN, (Object)(sender.getEmail() == null ? "" : sender.getEmail()));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_AN, (Object)(receiversToStr == null ? "" : receiversToStr));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_CC, (Object)(receiversCCStr == null ? "" : receiversCCStr));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_BCC, (Object)(receiversBCCStr == null ? "" : receiversBCCStr));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)subject);
                    extensionArgs.put(ExtensionArguments.EXTARG_APPLY_ANSWER, (Object)ExtensionArguments.AdditionalEmailAction.SEND_ONLY);
                    break;
                }
                case "appointment": {
                    Long appointment = Long.valueOf(values.get(TicketFieldRendererId.appointment.name()));
                    extensionArgs.put(ExtensionArguments.EXTARG_APPOINTMENT, (Object)appointment);
                    break;
                }
                case "resubmission": {
                    Long resubmission = Long.valueOf(values.get(TicketFieldRendererId.resubmission.name()));
                    extensionArgs.put(ExtensionArguments.EXTARG_APPOINTMENT, (Object)resubmission);
                    break;
                }
                case "attachments": {
                    if (attachments == null || attachments.isEmpty()) break;
                    ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>();
                    for (int i = 0; i < attachments.size(); ++i) {
                        AttachmentDescription attachment = attachments.get(i);
                        final Part part = request.getPart("attachment" + i);
                        if (attachment == null || part == null) continue;
                        LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                            public InputStream getStream() {
                                try {
                                    return part.getInputStream();
                                }
                                catch (Exception e) {
                                    HDLogger.error((Object)e);
                                    return null;
                                }
                            }

                            public long getSize() {
                                return part.getSize();
                            }
                        });
                        lc.setContentType(AttachmentType.valueOf((String)attachment.getAttachmentType().name()));
                        lc.setLastModified(attachment.getLastModified());
                        lc.setName(attachment.getName());
                        attachmentsWithData.add(lc);
                    }
                    extensionArgs.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithData));
                }
            }
        }
        List aares = ServerPluginManager.getInstance().get(ApplyActionRendererExtension.class);
        Collections.sort(aares, (a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
        for (ApplyActionRendererExtension aare : aares) {
            aare.prepareReastepActionData(stepData, stepText, extensionArgs, action, values, validationRequired);
        }
        if (duration != null) {
            void var11_15;
            String endDate;
            Object var11_13 = null;
            Long endDateTimestamp = null;
            String value = duration.getValue();
            if (!StringFunctions.isEmpty((String)value)) {
                try {
                    Integer n = Integer.valueOf(value);
                }
                catch (NumberFormatException nfe) {
                    throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidDuration", new Object[0]));
                }
            }
            if (!StringFunctions.isEmpty((String)(endDate = duration.getEndDate()))) {
                try {
                    endDateTimestamp = Long.valueOf(endDate);
                }
                catch (NumberFormatException nfe) {
                    throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidEndDate", new Object[0]));
                }
            }
            if (var11_15 != null) {
                long end = endDateTimestamp == null ? System.currentTimeMillis() : endDateTimestamp;
                ProcessingTime processingTime = ProcessingTime.ofEffortWithEndTime((int)var11_15.intValue(), (long)end);
                stepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)processingTime);
            }
        }
    }

    public Sender getSender(TicketVO ticket) {
        if (ticket == null) {
            return null;
        }
        try {
            List senders = TicketManager.getReader().getSenderInformationForTicket(ticket.getID());
            if (senders.size() > 0) {
                TicketEmailSenderInformation senderInformation = (TicketEmailSenderInformation)senders.get(0);
                String iconValue = null;
                Sender.IconType iconType = null;
                switch (senderInformation.getSenderType()) {
                    case owner: {
                        iconValue = senderInformation.getIdObject();
                        iconType = Sender.IconType.ownerid;
                        break;
                    }
                    case resource: {
                        int resID = Integer.parseInt(senderInformation.getIdObject());
                        iconValue = HDUsersAndGroups.getResourceIconKey((UserGroupInfo)HDUsersAndGroups.getResource((int)resID));
                        iconType = Sender.IconType.resourceid;
                        break;
                    }
                    default: {
                        iconValue = "211";
                        iconType = Sender.IconType.statusid;
                    }
                }
                return new Sender(senderInformation.getDisplayName(), senderInformation.getEmail(), iconValue, iconType);
            }
        }
        catch (ServerDataException e) {
            HDLogger.error((Object)((Object)e));
        }
        ArrayList<Sender> senderEntries = new GetSender().getSenderEntries(UserManager.getInstance().getCurrentUserAccount(), ticket, null);
        if (!senderEntries.isEmpty()) {
            return senderEntries.get(0);
        }
        return null;
    }

    public List<AdditionalCloseActions> getAdditionalCloseActions(ActionVO action, TicketVO ticket, boolean isInTicketDetailsPage) {
        UserAccount currentUserAccount;
        ArrayList<AdditionalCloseActions> additionalCloseActions = new ArrayList<AdditionalCloseActions>();
        if (action == null) {
            return additionalCloseActions;
        }
        if ((action.getId() == -7 || 211 == action.getStatusID()) && ticket != null && !ticket.isSlaveInBundle() && TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(2)) {
            additionalCloseActions.add(new AdditionalCloseActions(ExtensionArguments.AdditionalEmailAction.SEND_AND_CLOSE.name(), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.email.closeafterwards.immediately", new Object[0])));
            additionalCloseActions.add(new AdditionalCloseActions(ExtensionArguments.AdditionalEmailAction.SEND_AND_CLOSE_AFTER_X_DAYS.name(), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.email.closeafterwards.delayed", new Object[]{DEFAULT_EMAIL_SEND_CLOSE_TIME.get()})));
        }
        if (action.getId() == 8 && ticket != null && isInTicketDetailsPage) {
            additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_LEAVE_TICKET, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.forward.leaveticket", new Object[0])));
        }
        if ((currentUserAccount = UserManager.getInstance().getCurrentUserAccount()) != null) {
            int statusID;
            if (action.getId() == 5) {
                boolean canAuthorize = TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(5);
                if (HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
                    if (ticket == null) {
                        if (canAuthorize) {
                            additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_AUTHORIZE, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.authorize", new Object[0])));
                            if (((Boolean)AUTOMAIL_TO_USER_BY_AUTHORIZE.get()).booleanValue()) {
                                additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_AUTHORIZE_AND_SUPPRESS_AUTO_MAIL, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.authorizeandsuppressautomail", new Object[0])));
                            }
                            additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_AUTHORIZE_AND_DONT_OPEN, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.authorizeanddontopen", new Object[0])));
                        }
                        additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_ONLY_CREATE_INQUIRY_DONT_OPEN, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.dontopen", new Object[0])));
                    } else if (!ticket.isDispatched()) {
                        if (canAuthorize) {
                            if (isInTicketDetailsPage) {
                                additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_LEAVE_TICKET, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.forward.leaveticket", new Object[0])));
                            }
                            if (((Boolean)AUTOMAIL_TO_USER_BY_AUTHORIZE.get()).booleanValue()) {
                                additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_AUTHORIZE_AND_SUPPRESS_AUTO_MAIL, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.suppressautomail", new Object[0])));
                            }
                        }
                    } else if (isInTicketDetailsPage) {
                        additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_LEAVE_TICKET, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.forward.leaveticket", new Object[0])));
                    }
                }
            }
            if (Status.isClosedStatus((int)(statusID = action.getStatusID())) && ((Boolean)AUTOMAIL_TO_USER_BY_CLOSE.get()).booleanValue() && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
                additionalCloseActions.add(new AdditionalCloseActions(ADDITIONAL_CLOSE_FLAG_SUPPRESS_AUTO_MAIL, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.applyaction.suppressautomail", new Object[0])));
            }
        }
        return additionalCloseActions;
    }

    static class Singleton {
        private static ApplyActionRendererProvider INSTANCE;

        Singleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        public static ApplyActionRendererProvider getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<ApplyActionRendererProvider> clazz = ApplyActionRendererProvider.class;
            synchronized (ApplyActionRendererProvider.class) {
                if (INSTANCE != null) return INSTANCE;
                INSTANCE = new ApplyActionRendererProvider();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }
    }
}

