/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketlistlayout;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketListLayout;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnSetting;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSpecificSettingsModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class CardTicketListLayout
implements TicketListLayout {
    @Override
    public String getKey() {
        return "card";
    }

    @Override
    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.layout.card", new Object[0]);
    }

    @Override
    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.layout.card.description", new Object[0]);
    }

    @Override
    public int getTicketListBlockSize() {
        return 15;
    }

    @Override
    @Nonnull
    public List<TicketListColumnDescription> getFixedColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        ArrayList<TicketListColumnSetting> fixedColumnSettings;
        TicketListColumnDescription previewColumn = new TicketListColumnDescription(TicketFieldDefinition.FIELD_GROUPING.TICKET.name(), TicketFieldDefinition.FIELD_GROUPING.TICKET.getDisplayName(), "preview", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.column.preview", new Object[0]), null, ColumnDisplayType.text, null, true, false);
        HashSet<String> mandatoryKeys = new HashSet<String>();
        mandatoryKeys.add(Tickets.FIELD_SUBJECT.getKey());
        mandatoryKeys.add("preview");
        mandatoryKeys.add("ticketid");
        ArrayList<TicketListColumnDescription> fixedColumns = new ArrayList<TicketListColumnDescription>();
        ArrayList<TicketListColumnSetting> arrayList = fixedColumnSettings = userSpecificSettings != null ? userSpecificSettings.getFixedColumSettings() : null;
        if (fixedColumnSettings != null) {
            for (TicketListColumnSetting columnSetting : fixedColumnSettings) {
                TicketListColumnDescription colDescr = allAvailableColumns.get(columnSetting.getColumnKey());
                if (colDescr == null && previewColumn.getKey().equals(columnSetting.getColumnKey())) {
                    colDescr = previewColumn;
                }
                if (colDescr == null) continue;
                fixedColumns.add(colDescr.clone(columnSetting.getDisplayType(), columnSetting.getWidth()));
            }
        } else {
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get(Tickets.FIELD_PRIORITY_ID.getKey()), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_STATUS_ID.getKey()), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get(Tickets.FIELD_SUBJECT.getKey()), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get("ticketid"), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_LAST_CHANGED.getKey()), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID.getKey()), ColumnDisplayType.visible);
            this.cloneAndAddDescription(fixedColumns, previewColumn, ColumnDisplayType.visible);
        }
        fixedColumns.forEach(c -> {
            if (mandatoryKeys.contains(c.getKey())) {
                c.setMandatory(true);
            }
        });
        return fixedColumns;
    }

    @Override
    @Nonnull
    public List<TicketListColumnDescription> getAdditionalColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        ArrayList<TicketListColumnSetting> additionalColumnSettings;
        ArrayList<TicketListColumnDescription> additionalColumns = new ArrayList<TicketListColumnDescription>();
        ArrayList<TicketListColumnSetting> arrayList = additionalColumnSettings = userSpecificSettings != null ? userSpecificSettings.getAdditionalColumSettings() : null;
        if (additionalColumnSettings != null) {
            for (TicketListColumnSetting columnSetting : additionalColumnSettings) {
                TicketListColumnDescription colDesrc = allAvailableColumns.get(columnSetting.getColumnKey());
                if (colDesrc == null) continue;
                additionalColumns.add(colDesrc.clone(columnSetting.getDisplayType(), columnSetting.getWidth()));
            }
        } else {
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_RESOURCE_GUID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_CATEGORY_ID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey()));
        }
        return additionalColumns;
    }

    @Override
    public int getMaximumAdditionalColumnCount() {
        return 6;
    }

    @Override
    public URL getLayoutTemplate() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketlistlayout/cardlayout.html");
    }

    @Override
    public URL getPreviewTemplate() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketlistlayout/cardpreview.html");
    }
}

