/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketValue;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPropertiesRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPropertiesResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TicketProperties
extends AbstractTicketListHandler<TicketPropertiesRequest, TicketPropertiesResponse> {
    public String getMethodName() {
        return "ticketlist.ticketproperties";
    }

    @Override
    protected TicketPropertiesResponse handleRequest(HttpServletRequest request, HttpServletResponse response, TicketPropertiesRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        List<Integer> ticketIds = input.getTicketIds();
        List<TicketListColumnDescription> columns = Collections.emptyList();
        ArrayList<Map<String, TicketValue>> ticketDetailsList = new ArrayList<Map<String, TicketValue>>();
        if (ticketIds != null && !ticketIds.isEmpty()) {
            columns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
            for (Integer ticketId : ticketIds) {
                TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                if (ticket == null) continue;
                HashMap<String, TicketValue> ticketDetails = new HashMap<String, TicketValue>();
                List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
                    String hyperlink;
                    String displayValue = fieldDefinition.getDisplayValue(ticket);
                    String valueAsString = fieldDefinition.supportsIcon() ? fieldDefinition.getValueAsStringForIcon(ticket) : null;
                    String string = hyperlink = fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField() ? ((TicketFieldDefinitionWithHyperlink)fieldDefinition).getHyperlink(ticket) : null;
                    if (StringFunctions.isEmpty((String)displayValue) && StringFunctions.isEmpty((String)valueAsString) && StringFunctions.isEmpty((String)hyperlink)) continue;
                    ticketDetails.put(fieldDefinition.getKey(), new TicketValue(valueAsString, displayValue, fieldDefinition.getDescription(ticket), hyperlink));
                }
                ticketDetailsList.add(ticketDetails);
            }
        }
        return new TicketPropertiesResponse(ticketDetailsList, columns);
    }
}

