/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.LoadSuggestionsRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.LoadSuggestionsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.shared.model.SuggestedEntry;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class LoadSuggestions
extends AbstractTicketListHandler<LoadSuggestionsRequest, LoadSuggestionsResponse> {
    private static final int ADVISE_MAX_SUGGESTED_VALUES = 50;

    public String getMethodName() {
        return "ticketlist.loadsuggestions";
    }

    @Override
    protected LoadSuggestionsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, final LoadSuggestionsRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        int idx;
        final IndexSearchEngine searchEngine = TicketManager.getReader().getSearchEngine();
        final boolean isSupporter = HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        SuggestedValuesFilter<Integer> filter = new SuggestedValuesFilter<Integer>(){

            public Collection<SearchTag> getSearchTags() {
                HashSet<SearchTag> tags = new HashSet<SearchTag>(searchEngine.getTags());
                tags.removeIf(tag -> !tag.isSuggestedTag());
                return tags;
            }

            public Collection<TokenMatcher<Integer>> getTokenMatchers() {
                if (isSupporter) {
                    return null;
                }
                return Collections.emptySet();
            }

            @Nonnull
            public Predicate<Integer> getCondition() {
                return TicketViewManager.getInstance().getTicketCondition(input.getClientID(), input.isViewEditor());
            }

            public int getMaxValues() {
                return Math.max(input.getPageCount() * 50, searchEngine.getTags().size()) * 2;
            }
        };
        List suggestedValues = searchEngine.getSuggestedValues(input.getPhrase(), (SuggestedValuesFilter)filter);
        ArrayList<SuggestedEntry> values = new ArrayList<SuggestedEntry>();
        for (SuggestedValue value : suggestedValues) {
            values.add(new SuggestedEntry(value));
        }
        boolean hasMore = false;
        values.sort((t1, t2) -> String.CASE_INSENSITIVE_ORDER.compare(t1.getKey(), t2.getKey()));
        while (values.size() > 50 * input.getPageCount() && ((SuggestedEntry)values.get(idx = values.size() - 1)).getKey().startsWith("value:")) {
            values.remove(idx);
            hasMore = true;
        }
        int pageCount = (int)Math.ceil((double)values.size() / 50.0);
        return new LoadSuggestionsResponse(values, hasMore, pageCount);
    }
}

