/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ai;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.api.AIProviderManager;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketListAIStructureProvider
extends AbstractStructureProvider {
    private static final ConfigValue<String> AI_PROVIDERS = new ConfigValue(AIProviderManager.AI_PROVIDERS);
    public static final Logger LOGGER = LogManager.getLogger((String)"AI");
    @Nonnull
    public static final ConfigKey AI_TICKETLIST_USEDEFAULTPROVIDER = new ConfigKey("ai.ticketlist.usedefaultprovider", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey AI_TICKETLIST_MANUALPROVIDER = new ConfigKey("ai.ticketlist.manualprovider", "", String.class);
    @Nonnull
    public static final ConfigKey AI_SUGGEST_USEDEFAULTPROVIDER = new ConfigKey("ai.ticketlist.suggest.usedefaultprovider", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey AI_SUGGEST_MANUALPROVIDER = new ConfigKey("ai.ticketlist.suggest.manualprovider", "", String.class);
    @Nonnull
    public static final ConfigKey AI_SUMMARIZE_USEDEFAULTPROVIDER = new ConfigKey("ai.ticketlist.summarize.usedefaultprovider", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey AI_SUMMARIZE_MANUALPROVIDER = new ConfigKey("ai.ticketlist.summarize.manualprovider", "", String.class);
    @Nonnull
    public static final ConfigKey AI_SUGGEST_SOURCE = new ConfigKey("ai.suggest.source", "ticketlist", String.class);
    @Nonnull
    public static final ConfigKey AI_SUGGEST_CONTEXT_SIZE = new ConfigKey("ai.suggest.context.size", "10", Integer.class);
    @Nonnull
    public static final ConfigKey AI_SUGGEST_EXTRA_INSTRUCTIONS = new ConfigKey("ai.suggest.extra.instructions", "", String.class);
    @Nonnull
    public static final ConfigKey AI_SUMMARIZE_EXTRA_INSTRUCTIONS = new ConfigKey("ai.summarize.extra.instructions", "", String.class);
    public static final String CATEGORY_AI_TICKETLIST = "category.ai.ticketlist";
    public static final String CATEGORY_GROUP_AI = "categorygroup.ai";
    public static final boolean KB_PLUGIN_ENABLED = ServerPluginManager.getInstance().isPluginLoaded("knowledgebase");
    private static final String PROP_GROUP_SUGGEST = "group.ai.ticketlist.suggest";
    private static final String PROP_GROUP_SUMMARIZE = "group.ai.ticketlist.summarize";
    private static final String PROP_GROUP_REWRITE = "group.ai.ticketlist.rewrite";

    public TicketListAIStructureProvider() {
        super("com.inet.helpdesk.plugins.ticketlist.server.ai.i18n.AI");
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (CATEGORY_GROUP_AI.equals(groupKey)) {
            categories.add(new ConfigCategory(600, CATEGORY_AI_TICKETLIST, this.translate(settings, CATEGORY_AI_TICKETLIST, new Object[0]), "ai-integration.ticketlist"));
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        if (CATEGORY_AI_TICKETLIST.equals(categoryKey)) {
            return ((Object)((Object)this)).getClass().getResource("ai_ticketlist_neu_48.svg");
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (CATEGORY_AI_TICKETLIST.equals(categoryKey)) {
            propertyGroups.add(new ConfigPropertyGroup(110, PROP_GROUP_SUGGEST, this.translate(settings, PROP_GROUP_SUGGEST, new Object[0])));
            propertyGroups.add(new ConfigPropertyGroup(120, PROP_GROUP_SUMMARIZE, this.translate(settings, PROP_GROUP_SUMMARIZE, new Object[0])));
            propertyGroups.add(new ConfigPropertyGroup(140, PROP_GROUP_REWRITE, this.translate(settings, PROP_GROUP_REWRITE, new Object[0])));
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> properties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.ai.ticketlist.suggest": {
                this.addProviderSettingsTo(properties, settings, AI_SUGGEST_USEDEFAULTPROVIDER, AI_SUGGEST_MANUALPROVIDER);
                if (KB_PLUGIN_ENABLED) {
                    ArrayList<LocalizedKey> options = new ArrayList<LocalizedKey>();
                    for (String key : List.of("ticketlist", "knowledgebase", "both")) {
                        options.add(new LocalizedKey(key, this.translate(settings, key, new Object[0])));
                    }
                    this.addSelectTo(properties, AI_SUGGEST_SOURCE, settings, options);
                }
                this.addTo(properties, AI_SUGGEST_CONTEXT_SIZE, settings);
                this.addTo(properties, AI_SUGGEST_EXTRA_INSTRUCTIONS, "MultiLineText", settings);
                break;
            }
            case "group.ai.ticketlist.summarize": {
                this.addProviderSettingsTo(properties, settings, AI_SUMMARIZE_USEDEFAULTPROVIDER, AI_SUMMARIZE_MANUALPROVIDER);
                this.addTo(properties, AI_SUMMARIZE_EXTRA_INSTRUCTIONS, "MultiLineText", settings);
                break;
            }
            case "group.ai.ticketlist.rewrite": {
                this.addProviderSettingsTo(properties, settings, HDConfigKeys.AI_REWRITE_USEDEFAULTPROVIDER, HDConfigKeys.AI_REWRITE_MANUALPROVIDER);
                this.addTo(properties, HDConfigKeys.AI_REWRITE_EXTRA_INSTRUCTIONS, "MultiLineText", settings);
            }
        }
    }

    private void addProviderSettingsTo(@Nonnull Set<ConfigProperty> properties, @Nonnull ConfigStructureSettings settings, @Nonnull ConfigKey useDefaultKey, @Nonnull ConfigKey manualProviderKey) {
        ArrayList configuredProviders;
        this.addBooleanTo(properties, useDefaultKey, settings);
        ArrayList providerOptions = new ArrayList();
        try {
            String json = (String)AI_PROVIDERS.get();
            configuredProviders = (ArrayList)new Json().fromJson(json, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
        }
        catch (Exception e) {
            configuredProviders = new ArrayList();
        }
        configuredProviders.forEach(props -> {
            String displayName = (String)props.get("displayname");
            if (displayName != null && !displayName.isBlank()) {
                providerOptions.add(new LocalizedKey(displayName, displayName));
            }
        });
        this.addSelectTo(properties, manualProviderKey, settings, providerOptions);
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (CATEGORY_AI_TICKETLIST.equals(categoryKey)) {
            ConfigCondition suggestCondition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{AI_SUGGEST_USEDEFAULTPROVIDER.getKey(), "false"});
            actions.add(new ConfigConditionAction(ConfigConditionAction.Action.Visible, AI_SUGGEST_MANUALPROVIDER.getKey(), suggestCondition));
            ConfigCondition summarizeCondition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{AI_SUMMARIZE_USEDEFAULTPROVIDER.getKey(), "false"});
            actions.add(new ConfigConditionAction(ConfigConditionAction.Action.Visible, AI_SUMMARIZE_MANUALPROVIDER.getKey(), summarizeCondition));
            ConfigCondition rewriteCondition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{HDConfigKeys.AI_REWRITE_USEDEFAULTPROVIDER.getKey(), "false"});
            actions.add(new ConfigConditionAction(ConfigConditionAction.Action.Visible, HDConfigKeys.AI_REWRITE_MANUALPROVIDER.getKey(), rewriteCondition));
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        return ConfigStructure.SaveState.NONE;
    }
}

