/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server;

import com.inet.classloader.translations.TranslationKey;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class TicketFieldDefinitionPreviewText
extends TicketFieldDefinition {
    public TicketFieldDefinitionPreviewText(int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, "preview", true, false, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    public String getDisplayValue(@Nonnull TicketVO ticket) {
        return TicketFunctions.getPlainAndShortenedPreviewText(ticket.getID());
    }

    public String getLabel() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.column.preview", new Object[0]);
    }

    public TranslationKey getLabelTranslationKey() {
        return new TranslationKey("ticketlist", TicketListServerPlugin.SERVER_MSG.getBundle().getBaseBundleName(), "omg", "ticketlist.column.preview");
    }

    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsgAllowMissing("ticketlist.column.preview.description", new Object[0]);
    }

    @Nonnull
    public Comparator<TicketVO> getComparator() {
        @Nonnull Comparator<T> nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

