/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketPageLayout;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.CacheKey;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageExtensionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutSettingsModel;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutSpecificSettingsModel;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class TicketPageLayoutManager {
    public static final String DEFAULT_LAYOUT = "fullview";
    private static final MemoryStoreMap<CacheKey, TicketPageLayoutDescription> layoutCache = new MemoryStoreMap(1800, true);

    @Nonnull
    public static TicketPageLayoutManager getInstance() {
        return Singleton.getInstance();
    }

    private TicketPageLayoutManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketPageLayoutDescription getCurrentLayout(GUID userID) {
        CacheKey key = CacheKey.of(userID);
        MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            TicketPageLayoutDescription ticketPageLayoutDescription = (TicketPageLayoutDescription)layoutCache.get((Object)key);
            if (ticketPageLayoutDescription != null) {
                return ticketPageLayoutDescription;
            }
        }
        TicketPageLayoutSettingsModel layoutSettings = new TicketPageLayoutSettingsModel();
        String layoutSettingsSerialized = (String)UserManager.getInstance().getUserAccount(userID).getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGELAYOUTSETTINGS);
        String layoutSettingsSerializedDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGELAYOUTSETTINGS);
        if (!StringFunctions.isEmpty((String)layoutSettingsSerializedDefault)) {
            layoutSettings.merge((TicketPageLayoutSettingsModel)new Json().fromJson(layoutSettingsSerializedDefault, TicketPageLayoutSettingsModel.class, new HashMap()));
        }
        if (!StringFunctions.isEmpty((String)layoutSettingsSerialized)) {
            layoutSettings.merge((TicketPageLayoutSettingsModel)new Json().fromJson(layoutSettingsSerialized, TicketPageLayoutSettingsModel.class, new HashMap()));
        }
        String selectedLayout = null;
        HashMap<String, TicketPageLayoutSpecificSettingsModel> layoutSettingsMap = null;
        selectedLayout = layoutSettings.getSelectedLayout();
        layoutSettingsMap = layoutSettings.getLayoutSettings();
        if (layoutSettingsMap == null) {
            layoutSettingsMap = new HashMap();
        }
        List ticketPageLayouts = ServerPluginManager.getInstance().get(TicketPageLayout.class);
        if (selectedLayout != null) {
            for (TicketPageLayout layout : ticketPageLayouts) {
                if (!layout.getKey().equals(selectedLayout)) continue;
                TicketPageLayoutDescription fromTicketPageLayout = TicketPageLayoutDescription.fromTicketPageLayout(layout, layoutSettingsMap.get(layout.getKey()));
                MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap2 = layoutCache;
                synchronized (memoryStoreMap2) {
                    layoutCache.put((Object)key, (Object)fromTicketPageLayout);
                }
                return fromTicketPageLayout;
            }
        }
        for (TicketPageLayout layout : ticketPageLayouts) {
            if (!layout.getKey().equals(DEFAULT_LAYOUT)) continue;
            TicketPageLayoutDescription fromTicketPageLayout = TicketPageLayoutDescription.fromTicketPageLayout(layout, layoutSettingsMap.get(layout.getKey()));
            MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap3 = layoutCache;
            synchronized (memoryStoreMap3) {
                layoutCache.put((Object)key, (Object)fromTicketPageLayout);
            }
            return fromTicketPageLayout;
        }
        return null;
    }

    public List<TicketPageLayoutDescription> getLayouts(UserAccount user) {
        TicketPageLayoutSettingsModel layoutSettings = null;
        String layoutSettingsSerialized = null;
        if (user != null) {
            layoutSettingsSerialized = (String)user.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGELAYOUTSETTINGS);
        }
        if (!StringFunctions.isEmpty(layoutSettingsSerialized)) {
            layoutSettings = (TicketPageLayoutSettingsModel)new Json().fromJson(layoutSettingsSerialized, TicketPageLayoutSettingsModel.class, new HashMap());
        }
        HashMap<String, TicketPageLayoutSpecificSettingsModel> layoutSettingsMap = null;
        if (layoutSettings != null) {
            layoutSettingsMap = layoutSettings.getLayoutSettings();
        }
        if (layoutSettingsMap == null) {
            layoutSettingsMap = new HashMap();
        }
        List ticketPageLayouts = ServerPluginManager.getInstance().get(TicketPageLayout.class);
        ArrayList<TicketPageLayoutDescription> userLayouts = new ArrayList<TicketPageLayoutDescription>();
        for (TicketPageLayout layout : ticketPageLayouts) {
            userLayouts.add(TicketPageLayoutDescription.fromTicketPageLayout(layout, layoutSettingsMap.get(layout.getKey())));
        }
        Collections.sort(userLayouts, new Comparator<TicketPageLayoutDescription>(){

            @Override
            public int compare(TicketPageLayoutDescription o1, TicketPageLayoutDescription o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getLayoutKey(), o2.getLayoutKey());
            }
        });
        return userLayouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayoutsForUser(UserAccount currentUser, String selectedLayout, Collection<TicketPageLayoutDescription> layouts) {
        TicketPageLayoutSettingsModel settingsModel = new TicketPageLayoutSettingsModel();
        settingsModel.setSelectedLayout(selectedLayout);
        HashMap<String, TicketPageLayoutSpecificSettingsModel> layoutSettings = new HashMap<String, TicketPageLayoutSpecificSettingsModel>();
        for (TicketPageLayoutDescription descr : layouts) {
            TicketPageLayoutSpecificSettingsModel model = new TicketPageLayoutSpecificSettingsModel();
            model.setHeaderIconColumKey(descr.getHeaderIconColumKey());
            model.setHeaderTextColumKey(descr.getHeaderTextColumKey());
            ArrayList<TicketPageExtensionDescription> extensions = descr.getExtensions();
            if (extensions != null) {
                List<String> extensionKeys = extensions.stream().map(TicketPageExtensionDescription::getId).collect(Collectors.toList());
                model.setExtensions(extensionKeys);
            }
            model.setHiddenExtensions(descr.getHiddenExtensions());
            layoutSettings.put(descr.getLayoutKey(), model);
        }
        settingsModel.setLayoutSettings(layoutSettings);
        MutableUserData userData = new MutableUserData();
        userData.put(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGELAYOUTSETTINGS, (Object)new Json().toJson((Object)settingsModel));
        UserManager.getInstance().updateUserData(currentUser.getID(), userData);
        MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            layoutCache.remove((Object)CacheKey.of(currentUser.getID()));
        }
    }

    public List<TicketPageExtensionDescription> getAllAvailableExtensions(UserAccount currentUser) {
        ArrayList<TicketPageExtensionDescription> extensions = new ArrayList<TicketPageExtensionDescription>();
        List ticketPageExtensions = ServerPluginManager.getInstance().get(TicketPageExtension.class);
        ticketPageExtensions.stream().filter(e -> e.isAvailable(currentUser)).forEach(e -> extensions.add(new TicketPageExtensionDescription(e.getExtensionName(), e.getDisplayName(), e.getDescription())));
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCacheEntriesForUser(GUID id) {
        MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            Iterator iterator = layoutCache.keySet().iterator();
            while (iterator.hasNext()) {
                CacheKey key = (CacheKey)iterator.next();
                if (!key.getId().equals((Object)id)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCacheEntriesForGroup(UserGroupInfo group) {
        MemoryStoreMap<CacheKey, TicketPageLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            if (UsersAndGroups.GROUPID_ALLUSERS.equals((Object)group.getID())) {
                layoutCache.clear();
            } else {
                Set memberIDs = group.getMemberIDs();
                Iterator iterator = layoutCache.keySet().iterator();
                while (iterator.hasNext()) {
                    CacheKey key = (CacheKey)iterator.next();
                    if (!memberIDs.contains(key.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    static class Singleton {
        private static TicketPageLayoutManager INSTANCE;

        Singleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        public static TicketPageLayoutManager getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<TicketPageLayoutManager> clazz = TicketPageLayoutManager.class;
            synchronized (TicketPageLayoutManager.class) {
                if (INSTANCE != null) return INSTANCE;
                INSTANCE = new TicketPageLayoutManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }
    }
}

