/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.taskplanner.TicketExportJob;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketExportJobFactory
extends JobFactory<TicketExportJob> {
    static final String EXPORT_EVERYTHING = "everything";
    static final String EXPORT_ONLY_ATTACHMENTS = "onlyattachments";
    static final String EXPORT_NO_ATTACHMENTS = "noattachments";
    static final String PROPERTY_EXPORT = "exportType";
    static final String EXPORT_HAS_FILES = "exportHasFiles";
    static final String EXPORT_HAS_NO_FILES = "exportHasNoFiles";
    static final String CONDITION_TYPE = "ticketlist.export.job.conditionType";

    public TicketExportJobFactory() {
        super("ticketlist.export.job");
    }

    protected TicketExportJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new TicketExportJob(definition);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return Collections.singletonList(ResultFlavor.FILE);
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        String name = TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.name", new Object[0]);
        String description = TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.description", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/server/images/export_32.png");
        String helpKey = "taskplanner.job.ticket-export";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.ticketid", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        ArrayList<LocalizedKey> exportTypes = new ArrayList<LocalizedKey>();
        exportTypes.add(new LocalizedKey(EXPORT_EVERYTHING, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.everything", new Object[0])));
        exportTypes.add(new LocalizedKey(EXPORT_ONLY_ATTACHMENTS, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.onlyattachments", new Object[0])));
        exportTypes.add(new LocalizedKey(EXPORT_NO_ATTACHMENTS, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.noattachments", new Object[0])));
        SelectField selectField = new SelectField(PROPERTY_EXPORT, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.exportType", new Object[0]), exportTypes);
        selectField.setValue(EXPORT_EVERYTHING);
        fields.add(selectField);
        ArrayList<SelectField> conditionFields = new ArrayList<SelectField>();
        ArrayList<LocalizedKey> conditionChoices = new ArrayList<LocalizedKey>();
        conditionChoices.add(new LocalizedKey(EXPORT_HAS_FILES, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.exportHasFiles", new Object[0])));
        conditionChoices.add(new LocalizedKey(EXPORT_HAS_NO_FILES, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.exportHasNoFiles", new Object[0])));
        SelectField conditionField = new SelectField(CONDITION_TYPE, TicketListServerPlugin.SERVER_MSG.getMsg(CONDITION_TYPE, new Object[0]), conditionChoices);
        conditionField.setValue(EXPORT_HAS_FILES);
        conditionFields.add(conditionField);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(conditionFields), fields, new ArrayList());
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.ticketid.missing", new Object[0])});
        }
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("Ticket ID");
        String exportType = definition.getProperty(PROPERTY_EXPORT);
        if (exportType == null) {
            exportType = EXPORT_EVERYTHING;
        }
        summary.add(new SummaryEntry(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.ticketid", new Object[0]), ticketId));
        summary.add(new SummaryEntry(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job." + exportType, new Object[0]), ""));
        ArrayList<SummaryEntry> conditionSummary = null;
        ConditionDefinition condition = definition.getCondition();
        if (condition != null) {
            String cond = null;
            String template = (String)condition.getProperties().get(CONDITION_TYPE);
            if (!StringFunctions.isEmpty((String)template)) {
                switch (template) {
                    case "exportHasFiles": {
                        cond = TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.exportHasFiles", new Object[0]);
                        break;
                    }
                    case "exportHasNoFiles": {
                        cond = TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.job.exportHasNoFiles", new Object[0]);
                        break;
                    }
                }
            }
            if (cond != null) {
                conditionSummary = new ArrayList<SummaryEntry>();
                conditionSummary.add(new SummaryEntry("", cond));
            }
        }
        return new JobSummaryInfo(summary, conditionSummary);
    }
}

