/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.http.error.ServletErrorHandler;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class TicketViewIcon
extends AbstractTicketListHandler<Void, Void> {
    private static final int DEFAULT_SIZE = 16;
    private static URL fallBackImageURL = null;

    public TicketViewIcon() {
        try {
            fallBackImageURL = TicketViewIcon.class.getResource("/com/inet/helpdesk/plugins/ticketlist/server/images/ticketviewfallback.png");
        }
        catch (Throwable t) {
            TicketListServerPlugin.LOGGER.error(t);
        }
    }

    public String getMethodName() {
        return "ticketlist.ticketviewicon";
    }

    @Override
    public short getMethodType() {
        return 2;
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        block7: {
            String viewID = request.getParameter("viewid");
            String iconKey = request.getParameter("iconkey");
            String requestedSize = request.getParameter("size");
            int requestedSizeInt = 16;
            try {
                requestedSizeInt = Integer.parseInt(requestedSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            URL iconURL = null;
            boolean iconCacheable = true;
            if (!StringFunctions.isEmpty((String)viewID)) {
                TicketViewManager tvm = (TicketViewManager)ServerPluginManager.getInstance().getSingleInstance(TicketViewManager.class);
                List ticketViewDefinitions = tvm.getViewDefinitions();
                for (TicketViewDefinition ticketViewDefinition : ticketViewDefinitions) {
                    if (ticketViewDefinition.getID() == null || !ticketViewDefinition.getID().equals(viewID) && (viewID == null || !viewID.startsWith(ticketViewDefinition.getID() + "."))) continue;
                    iconURL = ticketViewDefinition.getIconURL(iconKey, requestedSizeInt);
                    iconCacheable = !(ticketViewDefinition instanceof CustomTicketViewDefinition);
                    break;
                }
            }
            if (iconURL == null) {
                iconURL = fallBackImageURL;
            }
            try {
                AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (URL)iconURL, null, (String)"", (boolean)iconCacheable);
            }
            catch (IOException e) {
                if (ServletErrorHandler.isClientAbort((Throwable)e)) break block7;
                TicketListServerPlugin.LOGGER.error((Throwable)e);
            }
        }
        return null;
    }
}

