/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.field.SelectOption;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.CreateNewUserRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.CreateNewUserResponseData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CreateNewUser
extends AbstractTicketListHandler<CreateNewUserRequestData, CreateNewUserResponseData> {
    public String getMethodName() {
        return "ticketpage.createnewuser";
    }

    @Override
    protected CreateNewUserResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, CreateNewUserRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS})) {
            throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        }
        UserUpdateData userData = new UserUpdateData();
        for (Map.Entry<String, String> fieldInput : input.getFields().entrySet()) {
            Object actualNewValue;
            UserFieldDefinition<?> def;
            String key;
            block9: {
                key = fieldInput.getKey();
                String fieldValue = fieldInput.getValue();
                if (fieldValue == null || fieldValue.isBlank()) continue;
                def = this.findDefinitionByKey(key);
                actualNewValue = null;
                try {
                    actualNewValue = def.convertFromString(fieldValue);
                }
                catch (JsonException invaliud) {
                    TicketListServerPlugin.LOGGER.debug((Object)invaliud);
                    UserField userField = def.getUserField();
                    if (userField == null) break block9;
                    actualNewValue = userField.getDefaultValue();
                }
            }
            if (key.equals(HDUsersAndGroups.FIELD_LOCATION_ID.getKey()) && !StringFunctions.isEmpty((String)input.getNewLocationName())) {
                String newLocationName = input.getNewLocationName().trim();
                try {
                    List allLocations = LocationManager.getInstance().getAll(true);
                    LocationVO foundLocation = allLocations.stream().filter(l -> input.getNewLocationName().trim().equalsIgnoreCase(l.getDisplayValue())).findFirst().orElse(null);
                    if (foundLocation != null) {
                        actualNewValue = foundLocation.getId();
                    } else {
                        int locationId = LocationManager.getInstance().add((FieldVO)new LocationVO(-1, newLocationName, "", "", "", 0, false));
                        actualNewValue = locationId;
                    }
                }
                catch (SQLException e) {
                    TicketListServerPlugin.LOGGER.error((Throwable)e);
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)e));
                }
            }
            def.save(null, userData, actualNewValue);
        }
        UserAccount account = UserManager.getInstance().createUserAccount(UserAccountType.Standard, userData.getUserData());
        SelectOption option = new SelectOption(account.getID().toString(), account.getDisplayName(), account.getID().toString());
        return new CreateNewUserResponseData(option);
    }

    @Nonnull
    private UserFieldDefinition<?> findDefinitionByKey(String key) {
        List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Optional<FieldDefinition> optional = list.stream().filter(i -> i.getGroupingType() == Type.user && key.equals(i.getFieldKey())).findFirst();
        if (optional.isPresent()) {
            return (UserFieldDefinition)optional.get();
        }
        throw new IllegalArgumentException(String.format("Field with key '%s' does not exist", key));
    }
}

